"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvictionsMomiton = void 0;
const cdk = require("@aws-cdk/core");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// Reference: https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheMetrics.WhichShouldIMonitor.html#metrics-evictions
class EvictionsMomiton {
    static setup(scope, cacheClusterId) {
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-Evictions', {
            alarmName: `ElasticCacheEvictionsAlarm[${cacheClusterId}]`,
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'Evictions',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'max',
            }),
            threshold: 1,
            period: cdk.Duration.minutes(1),
            evaluationPeriods: 1,
            alarmDescription: 'Data evicted within one minute(We recommend that you determine your own alarm threshold for this metric based on your application needs)',
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.EvictionsMomiton = EvictionsMomiton;
//# sourceMappingURL=data:application/json;base64,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