import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectProtectedBranchConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the protected branch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branch#name DataGitlabProjectProtectedBranch#name}
    */
    readonly name: string;
    /**
    * The integer or path with namespace that uniquely identifies the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branch#project_id DataGitlabProjectProtectedBranch#project_id}
    */
    readonly projectId: string;
}
export interface DataGitlabProjectProtectedBranchMergeAccessLevels {
}
export declare function dataGitlabProjectProtectedBranchMergeAccessLevelsToTerraform(struct?: DataGitlabProjectProtectedBranchMergeAccessLevels): any;
export declare class DataGitlabProjectProtectedBranchMergeAccessLevelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectProtectedBranchMergeAccessLevels | undefined;
    set internalValue(value: DataGitlabProjectProtectedBranchMergeAccessLevels | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    get groupId(): number;
    get userId(): number;
}
export declare class DataGitlabProjectProtectedBranchMergeAccessLevelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectProtectedBranchMergeAccessLevelsOutputReference;
}
export interface DataGitlabProjectProtectedBranchPushAccessLevels {
}
export declare function dataGitlabProjectProtectedBranchPushAccessLevelsToTerraform(struct?: DataGitlabProjectProtectedBranchPushAccessLevels): any;
export declare class DataGitlabProjectProtectedBranchPushAccessLevelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectProtectedBranchPushAccessLevels | undefined;
    set internalValue(value: DataGitlabProjectProtectedBranchPushAccessLevels | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    get groupId(): number;
    get userId(): number;
}
export declare class DataGitlabProjectProtectedBranchPushAccessLevelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectProtectedBranchPushAccessLevelsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branch gitlab_project_protected_branch}
*/
export declare class DataGitlabProjectProtectedBranch extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_protected_branch";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branch gitlab_project_protected_branch} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectProtectedBranchConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectProtectedBranchConfig);
    get allowForcePush(): cdktf.IResolvable;
    get codeOwnerApprovalRequired(): cdktf.IResolvable;
    get id(): number;
    private _mergeAccessLevels;
    get mergeAccessLevels(): DataGitlabProjectProtectedBranchMergeAccessLevelsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _pushAccessLevels;
    get pushAccessLevels(): DataGitlabProjectProtectedBranchPushAccessLevelsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-project-protected-branch.d.ts.map