import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabInstanceVariablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variables#id DataGitlabInstanceVariables#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataGitlabInstanceVariablesVariables {
}
export declare function dataGitlabInstanceVariablesVariablesToTerraform(struct?: DataGitlabInstanceVariablesVariables): any;
export declare class DataGitlabInstanceVariablesVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabInstanceVariablesVariables | undefined;
    set internalValue(value: DataGitlabInstanceVariablesVariables | undefined);
    get key(): string;
    get masked(): cdktf.IResolvable;
    get protected(): cdktf.IResolvable;
    get value(): string;
    get variableType(): string;
}
export declare class DataGitlabInstanceVariablesVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabInstanceVariablesVariablesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variables gitlab_instance_variables}
*/
export declare class DataGitlabInstanceVariables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_instance_variables";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variables gitlab_instance_variables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabInstanceVariablesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabInstanceVariablesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _variables;
    get variables(): DataGitlabInstanceVariablesVariablesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-instance-variables.d.ts.map