import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabBranchConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/branch#id DataGitlabBranch#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the branch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/branch#name DataGitlabBranch#name}
    */
    readonly name: string;
    /**
    * The full path or id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/branch#project DataGitlabBranch#project}
    */
    readonly project: string;
}
export interface DataGitlabBranchCommit {
}
export declare function dataGitlabBranchCommitToTerraform(struct?: DataGitlabBranchCommit): any;
export declare class DataGitlabBranchCommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabBranchCommit | undefined;
    set internalValue(value: DataGitlabBranchCommit | undefined);
    get authorEmail(): string;
    get authorName(): string;
    get authoredDate(): string;
    get committedDate(): string;
    get committerEmail(): string;
    get committerName(): string;
    get id(): string;
    get message(): string;
    get parentIds(): string[];
    get shortId(): string;
    get title(): string;
}
export declare class DataGitlabBranchCommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabBranchCommitOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/branch gitlab_branch}
*/
export declare class DataGitlabBranch extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_branch";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/branch gitlab_branch} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabBranchConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabBranchConfig);
    get canPush(): cdktf.IResolvable;
    private _commit;
    get commit(): DataGitlabBranchCommitList;
    get default(): cdktf.IResolvable;
    get developerCanMerge(): cdktf.IResolvable;
    get developerCanPush(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get merged(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get protected(): cdktf.IResolvable;
    get webUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-branch.d.ts.map