#!/usr/bin/env python3
#_*_ coding:utf-8 _*_
from src.diPwm import create_diPwm
from src.Super import InitSuperDiPwm, search_super

def rounded_di(M):
	return {k : round(v,6) for k,v in M.items()}

def test_init_super():
	pathDiPwm = "./data/ATF3_HUMAN.H11DI.0.A.dpwm"
	A = create_diPwm(pathDiPwm)
	L = InitSuperDiPwm(A,3)
    # L = InitSuperDiPwm(A,3)
	# print([(a,b,rounded_di(x)) for (a,b,x) in L])

	assert [(a,b,rounded_di(x)) for (a,b,x) in L] == [(0, 2, {0: -2.263908, 1: -2.872247, 2: -4.688562, 3: 0.987943, 4: -5.854205, 5: -7.128053, 6: -7.128053, 7: -4.498116, 8: -0.516316, 9: -1.037261, 10: -1.037261, 11: 3.362595, 12: -8.944368, 13: -8.944368, 14: -8.944368, 15: -6.77832, 16: -5.06449, 17: -5.672828, 18: -7.489143, 19: -1.812638, 20: -8.227826, 21: -9.501673, 22: -9.501673, 23: -6.871736, 24: -3.114043, 25: -3.634988, 26: -3.634988, 27: 0.764867, 28: -10.77552, 29: -10.77552, 30: -10.77552, 31: -8.609473, 32: -0.643417, 33: -1.251755, 34: -3.06807, 35: 2.608435, 36: -4.855907, 37: -6.129755, 38: -6.129755, 39: -3.499818, 40: 0.885709, 41: 0.364764, 42: 0.364764, 43: 4.764619, 44: -6.129755, 45: -6.129755, 46: -6.129755, 47: -3.963707, 48: -4.416606, 49: -5.024944, 50: -6.84126, 51: -1.164754, 52: -8.853789, 53: -10.127637, 54: -10.127637, 55: -7.4977, 56: -2.588596, 57: -3.109541, 58: -3.109541, 59: 1.290314, 60: -10.127637, 61: -10.127637, 62: -10.127637, 63: -7.961589, 64: -1.851027, 65: -2.459366, 66: -4.275681, 67: 1.400824, 68: -5.441324, 69: -6.715172, 70: -6.715172, 71: -4.085235, 72: -0.103435, 73: -0.62438, 74: -0.62438, 75: 3.775475, 76: -8.531487, 77: -8.531487, 78: -8.531487, 79: -6.365439, 80: -3.52849, 81: -4.136829, 82: -5.953144, 83: -0.276639, 84: -6.691826, 85: -7.965674, 86: -7.965674, 87: -5.335737, 88: -1.578044, 89: -2.098989, 90: -2.098989, 91: 2.300866, 92: -9.239521, 93: -9.239521, 94: -9.239521, 95: -7.073474, 96: -0.202869, 97: -0.811208, 98: -2.627523, 99: 3.048982, 100: -4.41536, 101: -5.689207, 102: -5.689207, 103: -3.05927, 104: 1.326257, 105: 0.805311, 106: 0.805311, 107: 5.205167, 108: -5.689207, 109: -5.689207, 110: -5.689207, 111: -3.52316, 112: -3.309164, 113: -3.917503, 114: -5.733818, 115: -0.057313, 116: -7.746348, 117: -9.020195, 118: -9.020195, 119: -6.390258, 120: -1.481154, 121: -2.0021, 122: -2.0021, 123: 2.397756, 124: -9.020195, 125: -9.020195, 126: -9.020195, 127: -6.854147, 128: -1.952667, 129: -2.561006, 130: -4.377321, 131: 1.299184, 132: -5.542965, 133: -6.816812, 134: -6.816812, 135: -4.186875, 136: -0.205075, 137: -0.72602, 138: -0.72602, 139: 3.673835, 140: -8.633127, 141: -8.633127, 142: -8.633127, 143: -6.467079, 144: -3.52849, 145: -4.136829, 146: -5.953144, 147: -0.276639, 148: -6.691826, 149: -7.965674, 150: -7.965674, 151: -5.335737, 152: -1.578044, 153: -2.098989, 154: -2.098989, 155: 2.300866, 156: -9.239521, 157: -9.239521, 158: -9.239521, 159: -7.073474, 160: -0.292802, 161: -0.90114, 162: -2.717456, 163: 2.95905, 164: -4.505293, 165: -5.77914, 166: -5.77914, 167: -3.149203, 168: 1.236324, 169: 0.715379, 170: 0.715379, 171: 5.115234, 172: -5.77914, 173: -5.77914, 174: -5.77914, 175: -3.613092, 176: -4.416606, 177: -5.024944, 178: -6.84126, 179: -1.164754, 180: -8.853789, 181: -10.127637, 182: -10.127637, 183: -7.4977, 184: -2.588596, 185: -3.109541, 186: -3.109541, 187: 1.290314, 188: -10.127637, 189: -10.127637, 190: -10.127637, 191: -7.961589, 192: -2.718224, 193: -3.326563, 194: -5.142878, 195: 0.533627, 196: -6.308521, 197: -7.582369, 198: -7.582369, 199: -4.952432, 200: -0.970632, 201: -1.491577, 202: -1.491577, 203: 2.908279, 204: -9.398684, 205: -9.398684, 206: -9.398684, 207: -7.232636, 208: -4.202766, 209: -4.811105, 210: -6.62742, 211: -0.950915, 212: -7.366102, 213: -8.63995, 214: -8.63995, 215: -6.010013, 216: -2.25232, 217: -2.773265, 218: -2.773265, 219: 1.626591, 220: -9.913797, 221: -9.913797, 222: -9.913797, 223: -7.747749, 224: -0.362382, 225: -0.970721, 226: -2.787036, 227: 2.889469, 228: -4.574873, 229: -5.84872, 230: -5.84872, 231: -3.218783, 232: 1.166744, 233: 0.645798, 234: 0.645798, 235: 5.045654, 236: -5.84872, 237: -5.84872, 238: -5.84872, 239: -3.682673, 240: -4.543544, 241: -5.151883, 242: -6.968198, 243: -1.291693, 244: -8.980728, 245: -10.254575, 246: -10.254575, 247: -7.624638, 248: -2.715534, 249: -3.23648, 250: -3.23648, 251: 1.163376, 252: -10.254575, 253: -10.254575, 254: -10.254575, 255: -8.088527}), (3, 5, {0: -8.198697, 1: -4.520924, 2: -8.097482, 3: -6.128873, 4: -13.200174, 5: -10.015012, 6: -11.926327, 7: -11.926327, 8: -13.200174, 9: -10.400002, 10: -11.926327, 11: -10.570237, 12: -11.034126, 13: -10.254575, 14: -13.200174, 15: -11.034126, 16: -1.653151, 17: 2.024621, 18: -1.551936, 19: 0.416673, 20: -8.583687, 21: -5.398525, 22: -7.30984, 23: -7.30984, 24: -8.198697, 25: -5.398525, 26: -6.924849, 27: -5.56876, 28: -9.217811, 29: -8.43826, 30: -11.383859, 31: -9.217811, 32: -0.528644, 33: 3.149128, 34: -0.427429, 35: 1.54118, 36: -7.28386, 37: -4.098698, 38: -6.010013, 39: -6.010013, 40: -7.747749, 41: -4.947577, 42: -6.473902, 43: -5.117812, 44: -4.207674, 45: -3.428122, 46: -6.373721, 47: -4.207674, 48: -8.741164, 49: -5.063392, 50: -8.63995, 51: -6.67134, 52: -13.200174, 53: -10.015012, 54: -11.926327, 55: -11.926327, 56: -13.200174, 57: -10.400002, 58: -11.926327, 59: -10.570237, 60: -11.034126, 61: -10.254575, 62: -13.200174, 63: -11.034126, 64: -8.198697, 65: -4.520924, 66: -8.097482, 67: -6.128873, 68: -13.200174, 69: -10.015012, 70: -11.926327, 71: -11.926327, 72: -13.200174, 73: -10.400002, 74: -11.926327, 75: -10.570237, 76: -11.034126, 77: -10.254575, 78: -13.200174, 79: -11.034126, 80: -0.669294, 81: 3.008478, 82: -0.56808, 83: 1.40053, 84: -7.59983, 85: -4.414668, 86: -6.325983, 87: -6.325983, 88: -7.21484, 89: -4.414668, 90: -5.940992, 91: -4.584903, 92: -8.233954, 93: -7.454403, 94: -10.400002, 95: -8.233954, 96: -3.815021, 97: -0.137249, 98: -3.713806, 99: -1.745197, 100: -10.570237, 101: -7.385075, 102: -9.29639, 103: -9.29639, 104: -11.034126, 105: -8.233954, 106: -9.760279, 107: -8.404189, 108: -7.494051, 109: -6.714499, 110: -9.660098, 111: -7.494051, 112: -8.741164, 113: -5.063392, 114: -8.63995, 115: -6.67134, 116: -13.200174, 117: -10.015012, 118: -11.926327, 119: -11.926327, 120: -13.200174, 121: -10.400002, 122: -11.926327, 123: -10.570237, 124: -11.034126, 125: -10.254575, 126: -13.200174, 127: -11.034126, 128: -8.198697, 129: -4.520924, 130: -8.097482, 131: -6.128873, 132: -13.200174, 133: -10.015012, 134: -11.926327, 135: -11.926327, 136: -13.200174, 137: -10.400002, 138: -11.926327, 139: -10.570237, 140: -11.034126, 141: -10.254575, 142: -13.200174, 143: -11.034126, 144: -2.195619, 145: 1.482153, 146: -2.094404, 147: -0.125795, 148: -9.126155, 149: -5.940992, 150: -7.852307, 151: -7.852307, 152: -8.741164, 153: -5.940992, 154: -7.467317, 155: -6.111227, 156: -9.760279, 157: -8.980728, 158: -11.926327, 159: -9.760279, 160: -1.648973, 161: 2.028799, 162: -1.547758, 163: 0.420851, 164: -8.404189, 165: -5.219027, 166: -7.130342, 167: -7.130342, 168: -8.868079, 169: -6.067907, 170: -7.594231, 171: -6.238142, 172: -5.328003, 173: -4.548452, 174: -7.494051, 175: -5.328003, 176: -8.741164, 177: -5.063392, 178: -8.63995, 179: -6.67134, 180: -13.200174, 181: -10.015012, 182: -11.926327, 183: -11.926327, 184: -13.200174, 185: -10.400002, 186: -11.926327, 187: -10.570237, 188: -11.034126, 189: -10.254575, 190: -13.200174, 191: -11.034126, 192: -6.382381, 193: -2.704609, 194: -6.281167, 195: -4.312557, 196: -11.383859, 197: -8.198697, 198: -10.110012, 199: -10.110012, 200: -11.383859, 201: -8.583687, 202: -10.110012, 203: -8.753922, 204: -9.217811, 205: -8.43826, 206: -11.383859, 207: -9.217811, 208: 3.098027, 209: 6.775799, 210: 3.199242, 211: 5.167851, 212: -3.832509, 213: -0.647347, 214: -2.558662, 215: -2.558662, 216: -3.447519, 217: -0.647347, 218: -2.173671, 219: -0.817582, 220: -4.466633, 221: -3.687082, 222: -6.632681, 223: -4.466633, 224: 2.42592, 225: 6.103692, 226: 2.527135, 227: 4.495744, 228: -4.329296, 229: -1.144134, 230: -3.055449, 231: -3.055449, 232: -4.793186, 233: -1.993014, 234: -3.519338, 235: -2.163249, 236: -1.25311, 237: -0.473559, 238: -3.419158, 239: -1.25311, 240: -7.467317, 241: -3.789545, 242: -7.366102, 243: -5.397493, 244: -11.926327, 245: -8.741164, 246: -10.652479, 247: -10.652479, 248: -11.926327, 249: -9.126155, 250: -10.652479, 251: -9.29639, 252: -9.760279, 253: -8.980728, 254: -11.926327, 255: -9.760279}), (6, 8, {0: -10.570237, 1: -11.034126, 2: -10.254575, 3: -13.200174, 4: -6.879843, 5: -9.126155, 6: -7.670521, 7: -9.501673, 8: -11.926327, 9: -13.200174, 10: -10.77552, 11: -13.200174, 12: -4.77572, 13: -4.329964, 14: -2.797222, 15: -5.485361, 16: -10.570237, 17: -11.034126, 18: -10.254575, 19: -13.200174, 20: -8.153691, 21: -10.400002, 22: -8.944368, 23: -10.77552, 24: -11.926327, 25: -13.200174, 26: -10.77552, 27: -13.200174, 28: -6.467079, 29: -6.021323, 30: -4.488581, 31: -7.17672, 32: -3.579845, 33: -4.043735, 34: -3.264183, 35: -6.209782, 36: 0.738664, 37: -1.507648, 38: -0.052013, 39: -1.883166, 40: -6.12339, 41: -7.397238, 42: -4.972584, 43: -7.397238, 44: 1.566863, 45: 2.012619, 46: 3.545361, 47: 0.857222, 48: -8.022542, 49: -8.486432, 50: -7.70688, 51: -10.652479, 52: -6.879843, 53: -9.126155, 54: -7.670521, 55: -9.501673, 56: -9.378632, 57: -10.652479, 58: -8.227826, 59: -10.652479, 60: -4.559108, 61: -4.113351, 62: -2.580609, 63: -5.268748, 64: -6.659875, 65: -7.123765, 66: -6.344213, 67: -9.289812, 68: -2.969482, 69: -5.215793, 70: -3.760159, 71: -5.591311, 72: -8.015965, 73: -9.289812, 74: -6.865159, 75: -9.289812, 76: -0.865359, 77: -0.419602, 78: 1.11314, 79: -1.574999, 80: -8.753922, 81: -9.217811, 82: -8.43826, 83: -11.383859, 84: -6.337376, 85: -8.583687, 86: -7.128053, 87: -8.959205, 88: -10.110012, 89: -11.383859, 90: -8.959205, 91: -11.383859, 92: -4.650764, 93: -4.205008, 94: -2.672266, 95: -5.360404, 96: -0.106022, 97: -0.569911, 98: 0.20964, 99: -2.735959, 100: 4.212487, 101: 1.966176, 102: 3.42181, 103: 1.590657, 104: -2.649567, 105: -3.923415, 106: -1.498761, 107: -3.923415, 108: 5.040686, 109: 5.486442, 110: 7.019184, 111: 4.331046, 112: -6.666453, 113: -7.130342, 114: -6.350791, 115: -9.29639, 116: -5.523754, 117: -7.770065, 118: -6.314431, 119: -8.145583, 120: -8.022542, 121: -9.29639, 122: -6.871736, 123: -9.29639, 124: -3.203018, 125: -2.757262, 126: -1.22452, 127: -3.912658, 128: -10.570237, 129: -11.034126, 130: -10.254575, 131: -13.200174, 132: -6.879843, 133: -9.126155, 134: -7.670521, 135: -9.501673, 136: -11.926327, 137: -13.200174, 138: -10.77552, 139: -13.200174, 140: -4.77572, 141: -4.329964, 142: -2.797222, 143: -5.485361, 144: -10.570237, 145: -11.034126, 146: -10.254575, 147: -13.200174, 148: -8.153691, 149: -10.400002, 150: -8.944368, 151: -10.77552, 152: -11.926327, 153: -13.200174, 154: -10.77552, 155: -13.200174, 156: -6.467079, 157: -6.021323, 158: -4.488581, 159: -7.17672, 160: -3.49568, 161: -3.959569, 162: -3.180018, 163: -6.125617, 164: 0.822829, 165: -1.423482, 166: 0.032152, 167: -1.799001, 168: -6.039225, 169: -7.313073, 170: -4.888419, 171: -7.313073, 172: 1.651028, 173: 2.096784, 174: 3.629526, 175: 0.941388, 176: -9.29639, 177: -9.760279, 178: -8.980728, 179: -11.926327, 180: -8.153691, 181: -10.400002, 182: -8.944368, 183: -10.77552, 184: -10.652479, 185: -11.926327, 186: -9.501673, 187: -11.926327, 188: -5.832955, 189: -5.387199, 190: -3.854457, 191: -6.542595, 192: -10.570237, 193: -11.034126, 194: -10.254575, 195: -13.200174, 196: -6.879843, 197: -9.126155, 198: -7.670521, 199: -9.501673, 200: -11.926327, 201: -13.200174, 202: -10.77552, 203: -13.200174, 204: -4.77572, 205: -4.329964, 206: -2.797222, 207: -5.485361, 208: -9.29639, 209: -9.760279, 210: -8.980728, 211: -11.926327, 212: -6.879843, 213: -9.126155, 214: -7.670521, 215: -9.501673, 216: -10.652479, 217: -11.926327, 218: -9.501673, 219: -11.926327, 220: -5.193232, 221: -4.747475, 222: -3.214733, 223: -5.902872, 224: -1.625572, 225: -2.089461, 226: -1.30991, 227: -4.255509, 228: 2.692937, 229: 0.446626, 230: 1.90226, 231: 0.071108, 232: -4.169117, 233: -5.442964, 234: -3.018311, 235: -5.442964, 236: 3.521136, 237: 3.966893, 238: 5.499635, 239: 2.811496, 240: -7.480075, 241: -7.943964, 242: -7.164412, 243: -10.110012, 244: -6.337376, 245: -8.583687, 246: -7.128053, 247: -8.959205, 248: -8.836164, 249: -10.110012, 250: -7.685358, 251: -10.110012, 252: -4.01664, 253: -3.570883, 254: -2.038141, 255: -4.72628}), (9, 10, {0: 0.281135, 1: 1.954952, 2: 1.703329, 3: 1.526933, 4: -1.725559, 5: -0.795882, 6: -1.647931, 7: -1.90163, 8: -1.771478, 9: -0.011372, 10: -0.253792, 11: -0.766188, 12: -4.004131, 13: -4.353864, 14: -2.985017, 15: -3.370007, 16: 0.033525, 17: 1.707343, 18: 1.45572, 19: 1.279323, 20: -2.707731, 21: -1.778054, 22: -2.630103, 23: -2.883802, 24: -2.441202, 25: -0.681095, 26: -0.923515, 27: -1.435912, 28: -5.360221, 29: -5.709953, 30: -4.341106, 31: -4.726097, 32: 0.993196, 33: 2.667013, 34: 2.41539, 35: 2.238993, 36: -0.599004, 37: 0.330673, 38: -0.521376, 39: -0.775074, 40: 0.171547, 41: 1.931653, 42: 1.689234, 43: 1.176837, 44: -3.255786, 45: -3.605518, 46: -2.236671, 47: -2.621662, 48: -1.704592, 49: -0.030775, 50: -0.282398, 51: -0.458795, 52: -3.171621, 53: -2.241943, 54: -3.093993, 55: -3.347691, 56: -2.56814, 57: -0.808034, 58: -1.050453, 59: -1.56285, 60: -4.468021, 61: -4.817753, 62: -3.448906, 63: -3.833896})]


def test_search_super():
	pathDiPwm = "./data/ATF3_HUMAN.H11DI.0.A.dpwm"
	A = create_diPwm(pathDiPwm)
	text = open("./data/sequence.txt").readlines()[0]

	nb = 0
	for i,mot,score in search_super(A,text,0,3):
		nb += 1

	assert nb == 57
