"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUser = exports.NotificationRuleType = exports.ContactMethodType = exports.toJson_NotificationRule = exports.toJson_ContactMethod = exports.CfnUserPropsRole = exports.toJson_CfnUserProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUserProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Email': obj.email,
        'TimeZone': obj.timeZone,
        'Color': obj.color,
        'Role': obj.role,
        'Description': obj.description,
        'JobTitle': obj.jobTitle,
        'ContactMethods': obj.contactMethods?.map(y => toJson_ContactMethod(y)),
        'NotificationRules': obj.notificationRules?.map(y => toJson_NotificationRule(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUserProps = toJson_CfnUserProps;
/* eslint-enable max-len, quote-props */
/**
 * The user role. Account must have the read_only_users ability to set a user as a read_only_user or a read_only_limited_user, and must have advanced permissions abilities to set a user as observer or restricted_access.
 *
 * @schema CfnUserPropsRole
 */
var CfnUserPropsRole;
(function (CfnUserPropsRole) {
    /** admin */
    CfnUserPropsRole["ADMIN"] = "admin";
    /** limited_user */
    CfnUserPropsRole["LIMITED_USER"] = "limited_user";
    /** observer */
    CfnUserPropsRole["OBSERVER"] = "observer";
    /** owner */
    CfnUserPropsRole["OWNER"] = "owner";
    /** read_only_user */
    CfnUserPropsRole["READ_ONLY_USER"] = "read_only_user";
    /** restricted_access */
    CfnUserPropsRole["RESTRICTED_ACCESS"] = "restricted_access";
    /** read_only_limited_user */
    CfnUserPropsRole["READ_ONLY_LIMITED_USER"] = "read_only_limited_user";
    /** user */
    CfnUserPropsRole["USER"] = "user";
})(CfnUserPropsRole = exports.CfnUserPropsRole || (exports.CfnUserPropsRole = {}));
/**
 * Converts an object of type 'ContactMethod' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ContactMethod(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Id': obj.id,
        'Summary': obj.summary,
        'HtmlUrl': obj.htmlUrl,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ContactMethod = toJson_ContactMethod;
/**
 * Converts an object of type 'NotificationRule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_NotificationRule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Id': obj.id,
        'Summary': obj.summary,
        'HtmlUrl': obj.htmlUrl,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_NotificationRule = toJson_NotificationRule;
/* eslint-enable max-len, quote-props */
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema ContactMethodType
 */
var ContactMethodType;
(function (ContactMethodType) {
    /** email_contact_method_reference */
    ContactMethodType["EMAIL_CONTACT_METHOD_REFERENCE"] = "email_contact_method_reference";
    /** phone_contact_method_reference */
    ContactMethodType["PHONE_CONTACT_METHOD_REFERENCE"] = "phone_contact_method_reference";
    /** push_notification_contact_method_reference */
    ContactMethodType["PUSH_NOTIFICATION_CONTACT_METHOD_REFERENCE"] = "push_notification_contact_method_reference";
    /** sms_contact_method_reference */
    ContactMethodType["SMS_CONTACT_METHOD_REFERENCE"] = "sms_contact_method_reference";
})(ContactMethodType = exports.ContactMethodType || (exports.ContactMethodType = {}));
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema NotificationRuleType
 */
var NotificationRuleType;
(function (NotificationRuleType) {
    /** assignment_notification_rule_reference */
    NotificationRuleType["ASSIGNMENT_NOTIFICATION_RULE_REFERENCE"] = "assignment_notification_rule_reference";
})(NotificationRuleType = exports.NotificationRuleType || (exports.NotificationRuleType = {}));
/**
 * A CloudFormation `PagerDuty::Users::User`
 *
 * @cloudformationResource PagerDuty::Users::User
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
 */
class CfnUser extends cdk.CfnResource {
    /**
     * Create a new `PagerDuty::Users::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUser.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUserProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrSummary = cdk.Token.asString(this.getAtt('Summary'));
        this.attrType = cdk.Token.asString(this.getAtt('Type'));
        this.attrHtmlUrl = cdk.Token.asString(this.getAtt('HtmlUrl'));
        this.attrAvatarUrl = cdk.Token.asString(this.getAtt('AvatarUrl'));
        this.attrInvitationSent = this.getAtt('InvitationSent');
    }
}
exports.CfnUser = CfnUser;
_a = JSII_RTTI_SYMBOL_1;
CfnUser[_a] = { fqn: "@cdk-cloudformation/pagerduty-users-user.CfnUser", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnUser.CFN_RESOURCE_TYPE_NAME = "PagerDuty::Users::User";
//# sourceMappingURL=data:application/json;base64,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