"use strict";
// Copyright (c) Binh Vu
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
class SlowJSCallbackModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: SlowJSCallbackModel.model_name, _model_module: SlowJSCallbackModel.model_module, _model_module_version: SlowJSCallbackModel.model_module_version, _view_name: SlowJSCallbackModel.view_name, _view_module: SlowJSCallbackModel.view_module, _view_module_version: SlowJSCallbackModel.view_module_version, value: [0, ''] });
    }
}
exports.SlowJSCallbackModel = SlowJSCallbackModel;
SlowJSCallbackModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
SlowJSCallbackModel.model_name = 'SlowJSCallbackModel';
SlowJSCallbackModel.model_module = version_1.MODULE_NAME;
SlowJSCallbackModel.model_module_version = version_1.MODULE_VERSION;
SlowJSCallbackModel.view_name = 'SlowJSCallbackView'; // Set to null if no view
SlowJSCallbackModel.view_module = version_1.MODULE_NAME; // Set to null if no view
SlowJSCallbackModel.view_module_version = version_1.MODULE_VERSION;
class SlowJSCallbackView extends base_1.DOMWidgetView {
    render() {
        // do not display this in the dom
        this.el.classList.add('ipycallback');
        // register this view to the global variable.
        if (window.IPyCallback === undefined) {
            window.IPyCallback = new Map();
        }
        window.IPyCallback.set(this.model.model_id, this);
    }
    send_msg(msg) {
        let value = this.model.get('value');
        this.model.set('value', [value[0] + 1, msg]);
        this.model.save_changes();
    }
}
exports.SlowJSCallbackView = SlowJSCallbackView;
//# sourceMappingURL=widget.js.map