/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.CoreTokenFactory;
import edu.stanford.nlp.process.LexedTokenFactory;
import java.io.Serializable;

public class CoreLabelTokenFactory
implements CoreTokenFactory<CoreLabel>,
LexedTokenFactory<CoreLabel>,
Serializable {
    private final boolean addIndices;
    private static final long serialVersionUID = 4L;

    public CoreLabelTokenFactory() {
        this(true);
    }

    public CoreLabelTokenFactory(boolean addIndices) {
        this.addIndices = addIndices;
    }

    @Override
    public CoreLabel makeToken(String tokenText, int begin, int length) {
        return this.makeToken(tokenText, tokenText, begin, length);
    }

    public CoreLabel makeToken(String tokenText, String originalText, int begin, int length) {
        CoreLabel cl = this.addIndices ? new CoreLabel(5) : new CoreLabel();
        cl.setValue(tokenText);
        cl.setWord(tokenText);
        cl.setOriginalText(originalText);
        if (this.addIndices) {
            cl.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
            cl.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, begin + length);
        }
        return cl;
    }

    @Override
    public CoreLabel makeToken() {
        CoreLabel l = new CoreLabel();
        return l;
    }

    @Override
    public CoreLabel makeToken(String[] keys, String[] values) {
        CoreLabel l = new CoreLabel(keys, values);
        return l;
    }

    @Override
    public CoreLabel makeToken(CoreLabel labelToBeCopied) {
        CoreLabel l = new CoreLabel(labelToBeCopied);
        return l;
    }
}

