/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.util.ConvertByteArray;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class ResultStoringMonitor
implements Function {
    private static Redwood.RedwoodChannels log = Redwood.channels(ResultStoringMonitor.class);
    int i = 0;
    final int outputFreq;
    final String filename;

    public ResultStoringMonitor(int outputFreq, String filename) {
        this.filename = filename.lastIndexOf(46) >= 0 ? filename.substring(0, filename.lastIndexOf(46)) + ".ddat" : filename + ".ddat";
        this.outputFreq = outputFreq;
    }

    @Override
    public double valueAt(double[] x) {
        if (++this.i % this.outputFreq == 0) {
            log.info("Storing interim (double) weights to " + this.filename + " ... ");
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(this.filename))));
                ConvertByteArray.saveDoubleArr(dos, x);
                dos.close();
            }
            catch (IOException e) {
                log.error("!");
                return 1.0;
            }
            log.info("DONE.");
        }
        return 0.0;
    }

    @Override
    public int domainDimension() {
        return 0;
    }
}

