/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFormatter;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringParsingTask;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticGraph
implements Serializable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SemanticGraph.class);
    public static final boolean addSRLArcs = false;
    private static final SemanticGraphFormatter formatter = new SemanticGraphFormatter();
    private final Collection<IndexedWord> roots;
    private final DirectedMultiGraph<IndexedWord, SemanticGraphEdge> graph;
    private static final MapFactory<IndexedWord, Map<IndexedWord, List<SemanticGraphEdge>>> outerMapFactory = MapFactory.hashMapFactory();
    private static final MapFactory<IndexedWord, List<SemanticGraphEdge>> innerMapFactory = MapFactory.hashMapFactory();
    private static final MapFactory<IndexedWord, IndexedWord> wordMapFactory = MapFactory.hashMapFactory();
    private LinkedList<String> comments = new LinkedList();
    private static final Pattern WORD_AND_INDEX_PATTERN = Pattern.compile("([^-]+)-([0-9]+)");
    private static final long serialVersionUID = 1L;

    public int edgeCount() {
        return this.graph.getNumEdges();
    }

    public int outDegree(IndexedWord vertex) {
        return this.graph.getOutDegree(vertex);
    }

    public int inDegree(IndexedWord vertex) {
        return this.graph.getInDegree(vertex);
    }

    public List<SemanticGraphEdge> getAllEdges(IndexedWord gov, IndexedWord dep) {
        return this.graph.getEdges(gov, dep);
    }

    public SemanticGraphEdge getEdge(IndexedWord gov, IndexedWord dep) {
        List<SemanticGraphEdge> edges = this.graph.getEdges(gov, dep);
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    public void addVertex(IndexedWord vertex) {
        this.graph.addVertex(vertex);
    }

    public boolean containsVertex(IndexedWord vertex) {
        return this.graph.containsVertex(vertex);
    }

    public boolean containsEdge(IndexedWord source, IndexedWord target) {
        return this.graph.isEdge(source, target);
    }

    public boolean containsEdge(SemanticGraphEdge edge) {
        return this.containsEdge(edge.getSource(), edge.getTarget());
    }

    public Set<IndexedWord> vertexSet() {
        return this.graph.getAllVertices();
    }

    public boolean removeEdge(SemanticGraphEdge e) {
        return this.graph.removeEdge(e.getSource(), e.getTarget(), e);
    }

    public boolean removeVertex(IndexedWord vertex) {
        return this.graph.removeVertex(vertex);
    }

    public List<IndexedWord> vertexListSorted() {
        ArrayList<IndexedWord> vList = new ArrayList<IndexedWord>(this.vertexSet());
        Collections.sort(vList);
        return vList;
    }

    public List<SemanticGraphEdge> edgeListSorted() {
        ArrayList<SemanticGraphEdge> edgeList = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.edgeIterable()) {
            edgeList.add(edge);
        }
        edgeList.sort(SemanticGraphEdge.orderByTargetComparator());
        return edgeList;
    }

    public Iterable<SemanticGraphEdge> edgeIterable() {
        return this.graph.edgeIterable();
    }

    public Iterator<SemanticGraphEdge> outgoingEdgeIterator(IndexedWord v) {
        return this.graph.outgoingEdgeIterator(v);
    }

    public Iterable<SemanticGraphEdge> outgoingEdgeIterable(IndexedWord v) {
        return this.graph.outgoingEdgeIterable(v);
    }

    public Iterator<SemanticGraphEdge> incomingEdgeIterator(IndexedWord v) {
        return this.graph.incomingEdgeIterator(v);
    }

    public Iterable<SemanticGraphEdge> incomingEdgeIterable(IndexedWord v) {
        return this.graph.incomingEdgeIterable(v);
    }

    public List<SemanticGraphEdge> outgoingEdgeList(IndexedWord v) {
        return CollectionUtils.toList(this.outgoingEdgeIterable(v));
    }

    public List<SemanticGraphEdge> incomingEdgeList(IndexedWord v) {
        return CollectionUtils.toList(this.incomingEdgeIterable(v));
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public int isAncestor(IndexedWord child, IndexedWord ancestor) {
        Set<IndexedWord> parents = this.getParents(child);
        if (parents.contains(ancestor)) {
            return 1;
        }
        for (IndexedWord parent : parents) {
            Set<IndexedWord> grandparents = this.getParents(parent);
            if (!grandparents.contains(ancestor)) continue;
            return 2;
        }
        return -1;
    }

    public int commonAncestor(IndexedWord v1, IndexedWord v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        Set<IndexedWord> v1Parents = this.getParents(v1);
        Set<IndexedWord> v2Parents = this.getParents(v2);
        Set<IndexedWord> v1GrandParents = wordMapFactory.newSet();
        Set<IndexedWord> v2GrandParents = wordMapFactory.newSet();
        if (v1Parents.contains(v2) || v2Parents.contains(v1)) {
            return 1;
        }
        for (IndexedWord v1Parent : v1Parents) {
            if (v2Parents.contains(v1Parent)) {
                return 1;
            }
            v1GrandParents.addAll(this.getParents(v1Parent));
        }
        for (IndexedWord v2Parent : v2Parents) {
            v2GrandParents.addAll(this.getParentList(v2Parent));
        }
        if (v1GrandParents.contains(v2) || v2GrandParents.contains(v1)) {
            return 2;
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (!v1Parents.contains(v2GrandParent)) continue;
            return 2;
        }
        for (IndexedWord v1GrandParent : v1GrandParents) {
            if (!v2Parents.contains(v1GrandParent)) continue;
            return 2;
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (!v1GrandParents.contains(v2GrandParent)) continue;
            return 2;
        }
        return -1;
    }

    public IndexedWord getCommonAncestor(IndexedWord v1, IndexedWord v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        if (this.isAncestor(v1, v2) >= 1) {
            return v2;
        }
        if (this.isAncestor(v2, v1) >= 1) {
            return v1;
        }
        Set<IndexedWord> v1Parents = this.getParents(v1);
        Set<IndexedWord> v2Parents = this.getParents(v2);
        Set<IndexedWord> v1GrandParents = wordMapFactory.newSet();
        Set<IndexedWord> v2GrandParents = wordMapFactory.newSet();
        for (IndexedWord v1Parent : v1Parents) {
            if (v2Parents.contains(v1Parent)) {
                return v1Parent;
            }
            v1GrandParents.addAll(this.getParents(v1Parent));
        }
        for (IndexedWord v1GrandParent : v1GrandParents) {
            if (!v2Parents.contains(v1GrandParent)) continue;
            return v1GrandParent;
        }
        for (IndexedWord v2Parent : v2Parents) {
            v2GrandParents.addAll(this.getParents(v2Parent));
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (v1Parents.contains(v2GrandParent)) {
                return v2GrandParent;
            }
            if (!v1GrandParents.contains(v2GrandParent)) continue;
            return v2GrandParent;
        }
        return null;
    }

    public boolean matchPatternToVertex(String pattern, IndexedWord vertex, boolean det) {
        String[] nodePath;
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        String pat = pattern.replaceAll("<", ",<");
        pat = pat.replaceAll(">", ",>");
        for (String s : nodePath = pat.split(",")) {
            if (s.isEmpty()) continue;
            String word = s.substring(1);
            char dir = s.charAt(0);
            if (dir == '<') {
                boolean match = false;
                for (IndexedWord parent : this.getParents(vertex)) {
                    String lemma = (String)parent.get(CoreAnnotations.LemmaAnnotation.class);
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (dir == '>') {
                if (det) {
                    Set<IndexedWord> children = wordMapFactory.newSet();
                    children.addAll(this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.DETERMINER));
                    children.addAll(this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.PREDETERMINER));
                    boolean match = false;
                    for (IndexedWord child : children) {
                        String lemma = (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                        if (lemma.isEmpty()) {
                            lemma = child.word().toLowerCase();
                        }
                        if (!lemma.equals(word)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    return false;
                }
                List<Pair<GrammaticalRelation, IndexedWord>> children = this.childPairs(vertex);
                boolean match = false;
                for (Pair<GrammaticalRelation, IndexedWord> pair : children) {
                    if (pair.first().toString().equals("det")) continue;
                    IndexedWord child = pair.second();
                    String lemma = (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                    if (lemma.isEmpty()) {
                        lemma = child.word().toLowerCase();
                    }
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            throw new RuntimeException("Warning: bad pattern \"%s\"\n" + pattern);
        }
        return true;
    }

    public boolean matchPatternToVertex(String pattern, IndexedWord vertex) {
        String[] nodePath;
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        String pat = pattern.replaceAll("<", ",<");
        pat = pat.replaceAll(">", ",>");
        for (String s : nodePath = pat.split(",")) {
            String lemma;
            boolean match;
            if (s.isEmpty()) continue;
            String word = s.substring(1);
            char dir = s.charAt(0);
            if (dir == '<') {
                match = false;
                for (IndexedWord parent : this.getParents(vertex)) {
                    lemma = (String)parent.get(CoreAnnotations.LemmaAnnotation.class);
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (dir == '>') {
                match = false;
                for (IndexedWord child : this.getChildren(vertex)) {
                    lemma = (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                    if (lemma == null || lemma.isEmpty()) {
                        lemma = child.word().toLowerCase();
                    }
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            throw new RuntimeException("Warning: bad pattern \"%s\"\n" + pattern);
        }
        return true;
    }

    public List<IndexedWord> getChildList(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>(this.getChildren(vertex));
        Collections.sort(result);
        return result;
    }

    public Set<IndexedWord> getChildren(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        return this.graph.getChildren(vertex);
    }

    public boolean hasChildren(IndexedWord vertex) {
        return this.outgoingEdgeIterator(vertex).hasNext();
    }

    public List<SemanticGraphEdge> getIncomingEdgesSorted(IndexedWord vertex) {
        List<SemanticGraphEdge> edges = this.incomingEdgeList(vertex);
        Collections.sort(edges);
        return edges;
    }

    public List<SemanticGraphEdge> getOutEdgesSorted(IndexedWord vertex) {
        List<SemanticGraphEdge> edges = this.outgoingEdgeList(vertex);
        Collections.sort(edges);
        return edges;
    }

    public List<IndexedWord> getParentList(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>(this.getParents(vertex));
        Collections.sort(result);
        return result;
    }

    public Set<IndexedWord> getParents(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        return this.graph.getParents(vertex);
    }

    public Collection<IndexedWord> getSiblings(IndexedWord vertex) {
        IndexedWord parent = this.getParent(vertex);
        if (parent != null) {
            Set<IndexedWord> result = wordMapFactory.newSet();
            result.addAll(this.getChildren(parent));
            result.remove(vertex);
            return result;
        }
        return Collections.emptySet();
    }

    private List<IndexedWord> getPathToRoot(IndexedWord vertex, List<IndexedWord> used) {
        used.add(vertex);
        List<IndexedWord> parents = this.getParentList(vertex);
        parents.removeAll(used);
        if (this.roots.contains(vertex) || parents.isEmpty()) {
            used.remove(used.size() - 1);
            if (this.roots.contains(vertex)) {
                return Generics.newArrayList();
            }
            return null;
        }
        for (IndexedWord parent : parents) {
            List<IndexedWord> path = this.getPathToRoot(parent, used);
            if (path == null) continue;
            path.add(parent);
            used.remove(used.size() - 1);
            return path;
        }
        used.remove(used.size() - 1);
        return null;
    }

    public List<IndexedWord> getPathToRoot(IndexedWord vertex) {
        List<IndexedWord> path = this.getPathToRoot(vertex, Generics.newArrayList());
        if (path != null) {
            Collections.reverse(path);
        }
        return path;
    }

    public IndexedWord getParent(IndexedWord vertex) {
        List<IndexedWord> path = this.getPathToRoot(vertex);
        if (path != null && path.size() > 0) {
            return path.get(0);
        }
        return null;
    }

    public IndexedWord getNodeByIndex(int index) throws IllegalArgumentException {
        IndexedWord node = this.getNodeByIndexSafe(index);
        if (node == null) {
            throw new IllegalArgumentException("No SemanticGraph vertex with index " + index);
        }
        return node;
    }

    public IndexedWord getNodeByIndexSafe(int index) {
        for (IndexedWord vertex : this.vertexSet()) {
            if (vertex.index() != index) continue;
            return vertex;
        }
        return null;
    }

    public IndexedWord getNodeByIndexAndCopyCount(int index, int copyCount) throws IllegalArgumentException {
        IndexedWord node = this.getNodeByIndexAndCopyCountSafe(index, copyCount);
        if (node == null) {
            throw new IllegalArgumentException("No SemanticGraph vertex with index " + index + " and copyCount " + copyCount);
        }
        return node;
    }

    public IndexedWord getNodeByIndexAndCopyCountSafe(int index, int copyCount) {
        for (IndexedWord vertex : this.vertexSet()) {
            if (vertex.index() != index || vertex.copyCount() != copyCount) continue;
            return vertex;
        }
        return null;
    }

    public IndexedWord getNodeByWordPattern(String pattern) {
        Pattern p = Pattern.compile(pattern);
        for (IndexedWord vertex : this.vertexSet()) {
            String w = vertex.word();
            if ((w != null || pattern != null) && (w == null || !p.matcher(w).matches())) continue;
            return vertex;
        }
        return null;
    }

    public List<IndexedWord> getAllNodesByWordPattern(String pattern) {
        Pattern p = Pattern.compile(pattern);
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : this.vertexSet()) {
            String w = vertex.word();
            if ((w != null || pattern != null) && (w == null || !p.matcher(w).matches())) continue;
            nodes.add(vertex);
        }
        return nodes;
    }

    public List<IndexedWord> getAllNodesByPartOfSpeechPattern(String pattern) {
        Pattern p = Pattern.compile(pattern);
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : this.vertexSet()) {
            String pos = vertex.tag();
            if ((pos != null || pattern != null) && (pos == null || !p.matcher(pos).matches())) continue;
            nodes.add(vertex);
        }
        return nodes;
    }

    public Set<IndexedWord> descendants(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = wordMapFactory.newSet();
        this.descendantsHelper(vertex, descendantSet);
        return descendantSet;
    }

    private void descendantsHelper(IndexedWord curr, Set<IndexedWord> descendantSet) {
        if (descendantSet.contains(curr)) {
            return;
        }
        descendantSet.add(curr);
        for (IndexedWord child : this.getChildren(curr)) {
            this.descendantsHelper(child, descendantSet);
        }
    }

    public List<Pair<GrammaticalRelation, IndexedWord>> childPairs(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Pair<GrammaticalRelation, IndexedWord>> childPairs = Generics.newArrayList();
        for (SemanticGraphEdge e : this.outgoingEdgeIterable(vertex)) {
            childPairs.add(new Pair<GrammaticalRelation, IndexedWord>(e.getRelation(), e.getTarget()));
        }
        return childPairs;
    }

    public List<Pair<GrammaticalRelation, IndexedWord>> parentPairs(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Pair<GrammaticalRelation, IndexedWord>> parentPairs = Generics.newArrayList();
        for (SemanticGraphEdge e : this.incomingEdgeIterable(vertex)) {
            parentPairs.add(new Pair<GrammaticalRelation, IndexedWord>(e.getRelation(), e.getSource()));
        }
        return parentPairs;
    }

    public Set<GrammaticalRelation> relns(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<GrammaticalRelation> relns = Generics.newHashSet();
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.parentPairs(vertex);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            relns.add(p.first());
        }
        return relns;
    }

    public GrammaticalRelation reln(IndexedWord a, IndexedWord b) {
        if (!this.containsVertex(a)) {
            throw new IllegalArgumentException();
        }
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.childPairs(a);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            if (!p.second().equals(b)) continue;
            return p.first();
        }
        return null;
    }

    public Set<GrammaticalRelation> childRelns(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<GrammaticalRelation> relns = Generics.newHashSet();
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.childPairs(vertex);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            relns.add(p.first());
        }
        return relns;
    }

    public Collection<IndexedWord> getRoots() {
        return this.roots;
    }

    private List<IndexedWord> getVerticesWithoutParents() {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        for (IndexedWord v : this.vertexSet()) {
            int inDegree = this.inDegree(v);
            if (inDegree != 0) continue;
            result.add(v);
        }
        Collections.sort(result);
        return result;
    }

    public IndexedWord getFirstRoot() {
        if (this.roots.isEmpty()) {
            throw new RuntimeException("No roots in graph:\n" + this + "\nFind where this graph was created and make sure you're adding roots.");
        }
        return this.roots.iterator().next();
    }

    public void addRoot(IndexedWord root) {
        this.addVertex(root);
        this.roots.add(root);
    }

    public void resetRoots() {
        List<IndexedWord> newRoots = this.getVerticesWithoutParents();
        if (newRoots.size() > 0) {
            this.roots.clear();
            this.roots.addAll(newRoots);
            return;
        }
        TwoDimensionalCounter<IndexedWord, IndexedWord> nodeDists = TwoDimensionalCounter.identityHashMapCounter();
        for (IndexedWord indexedWord : this.vertexSet()) {
            for (IndexedWord node2 : this.vertexSet()) {
                List<SemanticGraphEdge> path = this.getShortestDirectedPathEdges(indexedWord, node2);
                if (path == null) continue;
                int dist = path.size();
                nodeDists.setCount(indexedWord, node2, dist);
            }
        }
        ClassicCounter<IndexedWord> dominatedEdgeCount = ClassicCounter.identityHashMapCounter();
        for (IndexedWord outer : this.vertexSet()) {
            for (IndexedWord inner : this.vertexSet()) {
                dominatedEdgeCount.incrementCount(outer, nodeDists.getCount(outer, inner));
            }
        }
        IndexedWord indexedWord = (IndexedWord)Counters.argmax(dominatedEdgeCount);
        this.setRoot(indexedWord);
    }

    public void setRoot(IndexedWord word) {
        this.roots.clear();
        this.roots.add(word);
    }

    public void setRoots(Collection<IndexedWord> words) {
        this.roots.clear();
        this.roots.addAll(words);
    }

    public List<IndexedWord> topologicalSort() {
        return this.graph.topologicalSort();
    }

    public boolean hasChild(IndexedWord vertex, GrammaticalRelation reln, String childLemma) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln) || !((String)edge.getTarget().get(CoreAnnotations.LemmaAnnotation.class)).equals(childLemma)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.incomingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            return true;
        }
        return false;
    }

    public IndexedWord getChildWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return null;
        }
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            return edge.getTarget();
        }
        return null;
    }

    public Set<IndexedWord> getParentsWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return Collections.emptySet();
        }
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> parentList = wordMapFactory.newSet();
        for (SemanticGraphEdge edge : this.incomingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            parentList.add(edge.getSource());
        }
        return parentList;
    }

    public Set<IndexedWord> getChildrenWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return Collections.emptySet();
        }
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> childList = wordMapFactory.newSet();
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            childList.add(edge.getTarget());
        }
        return childList;
    }

    public Set<IndexedWord> getChildrenWithRelns(IndexedWord vertex, Collection<GrammaticalRelation> relns) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return Collections.emptySet();
        }
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> childList = wordMapFactory.newSet();
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!relns.contains(edge.getRelation())) continue;
            childList.add(edge.getTarget());
        }
        return childList;
    }

    public SemanticGraphEdge getEdge(IndexedWord gov, IndexedWord dep, GrammaticalRelation reln) {
        List<SemanticGraphEdge> edges = this.getAllEdges(gov, dep);
        if (edges != null) {
            for (SemanticGraphEdge edge : edges) {
                if (!edge.getSource().equals(gov) || !edge.getRelation().equals(reln)) continue;
                return edge;
            }
        }
        return null;
    }

    public boolean isNegatedVertex(IndexedWord vertex) {
        if (vertex == IndexedWord.NO_WORD) {
            return false;
        }
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException("Vertex " + vertex + " not in graph " + this);
        }
        return this.hasChildWithReln(vertex, EnglishGrammaticalRelations.NEGATION_MODIFIER) || this.hasChild(vertex, GrammaticalRelation.DEPENDENT, "nor");
    }

    private boolean isNegatedVerb(IndexedWord vertex) {
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        return vertex.tag().startsWith("VB") && this.isNegatedVertex(vertex);
    }

    public boolean isInConditionalContext(IndexedWord vertex) {
        for (IndexedWord child : this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.MARKER)) {
            if (!child.word().equalsIgnoreCase("if")) continue;
            return true;
        }
        return false;
    }

    public boolean attachedNegatedVerb(IndexedWord vertex) {
        for (IndexedWord parent : this.getParents(vertex)) {
            if (!this.isNegatedVerb(parent)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuxiliaryVerb(IndexedWord vertex) {
        Set<GrammaticalRelation> relns = this.relns(vertex);
        if (relns.isEmpty()) {
            return false;
        }
        boolean result = relns.contains(EnglishGrammaticalRelations.AUX_MODIFIER) || relns.contains(EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER);
        return result;
    }

    public Set<IndexedWord> getLeafVertices() {
        Set<IndexedWord> result = wordMapFactory.newSet();
        for (IndexedWord v : this.vertexSet()) {
            if (this.outDegree(v) != 0) continue;
            result.add(v);
        }
        return result;
    }

    public int size() {
        return this.vertexSet().size();
    }

    public Set<IndexedWord> getSubgraphVertices(IndexedWord root) {
        Set<IndexedWord> result = wordMapFactory.newSet();
        result.add(root);
        LinkedList<IndexedWord> queue = Generics.newLinkedList();
        queue.add(root);
        while (!queue.isEmpty()) {
            IndexedWord current = (IndexedWord)queue.remove(0);
            for (IndexedWord child : this.getChildren(current)) {
                if (result.contains(child)) continue;
                result.add(child);
                queue.add(child);
            }
        }
        return result;
    }

    public boolean isDag() {
        Set<IndexedWord> unused = wordMapFactory.newSet();
        unused.addAll(this.vertexSet());
        while (!unused.isEmpty()) {
            IndexedWord arbitrary = unused.iterator().next();
            boolean result = this.isDagHelper(arbitrary, unused, wordMapFactory.newSet());
            if (!result) continue;
            return false;
        }
        return true;
    }

    public boolean isDag(IndexedWord root) {
        Set<IndexedWord> unused = wordMapFactory.newSet();
        unused.addAll(this.getSubgraphVertices(root));
        while (!unused.isEmpty()) {
            IndexedWord arbitrary = unused.iterator().next();
            boolean result = this.isDagHelper(arbitrary, unused, wordMapFactory.newSet());
            if (!result) continue;
            return false;
        }
        return true;
    }

    private boolean isDagHelper(IndexedWord current, Set<IndexedWord> unused, Set<IndexedWord> trail) {
        if (trail.contains(current)) {
            return true;
        }
        if (!unused.contains(current)) {
            return false;
        }
        unused.remove(current);
        trail.add(current);
        for (IndexedWord child : this.getChildren(current)) {
            boolean result = this.isDagHelper(child, unused, trail);
            if (!result) continue;
            return true;
        }
        trail.remove(current);
        return false;
    }

    public String toString() {
        return this.toString(CoreLabel.OutputFormat.VALUE_TAG);
    }

    public String toString(CoreLabel.OutputFormat wordFormat) {
        Collection<IndexedWord> rootNodes = this.getRoots();
        if (rootNodes.isEmpty()) {
            return this.toString(OutputFormat.READABLE);
        }
        StringBuilder sb = new StringBuilder();
        Set<IndexedWord> used = wordMapFactory.newSet();
        for (IndexedWord root : rootNodes) {
            sb.append("-> ").append(root.toString(wordFormat)).append(" (root)\n");
            this.recToString(root, wordFormat, sb, 1, used);
        }
        Set<IndexedWord> nodes = wordMapFactory.newSet();
        nodes.addAll(this.vertexSet());
        nodes.removeAll(used);
        while (!nodes.isEmpty()) {
            IndexedWord node = nodes.iterator().next();
            sb.append(node.toString(wordFormat)).append("\n");
            this.recToString(node, wordFormat, sb, 1, used);
            nodes.removeAll(used);
        }
        return sb.toString();
    }

    private void recToString(IndexedWord curr, CoreLabel.OutputFormat wordFormat, StringBuilder sb, int offset, Set<IndexedWord> used) {
        used.add(curr);
        List<SemanticGraphEdge> edges = this.outgoingEdgeList(curr);
        Collections.sort(edges);
        for (SemanticGraphEdge edge : edges) {
            IndexedWord target = edge.getTarget();
            sb.append(SemanticGraph.space(2 * offset)).append("-> ").append(target.toString(wordFormat)).append(" (").append(edge.getRelation()).append(")\n");
            if (used.contains(target)) continue;
            this.recToString(target, wordFormat, sb, offset + 1, used);
        }
    }

    private static String space(int width) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    public String toRecoveredSentenceString() {
        StringBuilder sb = new StringBuilder();
        boolean pastFirst = false;
        for (IndexedWord word : this.vertexListSorted()) {
            if (pastFirst) {
                sb.append(' ');
            }
            pastFirst = true;
            sb.append(word.word());
        }
        return sb.toString();
    }

    public String toRecoveredSentenceStringWithIndexMarking() {
        StringBuilder sb = new StringBuilder();
        boolean pastFirst = false;
        int index = 0;
        for (IndexedWord word : this.vertexListSorted()) {
            if (pastFirst) {
                sb.append(' ');
            }
            pastFirst = true;
            sb.append(word.word());
            sb.append("(");
            sb.append(index++);
            sb.append(")");
        }
        return sb.toString();
    }

    public String toEnUncollapsedSentenceString() {
        LinkedList<IndexedWord> uncompressedList = Generics.newLinkedList(this.vertexSet());
        ArrayList<Pair<String, IndexedWord>> specifics = Generics.newArrayList();
        for (IndexedWord indexedWord : this.vertexSet()) {
            for (SemanticGraphEdge edge : this.getIncomingEdgesSorted(indexedWord)) {
                GrammaticalRelation relation = edge.getRelation();
                String specific = relation.getSpecific();
                if (specific == null && edge.getRelation().equals(EnglishGrammaticalRelations.AGENT)) {
                    specific = "by";
                }
                if (specific == null) continue;
                Pair<String, IndexedWord> specPair = new Pair<String, IndexedWord>(specific, indexedWord);
                specifics.add(specPair);
            }
        }
        for (Pair pair : specifics) {
            this.insertSpecificIntoList((String)pair.first(), (IndexedWord)pair.second(), uncompressedList);
        }
        return StringUtils.join(uncompressedList, " ");
    }

    private void insertSpecificIntoList(String specific, IndexedWord relnTgtNode, List<IndexedWord> tgtList) {
        int currIndex;
        Set<IndexedWord> descendants = this.descendants(relnTgtNode);
        IndexedWord specificNode = new IndexedWord();
        specificNode.set(CoreAnnotations.LemmaAnnotation.class, specific);
        specificNode.set(CoreAnnotations.TextAnnotation.class, specific);
        specificNode.set(CoreAnnotations.OriginalTextAnnotation.class, specific);
        for (currIndex = tgtList.indexOf(relnTgtNode); currIndex >= 1 && descendants.contains(tgtList.get(currIndex - 1)); --currIndex) {
        }
        tgtList.add(currIndex, specificNode);
    }

    public String toString(OutputFormat format) {
        switch (format) {
            case XML: {
                return this.toXMLString();
            }
            case READABLE: {
                return this.toReadableString();
            }
            case LIST: {
                return this.toList();
            }
            case RECURSIVE: {
                return this.toString();
            }
        }
        throw new IllegalArgumentException("Unsupported format " + (Object)((Object)format));
    }

    public String toList() {
        StringBuilder buf = new StringBuilder();
        for (IndexedWord root : this.getRoots()) {
            buf.append("root(ROOT-0, ");
            buf.append(root.toString(CoreLabel.OutputFormat.VALUE_INDEX)).append(")\n");
        }
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            buf.append(edge.getRelation()).append("(");
            buf.append(edge.getSource().toString(CoreLabel.OutputFormat.VALUE_INDEX)).append(", ");
            buf.append(edge.getTarget().toString(CoreLabel.OutputFormat.VALUE_INDEX)).append(")\n");
        }
        return buf.toString();
    }

    public String toPOSList() {
        StringBuilder buf = new StringBuilder();
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            buf.append(edge.getRelation()).append("(");
            buf.append(edge.getSource()).append(",");
            buf.append(edge.getTarget()).append(")\n");
        }
        return buf.toString();
    }

    private String toReadableString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "dep", "reln", "gov"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (IndexedWord root : this.getRoots()) {
            buf.append(String.format("%-20s%-20s%-20s%n", root.toString(CoreLabel.OutputFormat.VALUE_TAG_INDEX), "root", "root"));
        }
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            buf.append(String.format("%-20s%-20s%-20s%n", edge.getTarget().toString(CoreLabel.OutputFormat.VALUE_TAG_INDEX), edge.getRelation().toString(), edge.getSource().toString(CoreLabel.OutputFormat.VALUE_TAG_INDEX)));
        }
        return buf.toString();
    }

    private String toXMLString() {
        StringBuilder buf = new StringBuilder("<dependencies style=\"typed\">\n");
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            String reln = edge.getRelation().toString();
            String gov = edge.getSource().word();
            int govIdx = edge.getSource().index();
            String dep = edge.getTarget().word();
            int depIdx = edge.getTarget().index();
            buf.append("  <dep type=\"").append(reln).append("\">\n");
            buf.append("    <governor idx=\"").append(govIdx).append("\">").append(gov).append("</governor>\n");
            buf.append("    <dependent idx=\"").append(depIdx).append("\">").append(dep).append("</dependent>\n");
            buf.append("  </dep>\n");
        }
        buf.append("</dependencies>\n");
        return buf.toString();
    }

    public String toCompactString() {
        return this.toCompactString(false);
    }

    public String toCompactString(boolean showTags) {
        StringBuilder sb = new StringBuilder();
        Set<IndexedWord> used = wordMapFactory.newSet();
        Collection<IndexedWord> roots = this.getRoots();
        if (roots.isEmpty()) {
            if (this.size() == 0) {
                return "[EMPTY_SEMANTIC_GRAPH]";
            }
            return "[UNROOTED_SEMANTIC_GRAPH]";
        }
        for (IndexedWord root : roots) {
            this.toCompactStringHelper(root, sb, used, showTags);
        }
        return sb.toString();
    }

    private void toCompactStringHelper(IndexedWord node, StringBuilder sb, Set<IndexedWord> used, boolean showTags) {
        used.add(node);
        try {
            boolean isntLeaf;
            boolean bl = isntLeaf = this.outDegree(node) > 0;
            if (isntLeaf) {
                sb.append("[");
            }
            sb.append(node.word());
            if (showTags) {
                sb.append("/");
                sb.append(node.tag());
            }
            for (SemanticGraphEdge edge : this.getOutEdgesSorted(node)) {
                IndexedWord target = edge.getTarget();
                sb.append(" ").append(edge.getRelation()).append(">");
                if (!used.contains(target)) {
                    this.toCompactStringHelper(target, sb, used, showTags);
                    continue;
                }
                sb.append(target.word());
                if (!showTags) continue;
                sb.append("/");
                sb.append(target.tag());
            }
            if (isntLeaf) {
                sb.append("]");
            }
        }
        catch (IllegalArgumentException e) {
            log.info("WHOA!  SemanticGraph.toCompactStringHelper() ran into problems at node " + node);
            throw new IllegalArgumentException(e);
        }
    }

    public String toFormattedString() {
        return formatter.formatSemanticGraph(this);
    }

    public String toFormattedString(SemanticGraphFormatter formatter) {
        return formatter.formatSemanticGraph(this);
    }

    public void prettyPrint(SemanticGraphFormatter formatter) {
        System.out.println(formatter.formatSemanticGraph(this));
    }

    public void prettyPrint() {
        System.out.println(formatter.formatSemanticGraph(this));
    }

    public String toDotFormat() {
        return this.toDotFormat("");
    }

    public String toDotFormat(String graphname) {
        return this.toDotFormat(graphname, CoreLabel.OutputFormat.VALUE_TAG_INDEX);
    }

    public String toDotFormat(String graphname, CoreLabel.OutputFormat indexedWordFormat) {
        StringBuilder output = new StringBuilder();
        output.append("digraph " + graphname + " {\n");
        for (IndexedWord word : this.graph.getAllVertices()) {
            output.append("  N_" + word.index() + " [label=\"" + word.toString(indexedWordFormat) + "\"];\n");
        }
        for (SemanticGraphEdge edge : this.graph.edgeIterable()) {
            output.append("  N_" + edge.getSource().index() + " -> N_" + edge.getTarget().index() + " [label=\"" + edge.getRelation() + "\"];\n");
        }
        output.append("}\n");
        return output.toString();
    }

    public SemanticGraphEdge addEdge(IndexedWord s, IndexedWord d, GrammaticalRelation reln, double weight, boolean isExtra) {
        SemanticGraphEdge newEdge = new SemanticGraphEdge(s, d, reln, weight, isExtra);
        this.graph.add(s, d, newEdge);
        return newEdge;
    }

    public SemanticGraphEdge addEdge(SemanticGraphEdge edge) {
        SemanticGraphEdge newEdge = new SemanticGraphEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        this.graph.add(edge.getGovernor(), edge.getDependent(), newEdge);
        return newEdge;
    }

    public static SemanticGraph valueOf(String s, Language language) {
        return new SemanticGraphParsingTask(s, language).parse();
    }

    public static SemanticGraph valueOf(String s) {
        return SemanticGraph.valueOf(s, Language.UniversalEnglish);
    }

    public SemanticGraph() {
        this.graph = new DirectedMultiGraph<IndexedWord, SemanticGraphEdge>(outerMapFactory, innerMapFactory);
        this.roots = wordMapFactory.newSet();
    }

    public SemanticGraph(SemanticGraph g) {
        this.graph = new DirectedMultiGraph<IndexedWord, SemanticGraphEdge>(g.graph);
        this.roots = wordMapFactory.newSet(g.roots);
    }

    public SemanticGraph(SemanticGraph g, Map<IndexedWord, IndexedWord> prevToNewMap) {
        this.graph = new DirectedMultiGraph<IndexedWord, SemanticGraphEdge>(outerMapFactory, innerMapFactory);
        if (prevToNewMap == null) {
            prevToNewMap = wordMapFactory.newMap();
        }
        Set<IndexedWord> vertexes = g.vertexSet();
        for (IndexedWord vertex : vertexes) {
            IndexedWord newVertex = new IndexedWord(vertex);
            newVertex.setCopyCount(vertex.copyCount());
            this.addVertex(newVertex);
            prevToNewMap.put(vertex, newVertex);
        }
        this.roots = wordMapFactory.newSet();
        for (IndexedWord oldRoot : g.getRoots()) {
            this.roots.add(prevToNewMap.get(oldRoot));
        }
        for (SemanticGraphEdge edge : g.edgeIterable()) {
            IndexedWord newGov = prevToNewMap.get(edge.getGovernor());
            IndexedWord newDep = prevToNewMap.get(edge.getDependent());
            this.addEdge(newGov, newDep, edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
    }

    public SemanticGraph(Collection<TypedDependency> dependencies) {
        this.graph = new DirectedMultiGraph<IndexedWord, SemanticGraphEdge>(outerMapFactory, innerMapFactory);
        this.roots = wordMapFactory.newSet();
        for (TypedDependency d : dependencies) {
            IndexedWord gov = d.gov();
            IndexedWord dep = d.dep();
            GrammaticalRelation reln = d.reln();
            if (reln != GrammaticalRelation.ROOT) {
                this.addEdge(gov, dep, reln, Double.NEGATIVE_INFINITY, d.extra());
                continue;
            }
            this.addVertex(dep);
            this.roots.add(dep);
        }
    }

    public List<IndexedWord> getShortestUndirectedPathNodes(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPath(source, target, false);
    }

    public List<SemanticGraphEdge> getShortestUndirectedPathEdges(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPathEdges(source, target, false);
    }

    public List<IndexedWord> getShortestDirectedPathNodes(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPath(source, target, true);
    }

    public List<SemanticGraphEdge> getShortestDirectedPathEdges(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPathEdges(source, target, true);
    }

    public SemanticGraph makeSoftCopy() {
        SemanticGraph newSg = new SemanticGraph();
        if (!this.roots.isEmpty()) {
            newSg.setRoot(this.getFirstRoot());
        }
        for (SemanticGraphEdge edge : this.edgeIterable()) {
            newSg.addEdge(edge.getSource(), edge.getTarget(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
        return newSg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticGraph)) {
            return false;
        }
        SemanticGraph g = (SemanticGraph)o;
        return this.graph.equals(g.graph) && this.roots.equals(g.roots);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public List<SemanticGraphEdge> findAllRelns(GrammaticalRelation tgtRelation) {
        ArrayList<SemanticGraphEdge> relns = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.edgeIterable()) {
            GrammaticalRelation edgeRelation = edge.getRelation();
            if (edgeRelation == null || !edgeRelation.equals(tgtRelation)) continue;
            relns.add(edge);
        }
        return relns;
    }

    public void deleteDuplicateEdges() {
        this.graph.deleteDuplicateEdges();
    }

    public Collection<TypedDependency> typedDependencies() {
        TypedDependency dependency;
        ArrayList<TypedDependency> dependencies = new ArrayList<TypedDependency>();
        IndexedWord root = null;
        for (IndexedWord node : this.roots) {
            if (root == null) {
                root = new IndexedWord(node.docID(), node.sentIndex(), 0);
                root.setValue("ROOT");
            }
            dependency = new TypedDependency(GrammaticalRelation.ROOT, root, node);
            dependencies.add(dependency);
        }
        for (SemanticGraphEdge e : this.edgeIterable()) {
            dependency = new TypedDependency(e.getRelation(), e.getGovernor(), e.getDependent());
            if (e.isExtra()) {
                dependency.setExtra();
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public Pair<Integer, Integer> yieldSpan(IndexedWord word) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        Stack<IndexedWord> fringe = new Stack<IndexedWord>();
        fringe.push(word);
        while (!fringe.isEmpty()) {
            IndexedWord parent = (IndexedWord)fringe.pop();
            min = Math.min(min, parent.index() - 1);
            max = Math.max(max, parent.index());
            for (SemanticGraphEdge edge : this.outgoingEdgeIterable(parent)) {
                if (edge.isExtra()) continue;
                fringe.push(edge.getDependent());
            }
        }
        return Pair.makePair(min, max);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public List<String> getComments() {
        return this.comments;
    }

    private static class SemanticGraphParsingTask
    extends StringParsingTask<SemanticGraph> {
        private SemanticGraph sg;
        private Set<Integer> indexesUsed = Generics.newHashSet();
        private Language language;

        public SemanticGraphParsingTask(String s) {
            this(s, Language.UniversalEnglish);
        }

        public SemanticGraphParsingTask(String s, Language language) {
            super(s);
            this.language = language;
        }

        @Override
        public SemanticGraph parse() {
            this.sg = new SemanticGraph();
            try {
                this.readWhiteSpace();
                if (!SemanticGraphParsingTask.isLeftBracket(this.peek())) {
                    return null;
                }
                this.readDep(null, null);
                return this.sg;
            }
            catch (StringParsingTask.ParserException e) {
                log.info("SemanticGraphParser warning: " + e.getMessage());
                return null;
            }
        }

        private void readDep(IndexedWord gov, String reln) {
            this.readWhiteSpace();
            if (!SemanticGraphParsingTask.isLeftBracket(this.peek())) {
                String label = this.readName();
                IndexedWord dep = this.makeVertex(label);
                this.sg.addVertex(dep);
                if (gov == null) {
                    this.sg.roots.add(dep);
                }
                this.sg.addEdge(gov, dep, GrammaticalRelation.valueOf(this.language, reln), Double.NEGATIVE_INFINITY, false);
            } else {
                this.readLeftBracket();
                String label = this.readName();
                IndexedWord dep = this.makeVertex(label);
                this.sg.addVertex(dep);
                if (gov == null) {
                    this.sg.roots.add(dep);
                }
                if (gov != null && reln != null) {
                    this.sg.addEdge(gov, dep, GrammaticalRelation.valueOf(this.language, reln), Double.NEGATIVE_INFINITY, false);
                }
                this.readWhiteSpace();
                while (!SemanticGraphParsingTask.isRightBracket(this.peek()) && !this.isEOF) {
                    reln = this.readName();
                    this.readRelnSeparator();
                    this.readDep(dep, reln);
                    this.readWhiteSpace();
                }
                this.readRightBracket();
            }
        }

        private IndexedWord makeVertex(String word) {
            Integer index;
            Pair<String, Integer> wordAndIndex = SemanticGraphParsingTask.readWordAndIndex(word);
            if (wordAndIndex != null) {
                word = wordAndIndex.first();
                index = wordAndIndex.second();
            } else {
                index = this.getNextFreeIndex();
            }
            this.indexesUsed.add(index);
            IndexedWord ifl = new IndexedWord(null, 0, index);
            String[] wordAndTag = word.split("/");
            ifl.set(CoreAnnotations.TextAnnotation.class, wordAndTag[0]);
            ifl.set(CoreAnnotations.ValueAnnotation.class, wordAndTag[0]);
            if (wordAndTag.length > 1) {
                ifl.set(CoreAnnotations.PartOfSpeechAnnotation.class, wordAndTag[1]);
            }
            return ifl;
        }

        private static Pair<String, Integer> readWordAndIndex(String word) {
            Matcher matcher = WORD_AND_INDEX_PATTERN.matcher(word);
            if (!matcher.matches()) {
                return null;
            }
            word = matcher.group(1);
            Integer index = Integer.valueOf(matcher.group(2));
            return new Pair<String, Integer>(word, index);
        }

        private Integer getNextFreeIndex() {
            int i = 0;
            while (this.indexesUsed.contains(i)) {
                ++i;
            }
            return i;
        }

        private void readLeftBracket() {
            this.readWhiteSpace();
            char ch = this.read();
            if (!SemanticGraphParsingTask.isLeftBracket(ch)) {
                throw new StringParsingTask.ParserException("Expected left paren!");
            }
        }

        private void readRightBracket() {
            this.readWhiteSpace();
            char ch = this.read();
            if (!SemanticGraphParsingTask.isRightBracket(ch)) {
                throw new StringParsingTask.ParserException("Expected right paren!");
            }
        }

        private void readRelnSeparator() {
            this.readWhiteSpace();
            if (SemanticGraphParsingTask.isRelnSeparator(this.peek())) {
                this.read();
            }
        }

        private static boolean isLeftBracket(char ch) {
            return ch == '[';
        }

        private static boolean isRightBracket(char ch) {
            return ch == ']';
        }

        private static boolean isRelnSeparator(char ch) {
            return ch == '>';
        }

        @Override
        protected boolean isPunct(char ch) {
            return SemanticGraphParsingTask.isLeftBracket(ch) || SemanticGraphParsingTask.isRightBracket(ch) || SemanticGraphParsingTask.isRelnSeparator(ch);
        }
    }

    public static enum OutputFormat {
        LIST,
        XML,
        READABLE,
        RECURSIVE;

    }
}

