import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { TagOptions } from '.';
import { CloudFormationTemplate } from './cloudformation-template';
import { MessageLanguage } from './common';
/**
 * (experimental) A Service Catalog product, currently only supports type CloudFormationProduct.
 *
 * @experimental
 */
export interface IProduct extends IResource {
    /**
     * (experimental) The ARN of the product.
     *
     * @experimental
     * @attribute true
     */
    readonly productArn: string;
    /**
     * (experimental) The id of the product.
     *
     * @experimental
     * @attribute true
     */
    readonly productId: string;
    /**
     * (experimental) Associate Tag Options.
     *
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     *
     * @experimental
     */
    associateTagOptions(tagOptions: TagOptions): void;
}
declare abstract class ProductBase extends Resource implements IProduct {
    /**
     * (experimental) The ARN of the product.
     *
     * @experimental
     */
    abstract readonly productArn: string;
    /**
     * (experimental) The id of the product.
     *
     * @experimental
     */
    abstract readonly productId: string;
    /**
     * (experimental) Associate Tag Options.
     *
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     *
     * @experimental
     */
    associateTagOptions(tagOptions: TagOptions): void;
}
/**
 * (experimental) Properties of product version (also known as a provisioning artifact).
 *
 * @experimental
 */
export interface CloudFormationProductVersion {
    /**
     * (experimental) The description of the product version.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Whether the specified product template will be validated by CloudFormation.
     *
     * If turned off, an invalid template configuration can be stored.
     *
     * @default true
     * @experimental
     */
    readonly validateTemplate?: boolean;
    /**
     * (experimental) The S3 template that points to the provisioning version template.
     *
     * @experimental
     */
    readonly cloudFormationTemplate: CloudFormationTemplate;
    /**
     * (experimental) The name of the product version.
     *
     * @default - No product version name provided
     * @experimental
     */
    readonly productVersionName?: string;
}
/**
 * (experimental) Properties for a Cloudformation Product.
 *
 * @experimental
 */
export interface CloudFormationProductProps {
    /**
     * (experimental) The owner of the product.
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) The name of the product.
     *
     * @experimental
     */
    readonly productName: string;
    /**
     * (experimental) The configuration of the product version.
     *
     * @experimental
     */
    readonly productVersions: CloudFormationProductVersion[];
    /**
     * (experimental) The language code.
     *
     * Controls language for logging and errors.
     *
     * @default - English
     * @experimental
     */
    readonly messageLanguage?: MessageLanguage;
    /**
     * (experimental) The description of the product.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The distributor of the product.
     *
     * @default - No distributor provided
     * @experimental
     */
    readonly distributor?: string;
    /**
     * (experimental) Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
     *
     * @default false
     * @experimental
     */
    readonly replaceProductVersionIds?: boolean;
    /**
     * (experimental) The support information about the product.
     *
     * @default - No support description provided
     * @experimental
     */
    readonly supportDescription?: string;
    /**
     * (experimental) The contact email for product support.
     *
     * @default - No support email provided
     * @experimental
     */
    readonly supportEmail?: string;
    /**
     * (experimental) The contact URL for product support.
     *
     * @default - No support URL provided
     * @experimental
     */
    readonly supportUrl?: string;
    /**
     * (experimental) TagOptions associated directly to a product.
     *
     * @default - No tagOptions provided
     * @experimental
     */
    readonly tagOptions?: TagOptions;
}
/**
 * (experimental) Abstract class for Service Catalog Product.
 *
 * @experimental
 */
export declare abstract class Product extends ProductBase {
    /**
     * (experimental) Creates a Product construct that represents an external product.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param productArn Product Arn.
     * @experimental
     */
    static fromProductArn(scope: Construct, id: string, productArn: string): IProduct;
}
/**
 * (experimental) A Service Catalog Cloudformation Product.
 *
 * @experimental
 */
export declare class CloudFormationProduct extends Product {
    /**
     * (experimental) The ARN of the product.
     *
     * @experimental
     */
    readonly productArn: string;
    /**
     * (experimental) The id of the product.
     *
     * @experimental
     */
    readonly productId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CloudFormationProductProps);
    private renderProvisioningArtifacts;
    private validateProductProps;
}
export {};
