import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Chain } from '../chain';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * Represents the Wait state which delays a state machine from continuing for a specified time.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html
 * @stability stable
 */
export declare class WaitTime {
    private readonly json;
    /**
     * Wait a fixed amount of time.
     *
     * @stability stable
     */
    static duration(duration: cdk.Duration): WaitTime;
    /**
     * Wait until the given ISO8601 timestamp.
     *
     * @stability stable
     * @example
     *
     * 2016-03-14T01:59:00Z
     */
    static timestamp(timestamp: string): WaitTime;
    /**
     * Wait for a number of seconds stored in the state object.
     *
     * @stability stable
     * @example
     *
     * $.waitSeconds
     */
    static secondsPath(path: string): WaitTime;
    /**
     * Wait until a timestamp found in the state object.
     *
     * @stability stable
     * @example
     *
     * $.waitTimestamp
     */
    static timestampPath(path: string): WaitTime;
    private constructor();
    /**
     * @internal
     */
    get _json(): any;
}
/**
 * Properties for defining a Wait state.
 *
 * @stability stable
 */
export interface WaitProps {
    /**
     * An optional description for this state.
     *
     * @default No comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Wait duration.
     *
     * @stability stable
     */
    readonly time: WaitTime;
}
/**
 * Define a Wait state in the state machine.
 *
 * A Wait state can be used to delay execution of the state machine for a while.
 *
 * @stability stable
 */
export declare class Wait extends State implements INextable {
    /**
     * Continuable states of this Chainable.
     *
     * @stability stable
     */
    readonly endStates: INextable[];
    private readonly time;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: WaitProps);
    /**
     * Continue normal execution with the given state.
     *
     * @stability stable
     */
    next(next: IChainable): Chain;
    /**
     * Return the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson(): object;
}
