title:      Project Structure
desc:       The official docnado installation guide.
date:       2018/10/11
version:    1.0.0
template:   document
nav:        Get Setup>Project Structure
percent:    100
authors:    enq@heinventions.com

The following tutorial uses the example project as it's source material. This can be generated by running `docnado --new`.
{: .info}

# Overview

Documents are managed using `meta-data` at the top of each document. Documents can select which `template` they present themselves with. Documents must end in lowercase `.md`. For example: `mydocument.md`.

```bash
|---logo.png
|---docs
|   |---<<your docs here>>
|---style
    |---static
    |   |---fonts
    |   |---lib
    |---templates
```

We recommend that you keep to a consistent naming scheme and use directories to logically group the pages of your documentation.
{: .tip}

## docs

The `docs` directory is where all of the content for your project should live. The `docs` directory is the heart of your project, within this directory you can use any structure you please. It will contain:

* Your project's homepage `home.md` this is the only essential file for the `docs` directory.
* Every page of your documentation with the file extension `.md`.
* All the images, PDF documents, CSV files and other assets.

## style

You can use the style directory to make your documentation stylish! Use it to modify how your pages render in order to in fit with the design language of your team or company.

* `static`: contains the style information used across your project, it also is the home of:
	* `fonts`: This is where you should keep any custom fonts you may want to use across your project.
	* `lib`: This is where you should keep any libraries you want to use in your project.
* `templates`: This directory is where you keep any page rendering templates for your project. Advanced users can feel free to create their own, but we include several examples so you can hit the ground running.
	* `404.html`
	* `base.html `
	* `document.html`
	* `haxxor.html`
	* `part.html`
	* `print_footer.html`
	* `print_header.html`

## logo.png

Finally we get to `logo.png` this file should be the logo for your company or project.

While you can use any image you like for your `logo.png` please remember that it must be a `.png` file and that an oddly shaped image might not result in the aesthetic you're looking for. We recommend you use the dimensions of our example as a starting off point, but feel free to experiment and find what works for you.
{: .warning}
