/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class PathCountDescriptor
implements IMolecularDescriptor {
    private static final int maxLength = 10;
    public String[] names = new String[22];

    public PathCountDescriptor() {
        int n;
        int n2 = 0;
        for (n = 2; n <= 10; ++n) {
            this.names[n2++] = "MPC" + n;
        }
        this.names[n2++] = "TPC";
        for (n = 1; n <= 10; ++n) {
            this.names[n2++] = "piPC" + n;
        }
        this.names[n2++] = "TpiPC";
        this.names[n2++] = "R_TpiPCTPC";
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("Path count", this.getClass().getName(), "$Id: PathCountDescriptor.java 1 2014-06-06 17:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        Object object;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n2 = iAtomContainer2.getAtomCount();
        double[] dArray = new double[10];
        double[] dArray2 = new double[10];
        double d = n2;
        double d2 = n2;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < n2; ++j) {
                object = PathTools.getPathsOfLength(iAtomContainer2, iAtomContainer2.getAtom(j), i + 1);
                int n3 = i;
                dArray[n3] = dArray[n3] + (double)object.size();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    int n4 = list.size();
                    double d3 = 1.0;
                    for (int k = 0; k < n4 - 1; ++k) {
                        IBond iBond = iAtomContainer2.getBond((IAtom)list.get(k), (IAtom)list.get(k + 1));
                        IBond.Order order = iBond.getOrder();
                        if (iBond.getFlag(5)) {
                            d3 *= 1.5;
                            continue;
                        }
                        if (order == IBond.Order.SINGLE) {
                            d3 *= 1.0;
                            continue;
                        }
                        if (order == IBond.Order.DOUBLE) {
                            d3 *= 2.0;
                            continue;
                        }
                        if (order != IBond.Order.TRIPLE) continue;
                        d3 *= 3.0;
                    }
                    int n5 = i;
                    dArray2[n5] = dArray2[n5] + d3;
                }
            }
            int n6 = i;
            dArray[n6] = dArray[n6] * 0.5;
            d += dArray[i];
            d2 += 0.5 * dArray2[i];
            dArray2[i] = Math.log(1.0 + 0.5 * dArray2[i]);
        }
        double d4 = d2 / d;
        d2 = Math.log(1.0 + d2);
        object = new DoubleArrayResult();
        for (n = 1; n < 10; ++n) {
            ((DoubleArrayResult)object).add(dArray[n]);
        }
        ((DoubleArrayResult)object).add(d);
        for (n = 0; n < 10; ++n) {
            ((DoubleArrayResult)object).add(dArray2[n]);
        }
        ((DoubleArrayResult)object).add(d2);
        ((DoubleArrayResult)object).add(d4);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)object, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

