# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/survey_scenario/modules/choix_variables.ipynb.

# %% auto 0
__all__ = [
    "config",
    "get_interest_variables",
    "get_simulation_variables",
    "get_minimum_useful_variables",
]

# %% ../notebooks/survey_scenario/modules/choix_variables.ipynb 5
import pandas as pd

# from leximpact_prepare_data.toolbase import convert_erfr_to_openfisca, create_simulation
from leximpact_socio_fisca_simu_etat.config import Configuration

# %% ../notebooks/survey_scenario/modules/choix_variables.ipynb 6
config = Configuration(project_folder="leximpact-prepare-data")

# %% ../notebooks/survey_scenario/modules/choix_variables.ipynb 12
def get_interest_variables(type_simu=None):
    var_list = []

    # Donnée d'intérêt par type de calculs
    variables_ir = ["rfr", "irpp", "nbptr"]

    variables_csg_crds = [
        "csg",
        "csg_deductible_chomage",
        "imposable_chomage",
        "csg_deductible_retraite",
        "csg_imposable_retraite",
        "csg_deductible_salaire",
        "csg_imposable_salaire",
        "assiette_csg_non_abattue",
        "assiette_csg",
        "csg_non_salarie",
        "crds_non_salarie",
        "assiette_csg_crds_non_salarie",
        "csg_patrimoine_deductible_ir",
        "csg_revenus_capital",
        "assiette_csg_plus_values",
    ]

    # Pour le simulateur IR
    if type_simu == "IR":
        var_list = variables_ir
    # Pour le simulateur CSG-CRDS
    elif type_simu == "CSG-CRDS":
        var_list = variables_csg_crds
    # Pour le simulateur CSG-CRDS
    else:
        var_list = variables_ir + variables_csg_crds

    return var_list


# %% ../notebooks/survey_scenario/modules/choix_variables.ipynb 17
def get_simulation_variables(scenario, period):
    """
    Donne les listes des variables initialisées dans notre simulation selon qu'elles soient neutralisées ou pas
    """

    initialized_variables = []
    neutralized_variables = []
    active_variables = []
    for variable_name in list(scenario.tax_benefit_system.variables):
        # On va chercher les variables qui sont initialisées dans notre simulation
        cached_array = scenario.simulation.get_array(variable_name, period)
        if cached_array is not None:
            initialized_variables.append(variable_name)
            # Une partie de ces variables est déjà neutralisée
            # TODO: voir où (dans le TBS?) et comment pour le modifier
            if scenario.tax_benefit_system.variables.get(variable_name).is_neutralized:
                neutralized_variables += [variable_name]
            else:
                active_variables += [variable_name]
    print("Notre simulation contient ", len(active_variables), " variables en ", period)

    return active_variables, neutralized_variables


# %% ../notebooks/survey_scenario/modules/choix_variables.ipynb 25
def get_minimum_useful_variables(
    scenario, period, starting_var_list=None, type_simu=None
):

    """
    starting_var_list: la liste des variables que l'on veut trier (si None, on les prends toutes)
    type_simu: les types de simulateurs concernés (si None, on prend tous les simulateurs)

    """

    # Initialisation
    if starting_var_list is None:
        starting_var_list = scenario.tax_benefit_system.variables

    interest_var = get_interest_variables(type_simu)
    print("Valeurs d'interêt :", interest_var, "\n")

    list_crucial_variables = []
    list_useless_variables = []
    base = {}
    # Getting all target values
    baseline_simu = scenario.simulation.clone()
    for target_var in interest_var:
        base[target_var] = baseline_simu.calculate(target_var, period)
    base = pd.DataFrame(base)

    for var in starting_var_list:
        # On crée une simulation sans cette variable #TODO : faire des tests pour .clone()
        temp_simu = (
            scenario.simulation.clone()
        )  # Cela permet de modifier la simulation sans changer l'originale

        # temp_simu.delete_arrays(var)
        # assert temp_simu.get_array(var, period=period) is None # Il faut adapter la periode (mensuelle ou annuelle) à la var
        # TODO: le pb est ici car les arrays ne sont pas supprimés !
        # Attention: en fait on supprime l'array mais la variable sera recalculee plus tard

        # TODO: check si simu.neutralize_variable
        temp_simu.neutre

        # 1 / 0

        try:
            # On regarde la valeur de nos targets sans cette variable
            new = {}
            for target_var in interest_var:
                new[target_var] = temp_simu.calculate(target_var, period)
            new = pd.DataFrame(new)

            # On regarde si ça change les résultats
            if new.equals(base):
                print(var, "is useless")
                list_useless_variables += [var]
            else:
                print(var, "is useful")
                list_crucial_variables += [var]

        # Si ça fait planter les calculs, on garde !
        except Exception:
            list_crucial_variables += [var]
            print(var, "is definitely USEFUL")

        del temp_simu

    print(
        "On peut supprimer de notre simulation les variables suivantes: ",
        list_useless_variables,
    )

    # On force la sauvegarde de variables nécessaires à la compréhension des données (IDs et poids)
    list_crucial_variables += scenario.non_neutralizable_variables

    return list_crucial_variables
