# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.schema import Schema  # noqa: F401,E501
from odahuflow.sdk.models import util


class PackagingIntegrationSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, default_image: str=None, entrypoint: str=None, privileged: bool=None, schema: Schema=None):  # noqa: E501
        """PackagingIntegrationSpec - a model defined in Swagger

        :param default_image: The default_image of this PackagingIntegrationSpec.  # noqa: E501
        :type default_image: str
        :param entrypoint: The entrypoint of this PackagingIntegrationSpec.  # noqa: E501
        :type entrypoint: str
        :param privileged: The privileged of this PackagingIntegrationSpec.  # noqa: E501
        :type privileged: bool
        :param schema: The schema of this PackagingIntegrationSpec.  # noqa: E501
        :type schema: Schema
        """
        self.swagger_types = {
            'default_image': str,
            'entrypoint': str,
            'privileged': bool,
            'schema': Schema
        }

        self.attribute_map = {
            'default_image': 'defaultImage',
            'entrypoint': 'entrypoint',
            'privileged': 'privileged',
            'schema': 'schema'
        }

        self._default_image = default_image
        self._entrypoint = entrypoint
        self._privileged = privileged
        self._schema = schema

    @classmethod
    def from_dict(cls, dikt) -> 'PackagingIntegrationSpec':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PackagingIntegrationSpec of this PackagingIntegrationSpec.  # noqa: E501
        :rtype: PackagingIntegrationSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def default_image(self) -> str:
        """Gets the default_image of this PackagingIntegrationSpec.

        Default packaging Docker image  # noqa: E501

        :return: The default_image of this PackagingIntegrationSpec.
        :rtype: str
        """
        return self._default_image

    @default_image.setter
    def default_image(self, default_image: str):
        """Sets the default_image of this PackagingIntegrationSpec.

        Default packaging Docker image  # noqa: E501

        :param default_image: The default_image of this PackagingIntegrationSpec.
        :type default_image: str
        """

        self._default_image = default_image

    @property
    def entrypoint(self) -> str:
        """Gets the entrypoint of this PackagingIntegrationSpec.

        Path to binary which starts a packaging process  # noqa: E501

        :return: The entrypoint of this PackagingIntegrationSpec.
        :rtype: str
        """
        return self._entrypoint

    @entrypoint.setter
    def entrypoint(self, entrypoint: str):
        """Sets the entrypoint of this PackagingIntegrationSpec.

        Path to binary which starts a packaging process  # noqa: E501

        :param entrypoint: The entrypoint of this PackagingIntegrationSpec.
        :type entrypoint: str
        """

        self._entrypoint = entrypoint

    @property
    def privileged(self) -> bool:
        """Gets the privileged of this PackagingIntegrationSpec.

        Enable docker privileged flag  # noqa: E501

        :return: The privileged of this PackagingIntegrationSpec.
        :rtype: bool
        """
        return self._privileged

    @privileged.setter
    def privileged(self, privileged: bool):
        """Sets the privileged of this PackagingIntegrationSpec.

        Enable docker privileged flag  # noqa: E501

        :param privileged: The privileged of this PackagingIntegrationSpec.
        :type privileged: bool
        """

        self._privileged = privileged

    @property
    def schema(self) -> Schema:
        """Gets the schema of this PackagingIntegrationSpec.

        Schema which describes targets and arguments for specific packaging integration  # noqa: E501

        :return: The schema of this PackagingIntegrationSpec.
        :rtype: Schema
        """
        return self._schema

    @schema.setter
    def schema(self, schema: Schema):
        """Sets the schema of this PackagingIntegrationSpec.

        Schema which describes targets and arguments for specific packaging integration  # noqa: E501

        :param schema: The schema of this PackagingIntegrationSpec.
        :type schema: Schema
        """

        self._schema = schema
