# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.model_property import ModelProperty  # noqa: F401,E501
from odahuflow.sdk.models import util


class JsonSchema(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, properties: List[ModelProperty]=None, required: List[str]=None):  # noqa: E501
        """JsonSchema - a model defined in Swagger

        :param properties: The properties of this JsonSchema.  # noqa: E501
        :type properties: List[ModelProperty]
        :param required: The required of this JsonSchema.  # noqa: E501
        :type required: List[str]
        """
        self.swagger_types = {
            'properties': List[ModelProperty],
            'required': List[str]
        }

        self.attribute_map = {
            'properties': 'properties',
            'required': 'required'
        }

        self._properties = properties
        self._required = required

    @classmethod
    def from_dict(cls, dikt) -> 'JsonSchema':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The JsonSchema of this JsonSchema.  # noqa: E501
        :rtype: JsonSchema
        """
        return util.deserialize_model(dikt, cls)

    @property
    def properties(self) -> List[ModelProperty]:
        """Gets the properties of this JsonSchema.

        Properties configuration  # noqa: E501

        :return: The properties of this JsonSchema.
        :rtype: List[ModelProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties: List[ModelProperty]):
        """Sets the properties of this JsonSchema.

        Properties configuration  # noqa: E501

        :param properties: The properties of this JsonSchema.
        :type properties: List[ModelProperty]
        """

        self._properties = properties

    @property
    def required(self) -> List[str]:
        """Gets the required of this JsonSchema.

        List of required properties  # noqa: E501

        :return: The required of this JsonSchema.
        :rtype: List[str]
        """
        return self._required

    @required.setter
    def required(self, required: List[str]):
        """Sets the required of this JsonSchema.

        List of required properties  # noqa: E501

        :param required: The required of this JsonSchema.
        :type required: List[str]
        """

        self._required = required
