# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ExternalUrl(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, image_url: str=None, name: str=None, url: str=None):  # noqa: E501
        """ExternalUrl - a model defined in Swagger

        :param image_url: The image_url of this ExternalUrl.  # noqa: E501
        :type image_url: str
        :param name: The name of this ExternalUrl.  # noqa: E501
        :type name: str
        :param url: The url of this ExternalUrl.  # noqa: E501
        :type url: str
        """
        self.swagger_types = {
            'image_url': str,
            'name': str,
            'url': str
        }

        self.attribute_map = {
            'image_url': 'imageUrl',
            'name': 'name',
            'url': 'url'
        }

        self._image_url = image_url
        self._name = name
        self._url = url

    @classmethod
    def from_dict(cls, dikt) -> 'ExternalUrl':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ExternalUrl of this ExternalUrl.  # noqa: E501
        :rtype: ExternalUrl
        """
        return util.deserialize_model(dikt, cls)

    @property
    def image_url(self) -> str:
        """Gets the image_url of this ExternalUrl.

        Optional link to an image which represents a type of the resource, for example the logo of Grafana  # noqa: E501

        :return: The image_url of this ExternalUrl.
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url: str):
        """Sets the image_url of this ExternalUrl.

        Optional link to an image which represents a type of the resource, for example the logo of Grafana  # noqa: E501

        :param image_url: The image_url of this ExternalUrl.
        :type image_url: str
        """

        self._image_url = image_url

    @property
    def name(self) -> str:
        """Gets the name of this ExternalUrl.

        Human-readable name  # noqa: E501

        :return: The name of this ExternalUrl.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """Sets the name of this ExternalUrl.

        Human-readable name  # noqa: E501

        :param name: The name of this ExternalUrl.
        :type name: str
        """

        self._name = name

    @property
    def url(self) -> str:
        """Gets the url of this ExternalUrl.

        Link to a resource  # noqa: E501

        :return: The url of this ExternalUrl.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str):
        """Sets the url of this ExternalUrl.

        Link to a resource  # noqa: E501

        :param url: The url of this ExternalUrl.
        :type url: str
        """

        self._url = url
