Groundhog - A general-purpose geotechnical package
====================================================

[![PyPI version](https://badge.fury.io/py/groundhog.svg)](https://badge.fury.io/py/groundhog)

![groundhog banner](https://github.com/snakesonabrain/groundhog/blob/master/groundhog_banner_wide.png?raw=true)

This Python package contains useful functionality for supporting automated geotechnical calculations.

Functionality for onshore and offshore geotechnical problems is included. This package is under constant development so any request for additional functionality can always be submitted to the package author.

groundhog bundles a large amount of knowledge and provides it to end users through extensively documented functions. The aim of the package is as follows:

   - Improve correctness through unit-tested functions with parameter validation
   - Raise awareness on underlying test data and theories supporting engineering correlations and design formulae
   - Promoting development of open-source engineering software by the worldwide community of engineers

groundhog is developed using a set of 10 Golden rules which are reflected in the groundhog function architecture and should also be followed by any contributors to the project.

For more information, consult the [documentation](https://groundhog.readthedocs.io/en/master/) or get started using the [tutorial notebooks](https://mybinder.org/v2/gh/snakesonabrain/groundhog/master). [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/snakesonabrain/groundhog/master)

Installation requirements
-------------------------

groundhog is written for Python 3.7+. Downloading Anaconda3 is recommended for users not familiar with Python development. Plotting functionality included in the package is built on plotly. The plotly package also needs to be installed and is not included in the default Anaconda installation.

Installing groundhog is easily done with pip:`

```
pip install groundhog
```


Support groundhog
-------------------

You can support the development of groundhog by buying me a coffee

<a href="https://www.buymeacoffee.com/groundhog"><img src="https://img.buymeacoffee.com/button-api/?text=Buy me a coffee&emoji=&slug=groundhog&button_colour=FFDD00&font_colour=000000&font_family=Cookie&outline_colour=000000&coffee_colour=ffffff"></a>


License and copyright
-----------------------

groundhog. A general-purpose Python library for geotechnical engineering.
    Copyright (C) 2020  Bruno Stuyts

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.


Disclaimer
-------------

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.