![image](https://raw.githubusercontent.com/Al-Taie/quick-mailer/master/images/bsmala.png)

# Description
This Module help you to send fast Email.

And you can attach **image, audio, and other files easily.**

The Module support **Gmail And Microsoft** right now, but in the nearly future will support other mail services.

# Installation:
```cmd
pip install quick-mailer
```

[-->> Github Link](https://github.com/Al-Taie/quick-mailer)

# Usage:
**Send Message**
```py
from mailer import Mailer

mail = Mailer(email='someone@gmail.com',
              password='your_password')

mail.send(receiver='someone@example.com',  # Email From Any service Provider
          subject='TEST',
          message='HI, This Message From Python :)')
```

**Check Send Status**
```py
# Uaing (status) Variable
print(mail.status)

# Example:
if mail.status:
  pass
else:
  pass
```

**Parameters**
```py
receiver: Email Address as String or List.                [Recuired]
cc: Email Address as String or List.  (Carbon Copy)       [Optional]
bcc: Email Address as String or List. (Blind Carbon Copy) [Optional]
subject: Message Title.                                   [Optional]
message: Your Message.                                    [Optional]
image: Image File Name.               (Image Path)        [Optional]
audio: Audio File Name.               (Audio Path)        [Optional]
file: File Name.                      (Any File Path)     [Optional]
```

**Send Multi Files**
```py
mail.send(receiver='someone@example.com',  # Email From Any service Provider
          subject='TEST',
          message='HI, This Message From Python :)',
          image='img.jpg',      # Image File Path
          audio='sound.mp3',    # Audio File Path
          file='file.zip')      # Any File Path
```

**Settings Method**
```py
mail.settings(repeat=1,             # To Repeat Sending
              sleep=0,              # To Sleep After Send Each Message
              provider=mail.GMAIL,  # Set Maill Service
              multi=False)          # Default False, If You Set True
                                    # Message Will Sent 4 Each Email Alone
                                    # Else Will Sent To All Together
```

**Send Multi Emails**
```py
# One By One:
mail.settings(multi=False)

# In Same Message:
mail.settings(multi=True)

mail.send(receiver=['someone@example.com', 'someone1@example.com'],
          subject='TEST',
          message='HI, This Message From Python :)',
          image='img.jpg',      # Image File Path
          audio='sound.mp3',    # Audio File Path
          file='file.zip')      # Any File Path
```

**Counter Variables**
```py
# CC Receivers Count
print('CC count:', mail.count_cc)

# BCC Receivers Count
print('BCC count:', mail.count_bcc)

# Receivers Count
print('Receivers count:', mail.count_rec)

# Messages Count
print('Messages count:', mail.count_msg)
```

**Example Function**
```py
from mailer import example

example()
```

**About Method**
```py
# You Can Use (mail.about) Method for more info.
mail.about()
```

**Follow Me on Instagram: [@9_Tay](https://www.instagram.com/9_tay).**

# Thank You :)