# DO NOT EDIT! This file is automatically generated
import datetime
import enum
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import CreatedBy, LastModifiedBy, LocalizedString, Money, TypedMoney
    from ._tax_category import TaxCategoryReference, TaxCategoryResourceIdentifier
    from ._zone import ZoneReference, ZoneResourceIdentifier
__all__ = [
    "CartClassificationTier",
    "CartScoreTier",
    "CartValueTier",
    "PriceFunction",
    "ShippingMethod",
    "ShippingMethodAddShippingRateAction",
    "ShippingMethodAddZoneAction",
    "ShippingMethodChangeIsDefaultAction",
    "ShippingMethodChangeNameAction",
    "ShippingMethodChangeTaxCategoryAction",
    "ShippingMethodDraft",
    "ShippingMethodPagedQueryResponse",
    "ShippingMethodReference",
    "ShippingMethodRemoveShippingRateAction",
    "ShippingMethodRemoveZoneAction",
    "ShippingMethodResourceIdentifier",
    "ShippingMethodSetDescriptionAction",
    "ShippingMethodSetKeyAction",
    "ShippingMethodSetLocalizedDescriptionAction",
    "ShippingMethodSetPredicateAction",
    "ShippingMethodUpdate",
    "ShippingMethodUpdateAction",
    "ShippingRate",
    "ShippingRateDraft",
    "ShippingRatePriceTier",
    "ShippingRateTierType",
    "ZoneRate",
    "ZoneRateDraft",
]


class PriceFunction(_BaseType):
    #: :class:`str` `(Named` ``currencyCode`` `in Commercetools)`
    currency_code: "str"
    #: :class:`str`
    function: str

    def __init__(self, *, currency_code: "str", function: str) -> None:
        self.currency_code = currency_code
        self.function = function
        super().__init__()

    def __repr__(self) -> str:
        return "PriceFunction(currency_code=%r, function=%r)" % (
            self.currency_code,
            self.function,
        )


class ShippingMethod(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`str`
    name: str
    #: Optional :class:`str`
    description: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``localizedDescription`` `in Commercetools)`
    localized_description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.TaxCategoryReference` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: "TaxCategoryReference"
    #: List of :class:`commercetools.types.ZoneRate` `(Named` ``zoneRates`` `in Commercetools)`
    zone_rates: typing.List["ZoneRate"]
    #: :class:`bool` `(Named` ``isDefault`` `in Commercetools)`
    is_default: bool
    #: Optional :class:`str`
    predicate: typing.Optional[str]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        name: str,
        tax_category: "TaxCategoryReference",
        zone_rates: typing.List["ZoneRate"],
        is_default: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        localized_description: typing.Optional["LocalizedString"] = None,
        predicate: typing.Optional[str] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.name = name
        self.description = description
        self.localized_description = localized_description
        self.tax_category = tax_category
        self.zone_rates = zone_rates
        self.is_default = is_default
        self.predicate = predicate
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "ShippingMethod(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, name=%r, description=%r, localized_description=%r, tax_category=%r, zone_rates=%r, is_default=%r, predicate=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.name,
                self.description,
                self.localized_description,
                self.tax_category,
                self.zone_rates,
                self.is_default,
                self.predicate,
            )
        )


class ShippingMethodDraft(_BaseType):
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`str`
    name: str
    #: Optional :class:`str`
    description: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``localizedDescription`` `in Commercetools)`
    localized_description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: "TaxCategoryResourceIdentifier"
    #: List of :class:`commercetools.types.ZoneRateDraft` `(Named` ``zoneRates`` `in Commercetools)`
    zone_rates: typing.List["ZoneRateDraft"]
    #: :class:`bool` `(Named` ``isDefault`` `in Commercetools)`
    is_default: bool
    #: Optional :class:`str`
    predicate: typing.Optional[str]

    def __init__(
        self,
        *,
        name: str,
        tax_category: "TaxCategoryResourceIdentifier",
        zone_rates: typing.List["ZoneRateDraft"],
        is_default: bool,
        key: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        localized_description: typing.Optional["LocalizedString"] = None,
        predicate: typing.Optional[str] = None
    ) -> None:
        self.key = key
        self.name = name
        self.description = description
        self.localized_description = localized_description
        self.tax_category = tax_category
        self.zone_rates = zone_rates
        self.is_default = is_default
        self.predicate = predicate
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShippingMethodDraft(key=%r, name=%r, description=%r, localized_description=%r, tax_category=%r, zone_rates=%r, is_default=%r, predicate=%r)"
            % (
                self.key,
                self.name,
                self.description,
                self.localized_description,
                self.tax_category,
                self.zone_rates,
                self.is_default,
                self.predicate,
            )
        )


class ShippingMethodPagedQueryResponse(_BaseType):
    #: Optional :class:`int`
    limit: typing.Optional[int]
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: Optional :class:`int`
    offset: typing.Optional[int]
    #: List of :class:`commercetools.types.ShippingMethod`
    results: typing.Sequence["ShippingMethod"]

    def __init__(
        self,
        *,
        count: int,
        results: typing.Sequence["ShippingMethod"],
        limit: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        offset: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShippingMethodPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class ShippingMethodReference(Reference):
    #: Optional :class:`commercetools.types.ShippingMethod`
    obj: typing.Optional["ShippingMethod"]

    def __init__(
        self, *, id: str, obj: typing.Optional["ShippingMethod"] = None
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.SHIPPING_METHOD, id=id)

    def __repr__(self) -> str:
        return "ShippingMethodReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class ShippingMethodResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.SHIPPING_METHOD, id=id, key=key)

    def __repr__(self) -> str:
        return "ShippingMethodResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class ShippingMethodUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingMethodUpdate(version=%r, actions=%r)" % (
            self.version,
            self.actions,
        )


class ShippingMethodUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingMethodUpdateAction(action=%r)" % (self.action,)


class ShippingRate(_BaseType):
    #: :class:`commercetools.types.TypedMoney`
    price: "TypedMoney"
    #: Optional :class:`commercetools.types.TypedMoney` `(Named` ``freeAbove`` `in Commercetools)`
    free_above: typing.Optional["TypedMoney"]
    #: Optional :class:`bool` `(Named` ``isMatching`` `in Commercetools)`
    is_matching: typing.Optional[bool]
    #: List of :class:`commercetools.types.ShippingRatePriceTier`
    tiers: typing.List["ShippingRatePriceTier"]

    def __init__(
        self,
        *,
        price: "TypedMoney",
        tiers: typing.List["ShippingRatePriceTier"],
        free_above: typing.Optional["TypedMoney"] = None,
        is_matching: typing.Optional[bool] = None
    ) -> None:
        self.price = price
        self.free_above = free_above
        self.is_matching = is_matching
        self.tiers = tiers
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingRate(price=%r, free_above=%r, is_matching=%r, tiers=%r)" % (
            self.price,
            self.free_above,
            self.is_matching,
            self.tiers,
        )


class ShippingRateDraft(_BaseType):
    #: :class:`commercetools.types.Money`
    price: "Money"
    #: Optional :class:`commercetools.types.Money` `(Named` ``freeAbove`` `in Commercetools)`
    free_above: typing.Optional["Money"]
    #: Optional list of :class:`commercetools.types.ShippingRatePriceTier`
    tiers: typing.Optional[typing.List["ShippingRatePriceTier"]]

    def __init__(
        self,
        *,
        price: "Money",
        free_above: typing.Optional["Money"] = None,
        tiers: typing.Optional[typing.List["ShippingRatePriceTier"]] = None
    ) -> None:
        self.price = price
        self.free_above = free_above
        self.tiers = tiers
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingRateDraft(price=%r, free_above=%r, tiers=%r)" % (
            self.price,
            self.free_above,
            self.tiers,
        )


class ShippingRatePriceTier(_BaseType):
    #: :class:`commercetools.types.ShippingRateTierType`
    type: "ShippingRateTierType"

    def __init__(self, *, type: "ShippingRateTierType") -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "ShippingRatePriceTier(type=%r)" % (self.type,)


class ShippingRateTierType(enum.Enum):
    CART_VALUE = "CartValue"
    CART_CLASSIFICATION = "CartClassification"
    CART_SCORE = "CartScore"


class ZoneRate(_BaseType):
    #: :class:`commercetools.types.ZoneReference`
    zone: "ZoneReference"
    #: List of :class:`commercetools.types.ShippingRate` `(Named` ``shippingRates`` `in Commercetools)`
    shipping_rates: typing.List["ShippingRate"]

    def __init__(
        self, *, zone: "ZoneReference", shipping_rates: typing.List["ShippingRate"]
    ) -> None:
        self.zone = zone
        self.shipping_rates = shipping_rates
        super().__init__()

    def __repr__(self) -> str:
        return "ZoneRate(zone=%r, shipping_rates=%r)" % (self.zone, self.shipping_rates)


class ZoneRateDraft(_BaseType):
    #: :class:`commercetools.types.ZoneResourceIdentifier`
    zone: "ZoneResourceIdentifier"
    #: List of :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRates`` `in Commercetools)`
    shipping_rates: typing.List["ShippingRateDraft"]

    def __init__(
        self,
        *,
        zone: "ZoneResourceIdentifier",
        shipping_rates: typing.List["ShippingRateDraft"]
    ) -> None:
        self.zone = zone
        self.shipping_rates = shipping_rates
        super().__init__()

    def __repr__(self) -> str:
        return "ZoneRateDraft(zone=%r, shipping_rates=%r)" % (
            self.zone,
            self.shipping_rates,
        )


class CartClassificationTier(ShippingRatePriceTier):
    #: :class:`str`
    value: str
    #: :class:`commercetools.types.Money`
    price: "Money"
    #: Optional :class:`bool` `(Named` ``isMatching`` `in Commercetools)`
    is_matching: typing.Optional[bool]

    def __init__(
        self, *, value: str, price: "Money", is_matching: typing.Optional[bool] = None
    ) -> None:
        self.value = value
        self.price = price
        self.is_matching = is_matching
        super().__init__(type=ShippingRateTierType.CART_CLASSIFICATION)

    def __repr__(self) -> str:
        return "CartClassificationTier(type=%r, value=%r, price=%r, is_matching=%r)" % (
            self.type,
            self.value,
            self.price,
            self.is_matching,
        )


class CartScoreTier(ShippingRatePriceTier):
    #: :class:`int`
    score: int
    #: Optional :class:`commercetools.types.Money`
    price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.PriceFunction` `(Named` ``priceFunction`` `in Commercetools)`
    price_function: typing.Optional["PriceFunction"]
    #: Optional :class:`bool` `(Named` ``isMatching`` `in Commercetools)`
    is_matching: typing.Optional[bool]

    def __init__(
        self,
        *,
        score: int,
        price: typing.Optional["Money"] = None,
        price_function: typing.Optional["PriceFunction"] = None,
        is_matching: typing.Optional[bool] = None
    ) -> None:
        self.score = score
        self.price = price
        self.price_function = price_function
        self.is_matching = is_matching
        super().__init__(type=ShippingRateTierType.CART_SCORE)

    def __repr__(self) -> str:
        return (
            "CartScoreTier(type=%r, score=%r, price=%r, price_function=%r, is_matching=%r)"
            % (self.type, self.score, self.price, self.price_function, self.is_matching)
        )


class CartValueTier(ShippingRatePriceTier):
    #: :class:`int` `(Named` ``minimumCentAmount`` `in Commercetools)`
    minimum_cent_amount: int
    #: :class:`commercetools.types.Money`
    price: "Money"
    #: Optional :class:`bool` `(Named` ``isMatching`` `in Commercetools)`
    is_matching: typing.Optional[bool]

    def __init__(
        self,
        *,
        minimum_cent_amount: int,
        price: "Money",
        is_matching: typing.Optional[bool] = None
    ) -> None:
        self.minimum_cent_amount = minimum_cent_amount
        self.price = price
        self.is_matching = is_matching
        super().__init__(type=ShippingRateTierType.CART_VALUE)

    def __repr__(self) -> str:
        return (
            "CartValueTier(type=%r, minimum_cent_amount=%r, price=%r, is_matching=%r)"
            % (self.type, self.minimum_cent_amount, self.price, self.is_matching)
        )


class ShippingMethodAddShippingRateAction(ShippingMethodUpdateAction):
    #: :class:`commercetools.types.ZoneResourceIdentifier`
    zone: "ZoneResourceIdentifier"
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRateDraft"

    def __init__(
        self, *, zone: "ZoneResourceIdentifier", shipping_rate: "ShippingRateDraft"
    ) -> None:
        self.zone = zone
        self.shipping_rate = shipping_rate
        super().__init__(action="addShippingRate")

    def __repr__(self) -> str:
        return (
            "ShippingMethodAddShippingRateAction(action=%r, zone=%r, shipping_rate=%r)"
            % (self.action, self.zone, self.shipping_rate)
        )


class ShippingMethodAddZoneAction(ShippingMethodUpdateAction):
    #: :class:`commercetools.types.ZoneResourceIdentifier`
    zone: "ZoneResourceIdentifier"

    def __init__(self, *, zone: "ZoneResourceIdentifier") -> None:
        self.zone = zone
        super().__init__(action="addZone")

    def __repr__(self) -> str:
        return "ShippingMethodAddZoneAction(action=%r, zone=%r)" % (
            self.action,
            self.zone,
        )


class ShippingMethodChangeIsDefaultAction(ShippingMethodUpdateAction):
    #: :class:`bool` `(Named` ``isDefault`` `in Commercetools)`
    is_default: bool

    def __init__(self, *, is_default: bool) -> None:
        self.is_default = is_default
        super().__init__(action="changeIsDefault")

    def __repr__(self) -> str:
        return "ShippingMethodChangeIsDefaultAction(action=%r, is_default=%r)" % (
            self.action,
            self.is_default,
        )


class ShippingMethodChangeNameAction(ShippingMethodUpdateAction):
    #: :class:`str`
    name: str

    def __init__(self, *, name: str) -> None:
        self.name = name
        super().__init__(action="changeName")

    def __repr__(self) -> str:
        return "ShippingMethodChangeNameAction(action=%r, name=%r)" % (
            self.action,
            self.name,
        )


class ShippingMethodChangeTaxCategoryAction(ShippingMethodUpdateAction):
    #: :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: "TaxCategoryResourceIdentifier"

    def __init__(self, *, tax_category: "TaxCategoryResourceIdentifier") -> None:
        self.tax_category = tax_category
        super().__init__(action="changeTaxCategory")

    def __repr__(self) -> str:
        return "ShippingMethodChangeTaxCategoryAction(action=%r, tax_category=%r)" % (
            self.action,
            self.tax_category,
        )


class ShippingMethodRemoveShippingRateAction(ShippingMethodUpdateAction):
    #: :class:`commercetools.types.ZoneResourceIdentifier`
    zone: "ZoneResourceIdentifier"
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRateDraft"

    def __init__(
        self, *, zone: "ZoneResourceIdentifier", shipping_rate: "ShippingRateDraft"
    ) -> None:
        self.zone = zone
        self.shipping_rate = shipping_rate
        super().__init__(action="removeShippingRate")

    def __repr__(self) -> str:
        return (
            "ShippingMethodRemoveShippingRateAction(action=%r, zone=%r, shipping_rate=%r)"
            % (self.action, self.zone, self.shipping_rate)
        )


class ShippingMethodRemoveZoneAction(ShippingMethodUpdateAction):
    #: :class:`commercetools.types.ZoneResourceIdentifier`
    zone: "ZoneResourceIdentifier"

    def __init__(self, *, zone: "ZoneResourceIdentifier") -> None:
        self.zone = zone
        super().__init__(action="removeZone")

    def __repr__(self) -> str:
        return "ShippingMethodRemoveZoneAction(action=%r, zone=%r)" % (
            self.action,
            self.zone,
        )


class ShippingMethodSetDescriptionAction(ShippingMethodUpdateAction):
    #: Optional :class:`str`
    description: typing.Optional[str]

    def __init__(self, *, description: typing.Optional[str] = None) -> None:
        self.description = description
        super().__init__(action="setDescription")

    def __repr__(self) -> str:
        return "ShippingMethodSetDescriptionAction(action=%r, description=%r)" % (
            self.action,
            self.description,
        )


class ShippingMethodSetKeyAction(ShippingMethodUpdateAction):
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(self, *, key: typing.Optional[str] = None) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "ShippingMethodSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class ShippingMethodSetLocalizedDescriptionAction(ShippingMethodUpdateAction):
    #: Optional :class:`str` `(Named` ``localizedDescription`` `in Commercetools)`
    localized_description: typing.Optional[str]

    def __init__(self, *, localized_description: typing.Optional[str] = None) -> None:
        self.localized_description = localized_description
        super().__init__(action="setLocalizedDescription")

    def __repr__(self) -> str:
        return (
            "ShippingMethodSetLocalizedDescriptionAction(action=%r, localized_description=%r)"
            % (self.action, self.localized_description)
        )


class ShippingMethodSetPredicateAction(ShippingMethodUpdateAction):
    #: Optional :class:`str`
    predicate: typing.Optional[str]

    def __init__(self, *, predicate: typing.Optional[str] = None) -> None:
        self.predicate = predicate
        super().__init__(action="setPredicate")

    def __repr__(self) -> str:
        return "ShippingMethodSetPredicateAction(action=%r, predicate=%r)" % (
            self.action,
            self.predicate,
        )
