# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)

__all__ = [
    "CartDiscountChangeCartPredicateActionSchema",
    "CartDiscountChangeIsActiveActionSchema",
    "CartDiscountChangeNameActionSchema",
    "CartDiscountChangeRequiresDiscountCodeActionSchema",
    "CartDiscountChangeSortOrderActionSchema",
    "CartDiscountChangeStackingModeActionSchema",
    "CartDiscountChangeTargetActionSchema",
    "CartDiscountChangeValueActionSchema",
    "CartDiscountCustomLineItemsTargetSchema",
    "CartDiscountDraftSchema",
    "CartDiscountLineItemsTargetSchema",
    "CartDiscountPagedQueryResponseSchema",
    "CartDiscountReferenceSchema",
    "CartDiscountResourceIdentifierSchema",
    "CartDiscountSchema",
    "CartDiscountSetCustomFieldActionSchema",
    "CartDiscountSetCustomTypeActionSchema",
    "CartDiscountSetDescriptionActionSchema",
    "CartDiscountSetKeyActionSchema",
    "CartDiscountSetValidFromActionSchema",
    "CartDiscountSetValidFromAndUntilActionSchema",
    "CartDiscountSetValidUntilActionSchema",
    "CartDiscountShippingCostTargetSchema",
    "CartDiscountTargetSchema",
    "CartDiscountUpdateActionSchema",
    "CartDiscountUpdateSchema",
    "CartDiscountValueAbsoluteDraftSchema",
    "CartDiscountValueAbsoluteSchema",
    "CartDiscountValueDraftSchema",
    "CartDiscountValueGiftLineItemDraftSchema",
    "CartDiscountValueGiftLineItemSchema",
    "CartDiscountValueRelativeDraftSchema",
    "CartDiscountValueRelativeSchema",
    "CartDiscountValueSchema",
    "MultiBuyCustomLineItemsTargetSchema",
    "MultiBuyLineItemsTargetSchema",
]


class CartDiscountDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountDraft`."""

    name = LocalizedStringField(allow_none=True)
    key = marshmallow.fields.String(allow_none=True, missing=None)
    description = LocalizedStringField(allow_none=True, missing=None)
    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "absolute": "commercetools._schemas._cart_discount.CartDiscountValueAbsoluteDraftSchema",
            "giftLineItem": "commercetools._schemas._cart_discount.CartDiscountValueGiftLineItemDraftSchema",
            "relative": "commercetools._schemas._cart_discount.CartDiscountValueRelativeDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    cart_predicate = marshmallow.fields.String(
        allow_none=True, data_key="cartPredicate"
    )
    target = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "customLineItems": "commercetools._schemas._cart_discount.CartDiscountCustomLineItemsTargetSchema",
            "lineItems": "commercetools._schemas._cart_discount.CartDiscountLineItemsTargetSchema",
            "shipping": "commercetools._schemas._cart_discount.CartDiscountShippingCostTargetSchema",
            "multiBuyCustomLineItems": "commercetools._schemas._cart_discount.MultiBuyCustomLineItemsTargetSchema",
            "multiBuyLineItems": "commercetools._schemas._cart_discount.MultiBuyLineItemsTargetSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    sort_order = marshmallow.fields.String(allow_none=True, data_key="sortOrder")
    is_active = marshmallow.fields.Bool(
        allow_none=True, missing=None, data_key="isActive"
    )
    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )
    requires_discount_code = marshmallow.fields.Bool(
        allow_none=True, data_key="requiresDiscountCode"
    )
    stacking_mode = marshmallow_enum.EnumField(
        types.StackingMode, by_value=True, missing=None, data_key="stackingMode"
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartDiscountDraft(**data)


class CartDiscountPagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountPagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._cart_discount.CartDiscountSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartDiscountPagedQueryResponse(**data)


class CartDiscountReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._cart_discount.CartDiscountSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.CartDiscountReference(**data)


class CartDiscountResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.CartDiscountResourceIdentifier(**data)


class CartDiscountSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscount`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    name = LocalizedStringField(allow_none=True)
    key = marshmallow.fields.String(allow_none=True, missing=None)
    description = LocalizedStringField(allow_none=True, missing=None)
    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "absolute": "commercetools._schemas._cart_discount.CartDiscountValueAbsoluteSchema",
            "giftLineItem": "commercetools._schemas._cart_discount.CartDiscountValueGiftLineItemSchema",
            "relative": "commercetools._schemas._cart_discount.CartDiscountValueRelativeSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    cart_predicate = marshmallow.fields.String(
        allow_none=True, data_key="cartPredicate"
    )
    target = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "customLineItems": "commercetools._schemas._cart_discount.CartDiscountCustomLineItemsTargetSchema",
            "lineItems": "commercetools._schemas._cart_discount.CartDiscountLineItemsTargetSchema",
            "shipping": "commercetools._schemas._cart_discount.CartDiscountShippingCostTargetSchema",
            "multiBuyCustomLineItems": "commercetools._schemas._cart_discount.MultiBuyCustomLineItemsTargetSchema",
            "multiBuyLineItems": "commercetools._schemas._cart_discount.MultiBuyLineItemsTargetSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    sort_order = marshmallow.fields.String(allow_none=True, data_key="sortOrder")
    is_active = marshmallow.fields.Bool(allow_none=True, data_key="isActive")
    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )
    requires_discount_code = marshmallow.fields.Bool(
        allow_none=True, data_key="requiresDiscountCode"
    )
    references = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("typeId", "type_id"),
            discriminator_schemas={
                "cart-discount": "commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
                "cart": "commercetools._schemas._cart.CartReferenceSchema",
                "category": "commercetools._schemas._category.CategoryReferenceSchema",
                "channel": "commercetools._schemas._channel.ChannelReferenceSchema",
                "key-value-document": "commercetools._schemas._custom_object.CustomObjectReferenceSchema",
                "customer-group": "commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
                "customer": "commercetools._schemas._customer.CustomerReferenceSchema",
                "discount-code": "commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
                "inventory-entry": "commercetools._schemas._inventory.InventoryEntryReferenceSchema",
                "order-edit": "commercetools._schemas._order_edit.OrderEditReferenceSchema",
                "order": "commercetools._schemas._order.OrderReferenceSchema",
                "payment": "commercetools._schemas._payment.PaymentReferenceSchema",
                "product-discount": "commercetools._schemas._product_discount.ProductDiscountReferenceSchema",
                "product-type": "commercetools._schemas._product_type.ProductTypeReferenceSchema",
                "product": "commercetools._schemas._product.ProductReferenceSchema",
                "review": "commercetools._schemas._review.ReviewReferenceSchema",
                "shipping-method": "commercetools._schemas._shipping_method.ShippingMethodReferenceSchema",
                "shopping-list": "commercetools._schemas._shopping_list.ShoppingListReferenceSchema",
                "state": "commercetools._schemas._state.StateReferenceSchema",
                "store": "commercetools._schemas._store.StoreReferenceSchema",
                "tax-category": "commercetools._schemas._tax_category.TaxCategoryReferenceSchema",
                "type": "commercetools._schemas._type.TypeReferenceSchema",
                "zone": "commercetools._schemas._zone.ZoneReferenceSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )
    stacking_mode = marshmallow_enum.EnumField(
        types.StackingMode, by_value=True, data_key="stackingMode"
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartDiscount(**data)


class CartDiscountTargetSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountTarget`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountTarget(**data)


class CartDiscountUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountUpdateAction(**data)


class CartDiscountUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "changeCartPredicate": "commercetools._schemas._cart_discount.CartDiscountChangeCartPredicateActionSchema",
                "changeIsActive": "commercetools._schemas._cart_discount.CartDiscountChangeIsActiveActionSchema",
                "changeName": "commercetools._schemas._cart_discount.CartDiscountChangeNameActionSchema",
                "changeRequiresDiscountCode": "commercetools._schemas._cart_discount.CartDiscountChangeRequiresDiscountCodeActionSchema",
                "changeSortOrder": "commercetools._schemas._cart_discount.CartDiscountChangeSortOrderActionSchema",
                "changeStackingMode": "commercetools._schemas._cart_discount.CartDiscountChangeStackingModeActionSchema",
                "changeTarget": "commercetools._schemas._cart_discount.CartDiscountChangeTargetActionSchema",
                "changeValue": "commercetools._schemas._cart_discount.CartDiscountChangeValueActionSchema",
                "setCustomField": "commercetools._schemas._cart_discount.CartDiscountSetCustomFieldActionSchema",
                "setCustomType": "commercetools._schemas._cart_discount.CartDiscountSetCustomTypeActionSchema",
                "setDescription": "commercetools._schemas._cart_discount.CartDiscountSetDescriptionActionSchema",
                "setKey": "commercetools._schemas._cart_discount.CartDiscountSetKeyActionSchema",
                "setValidFrom": "commercetools._schemas._cart_discount.CartDiscountSetValidFromActionSchema",
                "setValidFromAndUntil": "commercetools._schemas._cart_discount.CartDiscountSetValidFromAndUntilActionSchema",
                "setValidUntil": "commercetools._schemas._cart_discount.CartDiscountSetValidUntilActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartDiscountUpdate(**data)


class CartDiscountValueDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueDraft`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueDraft(**data)


class CartDiscountValueSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValue`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValue(**data)


class CartDiscountChangeCartPredicateActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeCartPredicateAction`."""

    cart_predicate = marshmallow.fields.String(
        allow_none=True, data_key="cartPredicate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeCartPredicateAction(**data)


class CartDiscountChangeIsActiveActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeIsActiveAction`."""

    is_active = marshmallow.fields.Bool(allow_none=True, data_key="isActive")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeIsActiveAction(**data)


class CartDiscountChangeNameActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeNameAction`."""

    name = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeNameAction(**data)


class CartDiscountChangeRequiresDiscountCodeActionSchema(
    CartDiscountUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeRequiresDiscountCodeAction`."""

    requires_discount_code = marshmallow.fields.Bool(
        allow_none=True, data_key="requiresDiscountCode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeRequiresDiscountCodeAction(**data)


class CartDiscountChangeSortOrderActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeSortOrderAction`."""

    sort_order = marshmallow.fields.String(allow_none=True, data_key="sortOrder")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeSortOrderAction(**data)


class CartDiscountChangeStackingModeActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeStackingModeAction`."""

    stacking_mode = marshmallow_enum.EnumField(
        types.StackingMode, by_value=True, data_key="stackingMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeStackingModeAction(**data)


class CartDiscountChangeTargetActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeTargetAction`."""

    target = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "customLineItems": "commercetools._schemas._cart_discount.CartDiscountCustomLineItemsTargetSchema",
            "lineItems": "commercetools._schemas._cart_discount.CartDiscountLineItemsTargetSchema",
            "shipping": "commercetools._schemas._cart_discount.CartDiscountShippingCostTargetSchema",
            "multiBuyCustomLineItems": "commercetools._schemas._cart_discount.MultiBuyCustomLineItemsTargetSchema",
            "multiBuyLineItems": "commercetools._schemas._cart_discount.MultiBuyLineItemsTargetSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeTargetAction(**data)


class CartDiscountChangeValueActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountChangeValueAction`."""

    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "absolute": "commercetools._schemas._cart_discount.CartDiscountValueAbsoluteDraftSchema",
            "giftLineItem": "commercetools._schemas._cart_discount.CartDiscountValueGiftLineItemDraftSchema",
            "relative": "commercetools._schemas._cart_discount.CartDiscountValueRelativeDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountChangeValueAction(**data)


class CartDiscountCustomLineItemsTargetSchema(CartDiscountTargetSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountCustomLineItemsTarget`."""

    predicate = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountCustomLineItemsTarget(**data)


class CartDiscountLineItemsTargetSchema(CartDiscountTargetSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountLineItemsTarget`."""

    predicate = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountLineItemsTarget(**data)


class CartDiscountSetCustomFieldActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetCustomFieldAction`."""

    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetCustomFieldAction(**data)


class CartDiscountSetCustomTypeActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetCustomTypeAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = marshmallow.fields.Dict(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetCustomTypeAction(**data)


class CartDiscountSetDescriptionActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetDescriptionAction`."""

    description = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetDescriptionAction(**data)


class CartDiscountSetKeyActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetKeyAction`."""

    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetKeyAction(**data)


class CartDiscountSetValidFromActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetValidFromAction`."""

    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetValidFromAction(**data)


class CartDiscountSetValidFromAndUntilActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetValidFromAndUntilAction`."""

    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetValidFromAndUntilAction(**data)


class CartDiscountSetValidUntilActionSchema(CartDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountSetValidUntilAction`."""

    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartDiscountSetValidUntilAction(**data)


class CartDiscountShippingCostTargetSchema(CartDiscountTargetSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountShippingCostTarget`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountShippingCostTarget()


class CartDiscountValueAbsoluteDraftSchema(CartDiscountValueDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueAbsoluteDraft`."""

    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueAbsoluteDraft(**data)


class CartDiscountValueAbsoluteSchema(CartDiscountValueSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueAbsolute`."""

    money = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("type", "type"),
            discriminator_schemas={
                "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
                "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueAbsolute(**data)


class CartDiscountValueGiftLineItemDraftSchema(CartDiscountValueDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueGiftLineItemDraft`."""

    product = helpers.LazyNestedField(
        nested="commercetools._schemas._product.ProductReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueGiftLineItemDraft(**data)


class CartDiscountValueGiftLineItemSchema(CartDiscountValueSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueGiftLineItem`."""

    product = helpers.LazyNestedField(
        nested="commercetools._schemas._product.ProductReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueGiftLineItem(**data)


class CartDiscountValueRelativeDraftSchema(CartDiscountValueDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueRelativeDraft`."""

    permyriad = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueRelativeDraft(**data)


class CartDiscountValueRelativeSchema(CartDiscountValueSchema):
    """Marshmallow schema for :class:`commercetools.types.CartDiscountValueRelative`."""

    permyriad = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CartDiscountValueRelative(**data)


class MultiBuyCustomLineItemsTargetSchema(CartDiscountTargetSchema):
    """Marshmallow schema for :class:`commercetools.types.MultiBuyCustomLineItemsTarget`."""

    predicate = marshmallow.fields.String(allow_none=True)
    trigger_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="triggerQuantity"
    )
    discounted_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="discountedQuantity"
    )
    max_occurrence = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="maxOccurrence"
    )
    selection_mode = marshmallow_enum.EnumField(
        types.SelectionMode, by_value=True, data_key="selectionMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.MultiBuyCustomLineItemsTarget(**data)


class MultiBuyLineItemsTargetSchema(CartDiscountTargetSchema):
    """Marshmallow schema for :class:`commercetools.types.MultiBuyLineItemsTarget`."""

    predicate = marshmallow.fields.String(allow_none=True)
    trigger_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="triggerQuantity"
    )
    discounted_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="discountedQuantity"
    )
    max_occurrence = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="maxOccurrence"
    )
    selection_mode = marshmallow_enum.EnumField(
        types.SelectionMode, by_value=True, data_key="selectionMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.MultiBuyLineItemsTarget(**data)
