# type: ignore
# pyright: reportUntypedFunctionDecorator=false
import os
from io import StringIO
import pytest
import pandas as pd
from tim import Tim


@pytest.fixture
def client() -> Tim:
    tim_user_email = os.getenv('TIM_USER_EMAIL')
    tim_user_password = os.getenv('TIM_USER_PASSWORD')
    tim_rest_api_url = os.getenv('TIM_API_URL', 'https://tim-platform-dev.tangent.works/api/v5')
    if tim_user_email is None:
        raise KeyError('TIM_USER_EMAIL environment variable not set')
    if tim_user_password is None:
        raise KeyError('TIM_USER_PASSWORD environment variable not set')
    return Tim(email=tim_user_email, password=tim_user_password, server=tim_rest_api_url)


@pytest.fixture
def dataset_a() -> pd.DataFrame:
    csv_data = StringIO("""Date;GasCons;Irradiation;Rain;Temperature;WindSpeed;PH;_LABEL
2004-01-01 00:00:00;53875.51;0;0.5;0;0;0;0
2004-01-01 01:00:00;51297.24;0;0.3;0.8;5.5;0;0
2004-01-01 02:00:00;51010.4;0;0.5;0.6;6.3;0;0
2004-01-01 03:00:00;51282.57;0;0.4;0.5;5.2;0;0
2004-01-01 04:00:00;54692.02;0;0.2;0.5;5.9;0;0
2004-01-01 05:00:00;63839.54;0;0.3;0.3;5.2;0;0
2004-01-01 06:00:00;74680.16;0;0.1;0.3;5;0;0
2004-01-01 07:00:00;74350.06;0;0.1;0.2;4.5;0;0
2004-01-01 08:00:00;74460.21;0;0;0.3;5.8;0;0
2004-01-01 09:00:00;78495.18;0;0;0.3;5;0;0
2004-01-01 10:00:00;82028.37;0;0;0.3;4.8;0;0
2004-01-01 11:00:00;82105.26;0;0;0.4;3.9;0;0
2004-01-01 12:00:00;81281.96;0;0;0.7;4.3;0;0
2004-01-01 13:00:00;81198.27;0;0;0.6;3.5;0;0
2004-01-01 14:00:00;79845.65;0;0;0.7;2.9;0;0
2004-01-01 15:00:00;79888.21;0;0;0.3;3.2;0;0
2004-01-01 16:00:00;80550.93;0;0;0.1;3.3;0;0
2004-01-01 17:00:00;80392.49;0;0;-0.6;3.9;0;0
2004-01-01 18:00:00;80333.84;0;0;-1.3;3.1;0;0
2004-01-01 19:00:00;79500.88;0;0;-1;2.9;0;0
2004-01-01 20:00:00;77970.51;0;0;-1.4;2.4;0;0
2004-01-01 21:00:00;71930.93;0;0;-2.2;1.9;0;0
2004-01-01 22:00:00;64984.37;0;0;-1.8;1.8;0;0
2004-01-01 23:00:00;59105.73;0;0;-2.4;2.5;0;0
2004-01-02 00:00:00;55157.31;0;0;-2.5;3.7;0;0
2004-01-02 01:00:00;53573.3;0;0;-2.6;3.3;0;0
2004-01-02 02:00:00;53100.85;0;0;-2.7;3.2;0;0
2004-01-02 03:00:00;54506.04;0;0;-2.7;3;0;0
2004-01-02 04:00:00;59215.17;0;0;-3;4;0;0
2004-01-02 05:00:00;71122.3;0;0;-3.1;3.9;0;0
2004-01-02 06:00:00;83493.65;0;0;-3.4;4.3;0;0
2004-01-02 07:00:00;85519;0;0;-3.8;3.7;0;0
2004-01-02 08:00:00;93233.79;0;0;-3.5;2.7;0;0
2004-01-02 09:00:00;91614.01;0;0;-2.6;3.6;0;0
2004-01-02 10:00:00;92103.63;0;0;-2.4;3.9;0;0
2004-01-02 11:00:00;88077.6;0;0;-2;3.9;0;0
2004-01-02 12:00:00;86324.42;0;0;-1.7;4.4;0;0
2004-01-02 13:00:00;84631.32;0;0;-1.8;3.9;0;0
2004-01-02 14:00:00;86291.51;0;0;-1.7;2.7;0;0
2004-01-02 15:00:00;88718.15;0;0;-2.6;3.8;0;0
2004-01-02 16:00:00;88812.21;0;0;-3;5;0;0
2004-01-02 17:00:00;90647.29;0;0;-3.2;5.3;0;0
2004-01-02 18:00:00;91845.76;0;0;-3.1;4.8;0;0
2004-01-02 19:00:00;90748.15;0;0;-2.8;5;0;0
2004-01-02 20:00:00;85903.11;0;0;-2.9;4.5;0;0
2004-01-02 21:00:00;83080.56;0;0;-3;4.2;0;0
2004-01-02 22:00:00;72264.26;0;0;-3;4.4;0;0
2004-01-02 23:00:00;65588.07;0;0;-3;4.1;0;0
2004-01-03 00:00:00;62194.72;0;0;-2.9;4.2;0;0
2004-01-03 01:00:00;58812.46;0;0;-2.7;3.6;0;0
2004-01-03 02:00:00;58670.83;0;0;-2.6;4.5;0;0
2004-01-03 03:00:00;58308.9;0;0;-2.5;4;0;0
2004-01-03 04:00:00;60123.95;0;0;-2.5;3.9;0;0
2004-01-03 05:00:00;70115.16;0;0;-2.5;4.4;0;0
2004-01-03 06:00:00;83422.47;0;0;-2.5;4.3;0;0
2004-01-03 07:00:00;85931.01;0;0;-2.4;4.5;0;0
2004-01-03 08:00:00;91858.28;0;0;-2.8;3.6;0;0
2004-01-03 09:00:00;94156.52;0;0;-3;4.7;0;0
2004-01-03 10:00:00;94503.08;0;0;-2.9;4.5;0;0
2004-01-03 11:00:00;96914.69;0;0;-2.5;2.9;0;0
2004-01-03 12:00:00;87740.34;0;0;-2.1;4.1;0;0
2004-01-03 13:00:00;87439.56;0;0;-2.6;3.6;0;0
2004-01-03 14:00:00;87113.74;0;0;-2.6;3;0;0
2004-01-03 15:00:00;89095.1;0;0;-3.2;3.2;0;0
2004-01-03 16:00:00;91444.84;0;0;-3.4;2.4;0;0
2004-01-03 17:00:00;92564.63;0;0;-3.6;3.5;0;0
2004-01-03 18:00:00;92542.82;0;0;-4;2.1;0;0
2004-01-03 19:00:00;92375.08;0;0;-4;3.4;0;0
2004-01-03 20:00:00;89752.82;0;0;-4.1;3.2;0;0
2004-01-03 21:00:00;83319.11;0;0;-4.2;2.7;0;0
2004-01-03 22:00:00;74272.09;0;0;-4.5;3.5;0;0
2004-01-03 23:00:00;68757.18;0;0;-5.5;3.9;0;0
2004-01-04 00:00:00;65806.24;0;0;-6.1;3.1;0;0
2004-01-04 01:00:00;63005.87;0;0;-6.3;3.1;0;0
2004-01-04 02:00:00;64578.08;0;0;-6.1;2.9;0;0
2004-01-04 03:00:00;65836.64;0;0;-6.1;2.7;0;0
2004-01-04 04:00:00;67703.91;0;0;-5.9;3.9;0;0
2004-01-04 05:00:00;75108.62;0;0;-5.9;3.4;0;0
2004-01-04 06:00:00;84909.57;0;0;-6.1;3.2;0;0
2004-01-04 07:00:00;95165.08;0;0;-5.8;3;0;0
2004-01-04 08:00:00;98880.67;0;0;-5.6;2.8;0;0
2004-01-04 09:00:00;102243.98;0;0;-5.4;2.4;0;0
2004-01-04 10:00:00;100945.36;0;0;-4.8;2.9;0;0
2004-01-04 11:00:00;100703.59;0;0;-4.1;3.9;0;0
2004-01-04 12:00:00;97832.41;0;0;-4.1;3.3;0;0
2004-01-04 13:00:00;96887.51;0;0;-4.1;2.7;0;0
2004-01-04 14:00:00;96898.24;0;0;-4.3;1.9;0;0
2004-01-04 15:00:00;95040.26;0;0;-4.3;2.4;0;0
2004-01-04 16:00:00;96911.47;0;0;-4.4;1.9;0;0
2004-01-04 17:00:00;94906.14;0;0;-4.7;1.5;0;0
2004-01-04 18:00:00;96356.76;0;0;-5.2;0.4;0;0
2004-01-04 19:00:00;97050.24;0;0;-5.2;1;0;0
2004-01-04 20:00:00;92230.59;0;0;-4.9;1;0;0
2004-01-04 21:00:00;88328.67;0;0.2;-4.9;0.9;0;0
2004-01-04 22:00:00;79566.69;0;0;-4.8;1.1;0;0
2004-01-04 23:00:00;70371.95;0;0.1;-4.7;1.1;0;0
2004-01-05 00:00:00;63636.4;0;0.3;-4.8;0.8;0;0
2004-01-05 01:00:00;64928.93;0;0.9;-4.8;1.3;0;0
2004-01-05 02:00:00;66193.57;0;1;-4.9;1.4;0;0
2004-01-05 03:00:00;69423.83;0;0.8;-4.9;0.6;0;0
2004-01-05 04:00:00;68835.15;0;0.7;-4.8;0.9;0;0
2004-01-05 05:00:00;82761.54;0;0.9;-4.9;1.4;0;0
2004-01-05 06:00:00;95067.8;0;2;-5.2;1.5;0;0
2004-01-05 07:00:00;99487.24;0;1.7;-5.2;1.6;0;1
2004-01-05 08:00:00;103853.74;0;1.7;-5.3;2.3;0;0
2004-01-05 09:00:00;107427.35;0;1.9;-5.1;2.1;0;0
2004-01-05 10:00:00;106865.13;0;1.9;-5.1;2.4;0;0
2004-01-05 11:00:00;102821.93;0;1.4;-5.1;3.2;0;0
2004-01-05 12:00:00;105945.98;0;0.5;-4.6;2.6;0;0
2004-01-05 13:00:00;103083.37;0;0.5;-4.7;3.2;0;0
2004-01-05 14:00:00;102548.69;0;0.1;-4.9;3.4;0;0
2004-01-05 15:00:00;101382.41;0;0;-5.1;3.1;0;0
2004-01-05 16:00:00;104982.48;0;0;-5.6;4.5;0;0
2004-01-05 17:00:00;101249.36;0;0;-6.1;4.8;0;1
2004-01-05 18:00:00;107214.55;0;0;-6.5;5.4;0;0
2004-01-05 19:00:00;111015.97;0;0;-6.2;6.3;0;0
2004-01-05 20:00:00;106984.22;0;0;-6.4;4.1;0;0
2004-01-05 21:00:00;96148.61;0;0;-6.9;4;0;0
2004-01-05 22:00:00;87257.87;0;0;-7.6;2.4;0;0
2004-01-05 23:00:00;79094.59;0;0;-9.5;2.8;0;0
2004-01-06 00:00:00;76695.14;0;0;-10.7;1.7;1;0
2004-01-06 01:00:00;74628.3;0;0;-10.6;3.4;1;0
2004-01-06 02:00:00;74337.9;0;0;-11;1.7;1;0
2004-01-06 03:00:00;76353.95;0;0;-11.3;2.1;1;0
2004-01-06 04:00:00;79839.57;0;0;-10.5;4.5;1;0
2004-01-06 05:00:00;90243.51;0;0;-10.4;4.4;1;0
2004-01-06 06:00:00;104332.99;0;0;-11;4.2;1;0
2004-01-06 07:00:00;106192.04;0;0;-11.9;2.1;1;1
2004-01-06 08:00:00;111955.15;0;0;-10.9;0.9;1;0
2004-01-06 09:00:00;116100.63;0;0;-9.8;1.2;1;0
2004-01-06 10:00:00;116980.44;0;0;-7.5;2;1;1
2004-01-06 11:00:00;114378.57;0;0;-6.3;2.1;1;0
2004-01-06 12:00:00;106084.39;0;0;-5.9;1.5;1;0
2004-01-06 13:00:00;104342.29;0;0;-7;1.7;1;0
2004-01-06 14:00:00;102386.68;0;0;-6.9;1.9;1;1
2004-01-06 15:00:00;105190.98;0;0;-8.2;1.4;1;0
2004-01-06 16:00:00;109636.53;0;0;-9.4;0.6;1;0
2004-01-06 17:00:00;112243.77;0;0;-9.3;1.3;1;0
2004-01-06 18:00:00;114862.82;0;0;-9.2;2;1;0
2004-01-06 19:00:00;113062.43;0;0;-8.4;2.7;1;0
2004-01-06 20:00:00;110926.92;0;0;-8.2;1.5;1;1
2004-01-06 21:00:00;103883.07;0;0;-8.6;1.8;1;0
2004-01-06 22:00:00;91921.59;0;0;-8.9;2.2;1;0
2004-01-06 23:00:00;82631;0;0;-8.7;2.2;1;0
2004-01-07 00:00:00;79546.66;0;0;-8.9;1.5;0;0
2004-01-07 01:00:00;74652.62;0;0;-8.9;1.2;0;0
2004-01-07 02:00:00;73637.62;0;0.1;-8.5;1.1;0;0
2004-01-07 03:00:00;75238.81;0;1;-8.4;1.3;0;0
2004-01-07 04:00:00;80800.21;0;0.8;-7.8;1.4;0;0
2004-01-07 05:00:00;92554.98;0;0.4;-6.9;1.7;0;0
2004-01-07 06:00:00;111015.26;0;0.2;-6.8;1.5;0;0
2004-01-07 07:00:00;115330.26;0;0.1;-7.2;1.6;0;0
2004-01-07 08:00:00;115248.72;0;0.2;-6.9;1;0;0
2004-01-07 09:00:00;113199.05;0;0.4;-6.7;1.8;0;0
2004-01-07 10:00:00;114844.58;0;0;-6.6;1.5;0;0
2004-01-07 11:00:00;112547.06;0;1.1;-6.6;2.1;0;0
2004-01-07 12:00:00;111848.93;0;1;-6.3;2.3;0;0
2004-01-07 13:00:00;111204.81;0;0;-5.8;0.8;0;0
2004-01-07 14:00:00;111578.19;0;0;-5.1;0.7;0;0
2004-01-07 15:00:00;110655.82;0;0;-5.1;1.4;0;0
2004-01-07 16:00:00;111213.39;0;0;-4.9;0.3;0;0
2004-01-07 17:00:00;113690.81;0;0;-4.5;0.4;0;0
2004-01-07 18:00:00;111704.8;0;0;-4.2;0.6;0;0
2004-01-07 19:00:00;112970.51;0;0;-4;0.4;0;0
2004-01-07 20:00:00;108121.54;0;0;-4;1.2;0;0
2004-01-07 21:00:00;99501.19;0;0;-4.1;0.5;0;0
2004-01-07 22:00:00;85609.48;0;0;-4.2;0.5;0;0
2004-01-07 23:00:00;76335.71;0;0;-4.1;0.4;0;0
2004-01-08 00:00:00;72812.53;0;0;-4;0.7;0;0
2004-01-08 01:00:00;67564.43;0;0;-4.4;1.6;0;0
2004-01-08 02:00:00;67127.38;0;0;-4.2;0.8;0;0
2004-01-08 03:00:00;69233.56;0;0;-4.3;0.2;0;0
2004-01-08 04:00:00;73821.1;0;0;-4.3;1;0;0
2004-01-08 05:00:00;88319.37;0;0;-4.7;1.3;0;0
2004-01-08 06:00:00;106236.03;0;0;-4.6;1.3;0;0
2004-01-08 07:00:00;112912.57;0;0;-4.2;1.6;0;0
2004-01-08 08:00:00;111918.32;0;0;-3;1.1;0;0
2004-01-08 09:00:00;107661.61;0;0;-1.5;1;0;0
2004-01-08 10:00:00;102380.24;0;0;-0.9;0.5;0;0
2004-01-08 11:00:00;97922.18;0;0;-0.2;1.4;0;0
2004-01-08 12:00:00;95890.03;182;0;0.1;1.6;0;0
2004-01-08 13:00:00;94382.19;104;0;-0.5;2.2;0;0
2004-01-08 14:00:00;95779.16;32;0;-1;2.1;0;0
2004-01-08 15:00:00;100987.57;6;0;-1.3;3.3;0;0
2004-01-08 16:00:00;101374.18;0;0;-1.9;4.3;0;0
2004-01-08 17:00:00;104027.56;0;0;-2.3;3.3;0;0
2004-01-08 18:00:00;104663.46;0;0;-2.3;4.1;0;0
2004-01-08 19:00:00;104194.22;0;0;-2.4;4.6;0;0
2004-01-08 20:00:00;102183.54;0;0;-2.4;4.4;0;0
2004-01-08 21:00:00;94554.94;0;0;-2.4;5.5;0;0
2004-01-08 22:00:00;82714.69;0;0;-2;5.6;0;0
2004-01-08 23:00:00;71445.25;0;0;-1.4;4.9;0;0
2004-01-09 00:00:00;65842;0;0;-1.2;5.8;0;0
2004-01-09 01:00:00;62915.74;0;0;-1.7;6.2;0;0
2004-01-09 02:00:00;63433.25;0;0;-2.4;6.3;0;0
2004-01-09 03:00:00;64593.82;0;0;-3;4.4;0;0
2004-01-09 04:00:00;73529.26;0;0.1;-3.3;3.9;0;0
2004-01-09 05:00:00;84281.9;0;0;-3.8;4.8;0;0
2004-01-09 06:00:00;102748.62;0;0;-4;4.2;0;0
2004-01-09 07:00:00;111008.46;6;0;-4;2.8;0;0
2004-01-09 08:00:00;110892.23;13;0;-4.2;4;0;0
2004-01-09 09:00:00;106795.39;19;0;-4.2;4.1;0;0
2004-01-09 10:00:00;104171.69;58;0.5;-4.5;4.1;0;0
2004-01-09 11:00:00;103890.22;65;0.8;-4.5;2;0;0
2004-01-09 12:00:00;105138.05;39;1.1;-4.7;2.7;0;0
2004-01-09 13:00:00;104276.13;26;0.9;-4.7;3.9;0;0
2004-01-09 14:00:00;103573.35;19;0.7;-4.6;2.1;0;0
2004-01-09 15:00:00;104330.49;6;0.5;-4.6;2.4;0;0
2004-01-09 16:00:00;104950.29;0;0;-4.6;2.7;0;0
2004-01-09 17:00:00;105826.17;0;0;-4.5;2;0;0
2004-01-09 18:00:00;104346.94;0;0;-4.3;2;0;0
2004-01-09 19:00:00;103320.85;0;0;-4.3;1.7;0;0
2004-01-09 20:00:00;99620.64;0;0;-4.4;2;0;0
2004-01-09 21:00:00;93744.15;0;0;-4.4;1.9;0;0
2004-01-09 22:00:00;81033.75;0;0;-4.5;1.8;0;0
2004-01-09 23:00:00;72307.54;0;0;-4.6;1.8;0;0
2004-01-10 00:00:00;68699.24;0;0;-4.2;2.1;0;0
2004-01-10 01:00:00;68649.17;0;0;-4.2;2.4;0;0
2004-01-10 02:00:00;64274.8;0;0;-4;2;0;0
2004-01-10 03:00:00;64034.82;0;0;-3.8;2.3;0;0
2004-01-10 04:00:00;67360.57;0;0;-4.7;1.4;0;0
2004-01-10 05:00:00;76314.61;0;0;-5.1;1.7;0;0
2004-01-10 06:00:00;92901.18;0;0;-5;1;0;0
2004-01-10 07:00:00;100100.24;13;0;-4.8;1.1;0;0
2004-01-10 08:00:00;103226.08;78;0;-4.4;1.7;0;0
2004-01-10 09:00:00;107567.19;84;0;-4;1.3;0;0
2004-01-10 10:00:00;103700.67;84;0.2;-3;1.3;0;0
2004-01-10 11:00:00;99813.05;71;0.4;-2.5;0.5;0;0
2004-01-10 12:00:00;96786.65;58;0;-1.3;1.7;0;0
2004-01-10 13:00:00;94390.78;97;0;2.8;4.7;0;0
2004-01-10 14:00:00;91280.32;71;0.5;2.7;4.7;0;0
2004-01-10 15:00:00;89388.02;13;1;2.2;5.4;0;0
2004-01-10 16:00:00;92616.49;0;0.6;2.3;4.9;0;0
2004-01-10 17:00:00;89676.28;0;0.4;2.7;5.6;0;0
2004-01-10 18:00:00;90790.71;0;1;2.5;6.4;0;0
2004-01-10 19:00:00;87633.76;0;0;2.6;6.9;0;0
2004-01-10 20:00:00;84589.47;0;0.4;2.7;5.9;0;0
2004-01-10 21:00:00;78544.18;0;3;2.3;5.1;0;0
2004-01-10 22:00:00;69885.2;0;1.2;2.4;4.6;0;0
2004-01-10 23:00:00;61525.93;0;0.5;2.5;5.2;0;0
2004-01-11 00:00:00;56840.04;0;0;2.5;4.4;0;0
2004-01-11 01:00:00;55313.61;0;0;2.7;6;0;0
2004-01-11 02:00:00;54194.17;0;0;2.7;5.7;0;0
2004-01-11 03:00:00;54584.01;0;0;2.5;5;0;0
2004-01-11 04:00:00;58221.63;0;0;1.9;4.7;0;0
2004-01-11 05:00:00;66171.04;0;0;0.4;2.7;0;0
2004-01-11 06:00:00;79428.64;0;0;0.1;2.2;0;0
2004-01-11 07:00:00;83867.74;26;0;0.3;3.5;0;0
2004-01-11 08:00:00;88718.86;110;0;1.4;0.5;0;0
2004-01-11 09:00:00;93160.47;298;0;4;1.9;0;0
2004-01-11 10:00:00;89198.82;233;0;4.7;2.9;0;0
2004-01-11 11:00:00;84721.45;220;0;5;2.5;0;0
2004-01-11 12:00:00;82452.89;169;0;5.2;1.7;0;0
2004-01-11 13:00:00;79468.33;110;0;5.2;1.8;0;0
2004-01-11 14:00:00;79448.66;45;0;4.3;1.6;0;0
2004-01-11 15:00:00;81106;13;0;3.9;1.4;0;0
2004-01-11 16:00:00;82403.9;0;0;3.1;1.7;0;0
2004-01-11 17:00:00;84568.37;0;0;2.5;1;0;0
2004-01-11 18:00:00;84234.33;0;0;2.4;1;0;0
2004-01-11 19:00:00;84277.61;0;0;2.3;2.2;0;0
2004-01-11 20:00:00;82669.27;0;1.5;1.9;1.7;0;0
2004-01-11 21:00:00;75258.84;0;2.7;1.7;1.6;0;0
2004-01-11 22:00:00;67083.75;0;3.5;1.6;0.9;0;0
2004-01-11 23:00:00;57523.15;0;2.3;1.5;1.4;0;0
2004-01-12 00:00:00;53250.34;0;0;1.7;0.3;0;0
2004-01-12 01:00:00;50734.66;0;0;1.6;1;0;0
2004-01-12 02:00:00;50468.57;0;0.4;1.3;0.8;0;0
2004-01-12 03:00:00;51204.96;0;0.1;1.1;0.4;0;0
2004-01-12 04:00:00;58847.15;0;0;1.2;1.2;0;0
2004-01-12 05:00:00;69644.5;0;0.2;1.2;1.8;0;0
2004-01-12 06:00:00;91787.47;0;0.2;1.2;1.9;0;0
2004-01-12 07:00:00;96896.45;6;0.1;6;8.7;0;0
2004-01-12 08:00:00;91415.87;32;0;6.3;10.3;0;0
2004-01-12 09:00:00;84850.2;0;0;7.3;10.8;0;0
2004-01-12 10:00:00;79156.82;318;0;8;11.9;0;0
2004-01-12 11:00:00;72133;344;0;8.2;7.2;0;0
2004-01-12 12:00:00;72711.68;324;0;8.7;8.4;0;0
2004-01-12 13:00:00;72306.46;259;0;8.2;6.3;0;0
2004-01-12 14:00:00;68365.56;117;0;7.8;3.2;0;0
2004-01-12 15:00:00;72189.87;13;0;6.9;2.7;0;0
2004-01-12 16:00:00;76350.37;0;0;5.7;2.2;0;0
2004-01-12 17:00:00;80195.79;0;0;4.9;3.7;0;0
2004-01-12 18:00:00;81861.7;0;0;3.3;2.3;0;0
2004-01-12 19:00:00;82867.05;0;0;3.2;2;0;0
2004-01-12 20:00:00;80126.4;0;0;2.7;3.2;0;0
2004-01-12 21:00:00;75112.92;0;0;2.7;2.4;0;0
2004-01-12 22:00:00;61697.24;0;0.3;2.7;1.6;0;0
2004-01-12 23:00:00;53570.79;0;0;2.8;0.9;0;0
2004-01-13 00:00:00;49450.35;0;0;2.9;2.4;0;0
2004-01-13 01:00:00;45570.24;0;0;7.9;9.6;0;0
2004-01-13 02:00:00;44459.75;0;0;8;12.2;0;0
2004-01-13 03:00:00;47112.41;0;0.1;7;10.6;0;0
2004-01-13 04:00:00;52839.77;0;1.1;5.6;8.3;0;0
2004-01-13 05:00:00;67719.65;0;0.6;5.6;7.7;0;0
2004-01-13 06:00:00;83496.15;0;0;6.3;9.6;0;0
2004-01-13 07:00:00;87940.26;32;0;6.2;4.6;0;0
2004-01-13 08:00:00;83760.81;175;0;8;5;0;0
2004-01-13 09:00:00;74441.61;169;0;8;2.3;0;0
2004-01-13 10:00:00;69665.96;195;0;8.4;1.3;0;0
2004-01-13 11:00:00;68221.07;162;0;8.6;2.2;0;0
2004-01-13 12:00:00;70423.45;110;0;7.2;3.2;0;0
2004-01-13 13:00:00;70593.69;65;0;7.1;4.7;0;0
2004-01-13 14:00:00;72776.77;0;0.7;5.3;3.4;0;0
2004-01-13 15:00:00;69968.89;6;1;5;1.6;0;0
2004-01-13 16:00:00;74210.22;0;0.3;4.7;1.9;0;0
2004-01-13 17:00:00;77313.16;0;1.1;4.4;1.8;0;0
2004-01-13 18:00:00;80543.06;0;1.3;4.2;0.9;0;0
2004-01-13 19:00:00;81306.64;0;0.3;4.1;0.9;0;0
2004-01-13 20:00:00;76749.51;0;0;4.2;0.8;0;0
2004-01-13 21:00:00;67147.77;0;0;3.1;2;0;0
2004-01-13 22:00:00;58475.56;0;0;3.7;2;0;0
2004-01-13 23:00:00;47822.7;0;0;3.7;2.5;0;0
2004-01-14 00:00:00;45050.58;0;0.7;4.6;2.8;0;0
2004-01-14 01:00:00;40557.11;0;2.4;7.3;6.2;0;0
2004-01-14 02:00:00;40743.09;0;0.6;6.5;11.4;0;0
2004-01-14 03:00:00;45049.87;0;0;5.5;11.3;0;0
2004-01-14 04:00:00;51321.91;0;0;5.9;9.5;0;0
2004-01-14 05:00:00;64013;0;0;0;0;0;0
2004-01-14 06:00:00;80087.78;0;0;6.6;8.7;0;0
2004-01-14 07:00:00;85536.16;26;0;6.7;8.4;0;0
2004-01-14 08:00:00;80631.76;149;0;7.5;8.7;0;0
2004-01-14 09:00:00;73326.47;97;0;7.1;8.2;0;0
2004-01-14 10:00:00;71137.67;136;0.6;5.6;7.6;0;0
2004-01-14 11:00:00;72678.06;337;0;7.6;6.5;0;0
2004-01-14 12:00:00;66541.92;143;0;5;9.2;0;0
2004-01-14 13:00:00;72205.96;253;0;6.5;8.4;0;0
2004-01-14 14:00:00;66806.58;156;0;7.1;7.3;0;0
2004-01-14 15:00:00;68517.91;19;0;6.9;6.4;0;0
2004-01-14 16:00:00;73567.52;0;0;6;4.6;0;0
2004-01-14 17:00:00;75461.62;0;0;4.3;2.3;0;0
2004-01-14 18:00:00;76317.11;0;0;4.9;5.9;0;0
2004-01-14 19:00:00;77632.53;0;0;5.7;6.1;0;0
2004-01-14 20:00:00;73249.58;0;0;4.9;1.6;0;0
2004-01-14 21:00:00;67751.48;0;0;3.2;1.3;0;0
2004-01-14 22:00:00;59113.96;0;0;1.7;2.6;0;0
2004-01-14 23:00:00;50825.14;0;0;1.6;2.7;0;0
""")
    df = pd.read_csv(csv_data, sep=";")
    df['Date'] = pd.to_datetime(df['Date'])
    return df


@pytest.fixture
def dataset_b() -> pd.DataFrame:
    csv_data = StringIO("""Date;GasCons;Irradiation;Rain;Temperature;WindSpeed;PH;_LABEL
2004-01-15 00:00:00;47793.37;0;0;1.3;1.7;0;0
2004-01-15 01:00:00;46045.2;0;0;0.7;0.2;0;0
2004-01-15 02:00:00;45997.99;0;0;0.6;0.4;0;0
2004-01-15 03:00:00;46323.45;0;0;1.1;3.6;0;0
2004-01-15 04:00:00;52671.67;0;0;1.9;1;0;0
2004-01-15 05:00:00;64598.47;0;0;4.7;6.5;0;0
2004-01-15 06:00:00;79577.06;0;0.5;3.8;5.8;0;0
2004-01-15 07:00:00;84819.44;6;0;4.3;6.4;0;0
2004-01-15 08:00:00;85663.13;39;0;4.6;5.7;0;0
2004-01-15 09:00:00;79403.96;97;0;5.4;7;0;0
2004-01-15 10:00:00;75830.35;104;0;5.4;6.3;0;0
2004-01-15 11:00:00;74395.12;110;0;5.5;9.4;0;0
2004-01-15 12:00:00;73317.53;117;0;5.3;8.6;0;0
2004-01-15 13:00:00;73889.76;143;0;5.4;6.7;0;0
2004-01-15 14:00:00;74783.88;58;0;5;7.4;0;0
2004-01-15 15:00:00;77256.29;6;0;4.6;6.4;0;0
2004-01-15 16:00:00;78797.39;0;0;4.3;5.4;0;0
2004-01-15 17:00:00;80050.94;0;0;4.3;7.9;0;0
2004-01-15 18:00:00;80685.05;0;0;4.2;7;0;0
2004-01-15 19:00:00;81697.9;0;0;4.3;8;0;0
2004-01-15 20:00:00;79219.41;0;0.6;3.2;6.6;0;0
2004-01-15 21:00:00;71062.21;0;0;3.8;6.9;0;0
2004-01-15 22:00:00;60014.87;0;0;3.9;6.9;0;0
2004-01-15 23:00:00;53536.82;0;0;3.2;7;0;0
""")
    df = pd.read_csv(csv_data, sep=";")
    df['Date'] = pd.to_datetime(df['Date'])
    return df
