# MIT LICENSE
#
# Copyright 1997 - 2020 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class Generate(Base):
    """This object specifies the properties of the generated report.
    The Generate class encapsulates a required generate resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'generate'
    _SDM_ATT_MAP = {
        'OutputFormat': 'outputFormat',
        'OutputPath': 'outputPath',
        'State': 'state',
        'TemplatePath': 'templatePath',
    }

    def __init__(self, parent):
        super(Generate, self).__init__(parent)

    @property
    def OutputFormat(self):
        """
        Returns
        -------
        - str(html | pdf): The format of the generated report, either PDF or HTML.
        """
        return self._get_attribute(self._SDM_ATT_MAP['OutputFormat'])
    @OutputFormat.setter
    def OutputFormat(self, value):
        self._set_attribute(self._SDM_ATT_MAP['OutputFormat'], value)

    @property
    def OutputPath(self):
        """
        Returns
        -------
        - str: The location where the generated report is saved.
        """
        return self._get_attribute(self._SDM_ATT_MAP['OutputPath'])
    @OutputPath.setter
    def OutputPath(self, value):
        self._set_attribute(self._SDM_ATT_MAP['OutputPath'], value)

    @property
    def State(self):
        """
        Returns
        -------
        - str(done | failed | inProgress | none): The state of the generated report.
        """
        return self._get_attribute(self._SDM_ATT_MAP['State'])

    @property
    def TemplatePath(self):
        """
        Returns
        -------
        - str: The location of the template used to generate a report.
        """
        return self._get_attribute(self._SDM_ATT_MAP['TemplatePath'])
    @TemplatePath.setter
    def TemplatePath(self, value):
        self._set_attribute(self._SDM_ATT_MAP['TemplatePath'], value)

    def update(self, OutputFormat=None, OutputPath=None, TemplatePath=None):
        """Updates generate resource on the server.

        Args
        ----
        - OutputFormat (str(html | pdf)): The format of the generated report, either PDF or HTML.
        - OutputPath (str): The location where the generated report is saved.
        - TemplatePath (str): The location of the template used to generate a report.

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(self._map_locals(self._SDM_ATT_MAP, locals()))

    def GenerateReport(self):
        """Executes the generateReport operation on the server.

        NOT DEFINED

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        return self._execute('generateReport', payload=payload, response_object=None)
