# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudcheckr_cmx.api_client import ApiClient


class PermissionSetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_permission_set(self, customer_id, **kwargs):  # noqa: E501
        """Create a permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission_set(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param CreateRequestPermissionSetRequestModel request: 
        :return: PermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_permission_set_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_permission_set_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def create_permission_set_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Create a permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission_set_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param CreateRequestPermissionSetRequestModel request: 
        :return: PermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_permission_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `create_permission_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/permission-sets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionSetResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_permission_set(self, customer_id, permission_set_id, **kwargs):  # noqa: E501
        """Delete a permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission_set(customer_id, permission_set_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str permission_set_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_permission_set_with_http_info(customer_id, permission_set_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_permission_set_with_http_info(customer_id, permission_set_id, **kwargs)  # noqa: E501
            return data

    def delete_permission_set_with_http_info(self, customer_id, permission_set_id, **kwargs):  # noqa: E501
        """Delete a permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission_set_with_http_info(customer_id, permission_set_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str permission_set_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'permission_set_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_permission_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_permission_set`")  # noqa: E501
        # verify the required parameter 'permission_set_id' is set
        if ('permission_set_id' not in params or
                params['permission_set_id'] is None):
            raise ValueError("Missing the required parameter `permission_set_id` when calling `delete_permission_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'permission_set_id' in params:
            path_params['permissionSetId'] = params['permission_set_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/permission-sets/{permissionSetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all(self, customer_id, **kwargs):  # noqa: E501
        """Get all permission sets.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str search: finds all resources that match the specified value
        :param str owned_by: finds all resources owned by the specified entity.
        :param str action_type: determines which action is taken on a resource.
        :param str order_by: orders a given property
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :return: PaginationResponsePermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_all_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Get all permission sets.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str search: finds all resources that match the specified value
        :param str owned_by: finds all resources owned by the specified entity.
        :param str action_type: determines which action is taken on a resource.
        :param str order_by: orders a given property
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :return: PaginationResponsePermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'search', 'owned_by', 'action_type', 'order_by', 'page_size', 'pagination_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_all`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'owned_by' in params:
            query_params.append(('ownedBy', params['owned_by']))  # noqa: E501
        if 'action_type' in params:
            query_params.append(('actionType', params['action_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('$orderBy', params['order_by']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/permission-sets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationResponsePermissionSetResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_permission_set(self, customer_id, permission_set_id, **kwargs):  # noqa: E501
        """Get an individual permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permission_set(customer_id, permission_set_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str permission_set_id:  (required)
        :return: PermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_permission_set_with_http_info(customer_id, permission_set_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_permission_set_with_http_info(customer_id, permission_set_id, **kwargs)  # noqa: E501
            return data

    def get_permission_set_with_http_info(self, customer_id, permission_set_id, **kwargs):  # noqa: E501
        """Get an individual permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_permission_set_with_http_info(customer_id, permission_set_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str permission_set_id:  (required)
        :return: PermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'permission_set_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permission_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_permission_set`")  # noqa: E501
        # verify the required parameter 'permission_set_id' is set
        if ('permission_set_id' not in params or
                params['permission_set_id'] is None):
            raise ValueError("Missing the required parameter `permission_set_id` when calling `get_permission_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'permission_set_id' in params:
            path_params['permissionSetId'] = params['permission_set_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/permission-sets/{permissionSetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionSetResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_permission_set(self, customer_id, permission_set_id, **kwargs):  # noqa: E501
        """Update a permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permission_set(customer_id, permission_set_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str permission_set_id:  (required)
        :param UpdateRequestPermissionSetRequestModel request: 
        :return: PermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_permission_set_with_http_info(customer_id, permission_set_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_permission_set_with_http_info(customer_id, permission_set_id, **kwargs)  # noqa: E501
            return data

    def update_permission_set_with_http_info(self, customer_id, permission_set_id, **kwargs):  # noqa: E501
        """Update a permission set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_permission_set_with_http_info(customer_id, permission_set_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str permission_set_id:  (required)
        :param UpdateRequestPermissionSetRequestModel request: 
        :return: PermissionSetResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'permission_set_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_permission_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_permission_set`")  # noqa: E501
        # verify the required parameter 'permission_set_id' is set
        if ('permission_set_id' not in params or
                params['permission_set_id'] is None):
            raise ValueError("Missing the required parameter `permission_set_id` when calling `update_permission_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'permission_set_id' in params:
            path_params['permissionSetId'] = params['permission_set_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/permission-sets/{permissionSetId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionSetResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
