# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudcheckr_cmx.api_client import ApiClient


class AccountAttributesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def attach_account_attribute(self, customer_id, attribute_name, value, **kwargs):  # noqa: E501
        """Bulk associate account attribute name-value to list of general accounts.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_account_attribute(customer_id, attribute_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str attribute_name:  (required)
        :param str value:  (required)
        :param BulkAccountAttributeAssignmentRequestModel request: 
        :return: BulkAccountAssignmentResponseModelAccountAttributeAssignmentResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.attach_account_attribute_with_http_info(customer_id, attribute_name, value, **kwargs)  # noqa: E501
        else:
            (data) = self.attach_account_attribute_with_http_info(customer_id, attribute_name, value, **kwargs)  # noqa: E501
            return data

    def attach_account_attribute_with_http_info(self, customer_id, attribute_name, value, **kwargs):  # noqa: E501
        """Bulk associate account attribute name-value to list of general accounts.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_account_attribute_with_http_info(customer_id, attribute_name, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str attribute_name:  (required)
        :param str value:  (required)
        :param BulkAccountAttributeAssignmentRequestModel request: 
        :return: BulkAccountAssignmentResponseModelAccountAttributeAssignmentResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'attribute_name', 'value', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_account_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `attach_account_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_name' is set
        if ('attribute_name' not in params or
                params['attribute_name'] is None):
            raise ValueError("Missing the required parameter `attribute_name` when calling `attach_account_attribute`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `attach_account_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'attribute_name' in params:
            path_params['attributeName'] = params['attribute_name']  # noqa: E501
        if 'value' in params:
            path_params['value'] = params['value']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/account-attributes/{attributeName}/values/{value}/assign', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BulkAccountAssignmentResponseModelAccountAttributeAssignmentResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_account_attribute(self, customer_id, attribute_name, **kwargs):  # noqa: E501
        """Delete an account attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_attribute(customer_id, attribute_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str attribute_name:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_account_attribute_with_http_info(customer_id, attribute_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_account_attribute_with_http_info(customer_id, attribute_name, **kwargs)  # noqa: E501
            return data

    def delete_account_attribute_with_http_info(self, customer_id, attribute_name, **kwargs):  # noqa: E501
        """Delete an account attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_attribute_with_http_info(customer_id, attribute_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str attribute_name:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'attribute_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_account_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_name' is set
        if ('attribute_name' not in params or
                params['attribute_name'] is None):
            raise ValueError("Missing the required parameter `attribute_name` when calling `delete_account_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'attribute_name' in params:
            path_params['attributeName'] = params['attribute_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/account-attributes/{attributeName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_attribute(self, customer_id, attribute_name, **kwargs):  # noqa: E501
        """Get an individual account attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_attribute(customer_id, attribute_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str attribute_name:  (required)
        :return: AccountAttributeResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_attribute_with_http_info(customer_id, attribute_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_attribute_with_http_info(customer_id, attribute_name, **kwargs)  # noqa: E501
            return data

    def get_account_attribute_with_http_info(self, customer_id, attribute_name, **kwargs):  # noqa: E501
        """Get an individual account attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_attribute_with_http_info(customer_id, attribute_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str attribute_name:  (required)
        :return: AccountAttributeResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'attribute_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_account_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_name' is set
        if ('attribute_name' not in params or
                params['attribute_name'] is None):
            raise ValueError("Missing the required parameter `attribute_name` when calling `get_account_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'attribute_name' in params:
            path_params['attributeName'] = params['attribute_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/account-attributes/{attributeName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountAttributeResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_account_attributes(self, customer_id, **kwargs):  # noqa: E501
        """Get all account attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_account_attributes(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param bool include_values: 
        :param str search: finds all resources that match the specified value
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :return: PaginationResponseAccountAttributeResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_account_attributes_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_account_attributes_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def list_account_attributes_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Get all account attributes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_account_attributes_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param bool include_values: 
        :param str search: finds all resources that match the specified value
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :return: PaginationResponseAccountAttributeResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'include_values', 'search', 'page_size', 'pagination_key', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `list_account_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'include_values' in params:
            query_params.append(('includeValues', params['include_values']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('$orderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/account-attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationResponseAccountAttributeResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_account_attribute(self, customer_id, **kwargs):  # noqa: E501
        """Create/Update an account attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_attribute(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param UpdateRequestAccountAttributeRequestModel request: 
        :return: AccountAttributeResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_account_attribute_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_account_attribute_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def update_account_attribute_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Create/Update an account attribute.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_attribute_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param UpdateRequestAccountAttributeRequestModel request: 
        :return: AccountAttributeResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_account_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/account-attributes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountAttributeResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
