# cloudcheckr-cmx
CloudCheckr API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 0.1.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import cloudcheckr_cmx 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cloudcheckr_cmx
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import cloudcheckr_cmx
from cloudcheckr_cmx.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: oauth
configuration = cloudcheckr_cmx.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = cloudcheckr_cmx.AccountAttributesApi(cloudcheckr_cmx.ApiClient(configuration))
customer_id = 'customer_id_example' # str | 
attribute_name = 'attribute_name_example' # str | 
value = 'value_example' # str | 
request = cloudcheckr_cmx.BulkAccountAttributeAssignmentRequestModel() # BulkAccountAttributeAssignmentRequestModel |  (optional)

try:
    # Bulk associate account attribute name-value to list of general accounts.
    api_response = api_instance.attach_account_attribute(customer_id, attribute_name, value, request=request)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountAttributesApi->attach_account_attribute: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api-eu.cloudcheckr.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountAttributesApi* | [**attach_account_attribute**](docs/AccountAttributesApi.md#attach_account_attribute) | **PUT** /customer/v1/customers/{customerId}/account-attributes/{attributeName}/values/{value}/assign | Bulk associate account attribute name-value to list of general accounts.
*AccountAttributesApi* | [**delete_account_attribute**](docs/AccountAttributesApi.md#delete_account_attribute) | **DELETE** /customer/v1/customers/{customerId}/account-attributes/{attributeName} | Delete an account attribute.
*AccountAttributesApi* | [**get_account_attribute**](docs/AccountAttributesApi.md#get_account_attribute) | **GET** /customer/v1/customers/{customerId}/account-attributes/{attributeName} | Get an individual account attribute.
*AccountAttributesApi* | [**list_account_attributes**](docs/AccountAttributesApi.md#list_account_attributes) | **GET** /customer/v1/customers/{customerId}/account-attributes | Get all account attributes.
*AccountAttributesApi* | [**update_account_attribute**](docs/AccountAttributesApi.md#update_account_attribute) | **PUT** /customer/v1/customers/{customerId}/account-attributes | Create/Update an account attribute.
*AccountManagementApi* | [**attach_account_groups**](docs/AccountManagementApi.md#attach_account_groups) | **PUT** /customer/v1/customers/{customerId}/account-management/account-groups/{groupId}/attach | Bulk move account groups into a parent account group.
*AccountManagementApi* | [**attach_account_groups_to_root**](docs/AccountManagementApi.md#attach_account_groups_to_root) | **PUT** /customer/v1/customers/{customerId}/account-management/account-groups/root/attach | Bulk move account groups into the root path.
*AccountManagementApi* | [**create_account**](docs/AccountManagementApi.md#create_account) | **POST** /customer/v1/customers/{customerId}/account-management/accounts | Create a General Account.
*AccountManagementApi* | [**create_account_group**](docs/AccountManagementApi.md#create_account_group) | **POST** /customer/v1/customers/{customerId}/account-management/account-groups | Create a new account group.
*AccountManagementApi* | [**create_mav**](docs/AccountManagementApi.md#create_mav) | **POST** /customer/v1/customers/{customerId}/account-management/mavs | Create a MAV.
*AccountManagementApi* | [**delete_account**](docs/AccountManagementApi.md#delete_account) | **DELETE** /customer/v1/customers/{customerId}/account-management/accounts/{accountId} | Delete a general account.
*AccountManagementApi* | [**delete_account_group**](docs/AccountManagementApi.md#delete_account_group) | **DELETE** /customer/v1/customers/{customerId}/account-management/account-groups/{accountId} | Delete an account group
*AccountManagementApi* | [**delete_mav**](docs/AccountManagementApi.md#delete_mav) | **DELETE** /customer/v1/customers/{customerId}/account-management/mavs/{accountId} | Delete a MAV.
*AccountManagementApi* | [**get_account**](docs/AccountManagementApi.md#get_account) | **GET** /customer/v1/customers/{customerId}/account-management/accounts/{accountId} | Get an individual general account.
*AccountManagementApi* | [**get_account_group_parent_assignment**](docs/AccountManagementApi.md#get_account_group_parent_assignment) | **GET** /customer/v1/customers/{customerId}/account-management/parent-assignments/{parentAssignmentId} | Get an individual account group parent assignment.
*AccountManagementApi* | [**get_account_group_parent_assignments**](docs/AccountManagementApi.md#get_account_group_parent_assignments) | **GET** /customer/v1/customers/{customerId}/account-management/parent-assignments | Get all account group parent assignments.
*AccountManagementApi* | [**get_general_accounts**](docs/AccountManagementApi.md#get_general_accounts) | **GET** /customer/v1/customers/{customerId}/account-management/accounts | Get all general accounts.
*AccountManagementApi* | [**get_group**](docs/AccountManagementApi.md#get_group) | **GET** /customer/v1/customers/{customerId}/account-management/account-groups/{groupId} | Get an individual account group.
*AccountManagementApi* | [**get_group_children**](docs/AccountManagementApi.md#get_group_children) | **GET** /customer/v1/customers/{customerId}/account-management/account-groups/{groupId}/children | Get all children of an account group.
*AccountManagementApi* | [**get_groups**](docs/AccountManagementApi.md#get_groups) | **GET** /customer/v1/customers/{customerId}/account-management/account-groups | Get all account groups.
*AccountManagementApi* | [**get_mav**](docs/AccountManagementApi.md#get_mav) | **GET** /customer/v1/customers/{customerId}/account-management/mavs/{accountId} | Get an individual MAV.
*AccountManagementApi* | [**get_mav_accounts**](docs/AccountManagementApi.md#get_mav_accounts) | **GET** /customer/v1/customers/{customerId}/account-management/mavs | Get all MAVs.
*AccountManagementApi* | [**get_mav_referenced_accounts**](docs/AccountManagementApi.md#get_mav_referenced_accounts) | **GET** /customer/v1/customers/{customerId}/account-management/mavs/{accountId}/referenced-accounts | Get accounts associated with a MAV.
*AccountManagementApi* | [**get_root_children**](docs/AccountManagementApi.md#get_root_children) | **GET** /customer/v1/customers/{customerId}/account-management/account-groups/root/children | Get the root of the account hierarchy.
*AccountManagementApi* | [**update_account**](docs/AccountManagementApi.md#update_account) | **PUT** /customer/v1/customers/{customerId}/account-management/accounts/{accountId} | Update a General Account.
*AccountManagementApi* | [**update_account_group**](docs/AccountManagementApi.md#update_account_group) | **PUT** /customer/v1/customers/{customerId}/account-management/account-groups/{accountId} | Update an account group.
*AccountManagementApi* | [**update_mav**](docs/AccountManagementApi.md#update_mav) | **PUT** /customer/v1/customers/{customerId}/account-management/mavs/{accountId} | Update a MAV.
*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /customer/v1/customers/{customerId}/accounts/{accountId} | Get an individual account, account group, or MAV.
*AccountsApi* | [**get_accounts**](docs/AccountsApi.md#get_accounts) | **GET** /customer/v1/customers/{customerId}/accounts | Get all accounts, account groups, and MAVs.
*AccountsApi* | [**get_ancestors**](docs/AccountsApi.md#get_ancestors) | **GET** /customer/v1/customers/{customerId}/accounts/{accountId}/ancestors | Get all ancestors of an account.
*ClientAccessKeysApi* | [**create_client_access_key**](docs/ClientAccessKeysApi.md#create_client_access_key) | **POST** /auth/v1/customers/{customerId}/clients/{clientId}/access-keys | Create a new client access key.
*ClientAccessKeysApi* | [**delete_client_access_key**](docs/ClientAccessKeysApi.md#delete_client_access_key) | **DELETE** /auth/v1/customers/{customerId}/clients/{clientId}/access-keys/{accessKeyId} | Delete a client access key.
*ClientAccessKeysApi* | [**list_client_access_keys**](docs/ClientAccessKeysApi.md#list_client_access_keys) | **GET** /auth/v1/customers/{customerId}/clients/{clientId}/access-keys | Get all client access keys.
*ClientsApi* | [**create_client**](docs/ClientsApi.md#create_client) | **POST** /auth/v1/customers/{customerId}/clients | Create a new client.
*ClientsApi* | [**delete_client**](docs/ClientsApi.md#delete_client) | **DELETE** /auth/v1/customers/{customerId}/clients/{clientId} | Delete a client.
*ClientsApi* | [**get_client**](docs/ClientsApi.md#get_client) | **GET** /auth/v1/customers/{customerId}/clients/{clientId} | Get an individual client.
*ClientsApi* | [**list_clients**](docs/ClientsApi.md#list_clients) | **GET** /auth/v1/customers/{customerId}/clients | Get all clients.
*ClientsApi* | [**update_client**](docs/ClientsApi.md#update_client) | **PUT** /auth/v1/customers/{customerId}/clients/{clientId} | Update a client.
*CustomThemeSettingsApi* | [**get_theme_settings**](docs/CustomThemeSettingsApi.md#get_theme_settings) | **GET** /customer/v1/customers/theme | Retrieves the customer&#39;s theme settings.
*CustomThemeSettingsApi* | [**update_custom_theme_settings**](docs/CustomThemeSettingsApi.md#update_custom_theme_settings) | **PUT** /customer/v1/customers/{customerId}/theme | Update the custom theme settings such as logo, colors, etc.
*CustomersApi* | [**get_customer**](docs/CustomersApi.md#get_customer) | **GET** /customer/v1/customers/{customerId} | Get an individual customer.
*CustomersApi* | [**list_customers**](docs/CustomersApi.md#list_customers) | **GET** /customer/v1/customers | Get all customers.
*PermissionSetsApi* | [**create_permission_set**](docs/PermissionSetsApi.md#create_permission_set) | **POST** /policy/v1/customers/{customerId}/permission-sets | Create a permission set.
*PermissionSetsApi* | [**delete_permission_set**](docs/PermissionSetsApi.md#delete_permission_set) | **DELETE** /policy/v1/customers/{customerId}/permission-sets/{permissionSetId} | Delete a permission set.
*PermissionSetsApi* | [**get_all**](docs/PermissionSetsApi.md#get_all) | **GET** /policy/v1/customers/{customerId}/permission-sets | Get all permission sets.
*PermissionSetsApi* | [**get_permission_set**](docs/PermissionSetsApi.md#get_permission_set) | **GET** /policy/v1/customers/{customerId}/permission-sets/{permissionSetId} | Get an individual permission set.
*PermissionSetsApi* | [**update_permission_set**](docs/PermissionSetsApi.md#update_permission_set) | **PUT** /policy/v1/customers/{customerId}/permission-sets/{permissionSetId} | Update a permission set.
*PermissionsApi* | [**get_all**](docs/PermissionsApi.md#get_all) | **GET** /policy/v1/customers/{customerId}/permissions | Get all permissions.
*RolesApi* | [**create_role**](docs/RolesApi.md#create_role) | **POST** /policy/v1/customers/{customerId}/roles | Create a new role.
*RolesApi* | [**delete_role**](docs/RolesApi.md#delete_role) | **DELETE** /policy/v1/customers/{customerId}/roles/{roleId} | Delete a role.
*RolesApi* | [**get_all**](docs/RolesApi.md#get_all) | **GET** /policy/v1/customers/{customerId}/roles | Get all roles.
*RolesApi* | [**get_role**](docs/RolesApi.md#get_role) | **GET** /policy/v1/customers/{customerId}/roles/{roleId} | Get an individual role.
*RolesApi* | [**list_clients_with_role_id**](docs/RolesApi.md#list_clients_with_role_id) | **GET** /auth/v1/customers/{customerId}/roles/{roleId}/clients | Get all clients belonging to a role.
*RolesApi* | [**list_users_with_role_id**](docs/RolesApi.md#list_users_with_role_id) | **GET** /auth/v1/customers/{customerId}/roles/{roleId}/users | Get all users belonging to a role.
*RolesApi* | [**modify_client_roles**](docs/RolesApi.md#modify_client_roles) | **PUT** /auth/v1/customers/{customerId}/roles/{roleId}/clients | Add or remove a role from multiple clients.
*RolesApi* | [**modify_user_roles**](docs/RolesApi.md#modify_user_roles) | **PUT** /auth/v1/customers/{customerId}/roles/{roleId}/users | Add or remove a role from multiple users.
*RolesApi* | [**update_role**](docs/RolesApi.md#update_role) | **PUT** /policy/v1/customers/{customerId}/roles/{roleId} | Update a role.
*SAMLProviderRulesApi* | [**create_saml_provider_rule**](docs/SAMLProviderRulesApi.md#create_saml_provider_rule) | **POST** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules | Creates a new SAML provider rule for the specified SAML provider.
*SAMLProviderRulesApi* | [**delete_saml_provider_rule**](docs/SAMLProviderRulesApi.md#delete_saml_provider_rule) | **DELETE** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules/{ruleId} | Deletes a SAML provider rule.
*SAMLProviderRulesApi* | [**list_saml_provider_rules**](docs/SAMLProviderRulesApi.md#list_saml_provider_rules) | **GET** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules | Get all SAML provider rules assigned to a SAML provider.
*SAMLProviderRulesApi* | [**update_saml_provider_rule**](docs/SAMLProviderRulesApi.md#update_saml_provider_rule) | **PUT** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId}/rules/{ruleId} | Updates a SAML provider rule.
*SAMLProvidersApi* | [**create_saml_provider**](docs/SAMLProvidersApi.md#create_saml_provider) | **POST** /auth/v1/customers/{customerId}/saml-providers | Creates a new SAML provider entry for this customer.
*SAMLProvidersApi* | [**delete_saml_provider**](docs/SAMLProvidersApi.md#delete_saml_provider) | **DELETE** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId} | Deletes an existing SAML provider entry for this customer.
*SAMLProvidersApi* | [**get_saml_provider**](docs/SAMLProvidersApi.md#get_saml_provider) | **GET** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId} | Get a single SAML provider by ID.
*SAMLProvidersApi* | [**list_saml_providers**](docs/SAMLProvidersApi.md#list_saml_providers) | **GET** /auth/v1/customers/{customerId}/saml-providers | Get all SAML providers.
*SAMLProvidersApi* | [**update_saml_provider**](docs/SAMLProvidersApi.md#update_saml_provider) | **PUT** /auth/v1/customers/{customerId}/saml-providers/{samlProviderId} | Updates an existing SAML provider entry for this customer.
*TokenManagementApi* | [**exchange_token_for_delegate_access_token**](docs/TokenManagementApi.md#exchange_token_for_delegate_access_token) | **PUT** /auth/v1/token/exchange/{customerId} | Exchange a token for a different customer.
*TokenManagementApi* | [**get_token_info**](docs/TokenManagementApi.md#get_token_info) | **GET** /auth/v1/token/info | Get information about the current bearer token.
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /auth/v1/customers/{customerId}/users | Create a new user.
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /auth/v1/customers/{customerId}/users/{userId} | Delete a user.
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /auth/v1/customers/{customerId}/users/{userId} | Get an individual user.
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /auth/v1/customers/{customerId}/users | Get all users.
*UsersApi* | [**send_activation**](docs/UsersApi.md#send_activation) | **POST** /auth/v1/customers/{customerId}/users/{userId}/send-activation | Send a user activation email.
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /auth/v1/customers/{customerId}/users/{userId} | Update a user.


## Documentation For Models

 - [AccountAssignmentResponseModel](docs/AccountAssignmentResponseModel.md)
 - [AccountAttributeAssignmentResponseModel](docs/AccountAttributeAssignmentResponseModel.md)
 - [AccountAttributeBasicInfo](docs/AccountAttributeBasicInfo.md)
 - [AccountAttributeModification](docs/AccountAttributeModification.md)
 - [AccountAttributeRequestModel](docs/AccountAttributeRequestModel.md)
 - [AccountAttributeResponseModel](docs/AccountAttributeResponseModel.md)
 - [AccountCost](docs/AccountCost.md)
 - [AccountGroupHierarchyResponseModel](docs/AccountGroupHierarchyResponseModel.md)
 - [AccountGroupRequestModel](docs/AccountGroupRequestModel.md)
 - [AccountGroupResponseModel](docs/AccountGroupResponseModel.md)
 - [AccountGroupSearchResponseModel](docs/AccountGroupSearchResponseModel.md)
 - [AncestorModel](docs/AncestorModel.md)
 - [AncestorsResponseModel](docs/AncestorsResponseModel.md)
 - [BaseAccountInfo](docs/BaseAccountInfo.md)
 - [BasicRequestListModification](docs/BasicRequestListModification.md)
 - [BulkAccountAssignmentRequestModel](docs/BulkAccountAssignmentRequestModel.md)
 - [BulkAccountAssignmentResponseModelAccountAssignmentResponseModel](docs/BulkAccountAssignmentResponseModelAccountAssignmentResponseModel.md)
 - [BulkAccountAssignmentResponseModelAccountAttributeAssignmentResponseModel](docs/BulkAccountAssignmentResponseModelAccountAttributeAssignmentResponseModel.md)
 - [BulkAccountAttributeAssignmentRequestModel](docs/BulkAccountAttributeAssignmentRequestModel.md)
 - [ClientAccessKeyRequestModel](docs/ClientAccessKeyRequestModel.md)
 - [ClientAccessKeyResponseModel](docs/ClientAccessKeyResponseModel.md)
 - [ClientCreateRequestModel](docs/ClientCreateRequestModel.md)
 - [ClientRequestModel](docs/ClientRequestModel.md)
 - [ClientResponseModel](docs/ClientResponseModel.md)
 - [ClientRoleResponseModel](docs/ClientRoleResponseModel.md)
 - [CreateRequestAccountGroupRequestModel](docs/CreateRequestAccountGroupRequestModel.md)
 - [CreateRequestClientAccessKeyRequestModel](docs/CreateRequestClientAccessKeyRequestModel.md)
 - [CreateRequestClientCreateRequestModel](docs/CreateRequestClientCreateRequestModel.md)
 - [CreateRequestGeneralAccountRequestModel](docs/CreateRequestGeneralAccountRequestModel.md)
 - [CreateRequestMavRequestModel](docs/CreateRequestMavRequestModel.md)
 - [CreateRequestPermissionSetRequestModel](docs/CreateRequestPermissionSetRequestModel.md)
 - [CreateRequestRoleRequestModel](docs/CreateRequestRoleRequestModel.md)
 - [CreateRequestSamlProviderRequestModel](docs/CreateRequestSamlProviderRequestModel.md)
 - [CreateRequestSamlProviderRuleRequestModel](docs/CreateRequestSamlProviderRuleRequestModel.md)
 - [CreateRequestUserRequestModel](docs/CreateRequestUserRequestModel.md)
 - [CustomThemeRequestModel](docs/CustomThemeRequestModel.md)
 - [CustomThemeResponseModel](docs/CustomThemeResponseModel.md)
 - [CustomerAccountBasicInfo](docs/CustomerAccountBasicInfo.md)
 - [CustomerAccountModification](docs/CustomerAccountModification.md)
 - [CustomerResponseModel](docs/CustomerResponseModel.md)
 - [DeveloperInfo](docs/DeveloperInfo.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [GeneralAccountRequestModel](docs/GeneralAccountRequestModel.md)
 - [GeneralAccountResponseModel](docs/GeneralAccountResponseModel.md)
 - [ListModificationError](docs/ListModificationError.md)
 - [ListModificationRequestModel](docs/ListModificationRequestModel.md)
 - [ListModificationResponseModel](docs/ListModificationResponseModel.md)
 - [MappedRoleResponseModel](docs/MappedRoleResponseModel.md)
 - [MavRequestModel](docs/MavRequestModel.md)
 - [MavResponseModel](docs/MavResponseModel.md)
 - [MinimalClientResponseModel](docs/MinimalClientResponseModel.md)
 - [MinimalUserResponseModel](docs/MinimalUserResponseModel.md)
 - [NewClientAccessInfo](docs/NewClientAccessInfo.md)
 - [PaginationInfo](docs/PaginationInfo.md)
 - [PaginationResponseAccountAttributeResponseModel](docs/PaginationResponseAccountAttributeResponseModel.md)
 - [PaginationResponsePermissionSetResponseModel](docs/PaginationResponsePermissionSetResponseModel.md)
 - [PaginationResponseRoleResponseModel](docs/PaginationResponseRoleResponseModel.md)
 - [PaginationWithCountResponseAccountGroupHierarchyResponseModel](docs/PaginationWithCountResponseAccountGroupHierarchyResponseModel.md)
 - [PaginationWithCountResponseAccountGroupResponseModel](docs/PaginationWithCountResponseAccountGroupResponseModel.md)
 - [PaginationWithCountResponseAccountGroupSearchResponseModel](docs/PaginationWithCountResponseAccountGroupSearchResponseModel.md)
 - [PaginationWithCountResponseClientAccessKeyResponseModel](docs/PaginationWithCountResponseClientAccessKeyResponseModel.md)
 - [PaginationWithCountResponseClientResponseModel](docs/PaginationWithCountResponseClientResponseModel.md)
 - [PaginationWithCountResponseCustomerResponseModel](docs/PaginationWithCountResponseCustomerResponseModel.md)
 - [PaginationWithCountResponseGeneralAccountResponseModel](docs/PaginationWithCountResponseGeneralAccountResponseModel.md)
 - [PaginationWithCountResponseMavResponseModel](docs/PaginationWithCountResponseMavResponseModel.md)
 - [PaginationWithCountResponseMinimalClientResponseModel](docs/PaginationWithCountResponseMinimalClientResponseModel.md)
 - [PaginationWithCountResponseMinimalUserResponseModel](docs/PaginationWithCountResponseMinimalUserResponseModel.md)
 - [PaginationWithCountResponseParentAssignmentResponseModel](docs/PaginationWithCountResponseParentAssignmentResponseModel.md)
 - [PaginationWithCountResponsePermissionResponseModel](docs/PaginationWithCountResponsePermissionResponseModel.md)
 - [PaginationWithCountResponseReferencedAccountResponseModel](docs/PaginationWithCountResponseReferencedAccountResponseModel.md)
 - [PaginationWithCountResponseSamlProviderResponseModel](docs/PaginationWithCountResponseSamlProviderResponseModel.md)
 - [PaginationWithCountResponseSamlProviderRuleResponseModel](docs/PaginationWithCountResponseSamlProviderRuleResponseModel.md)
 - [PaginationWithCountResponseUserResponseModel](docs/PaginationWithCountResponseUserResponseModel.md)
 - [ParentAssignment](docs/ParentAssignment.md)
 - [ParentAssignmentResponseModel](docs/ParentAssignmentResponseModel.md)
 - [PermissionGroupModel](docs/PermissionGroupModel.md)
 - [PermissionResponseModel](docs/PermissionResponseModel.md)
 - [PermissionSetBasicInfo](docs/PermissionSetBasicInfo.md)
 - [PermissionSetPermissionModel](docs/PermissionSetPermissionModel.md)
 - [PermissionSetRequestModel](docs/PermissionSetRequestModel.md)
 - [PermissionSetResponseModel](docs/PermissionSetResponseModel.md)
 - [PermittedChildCustomerModel](docs/PermittedChildCustomerModel.md)
 - [ReferencedAccountResponseModel](docs/ReferencedAccountResponseModel.md)
 - [RelatedPermissionModel](docs/RelatedPermissionModel.md)
 - [RoleRequestModel](docs/RoleRequestModel.md)
 - [RoleResponseModel](docs/RoleResponseModel.md)
 - [SamlClaimModel](docs/SamlClaimModel.md)
 - [SamlProviderRequestModel](docs/SamlProviderRequestModel.md)
 - [SamlProviderResponseDetailModel](docs/SamlProviderResponseDetailModel.md)
 - [SamlProviderResponseModel](docs/SamlProviderResponseModel.md)
 - [SamlProviderRuleRequestModel](docs/SamlProviderRuleRequestModel.md)
 - [SamlProviderRuleResponseModel](docs/SamlProviderRuleResponseModel.md)
 - [TokenInfoResponse](docs/TokenInfoResponse.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [UpdateRequestAccountAttributeRequestModel](docs/UpdateRequestAccountAttributeRequestModel.md)
 - [UpdateRequestAccountGroupRequestModel](docs/UpdateRequestAccountGroupRequestModel.md)
 - [UpdateRequestClientRequestModel](docs/UpdateRequestClientRequestModel.md)
 - [UpdateRequestCustomThemeRequestModel](docs/UpdateRequestCustomThemeRequestModel.md)
 - [UpdateRequestGeneralAccountRequestModel](docs/UpdateRequestGeneralAccountRequestModel.md)
 - [UpdateRequestMavRequestModel](docs/UpdateRequestMavRequestModel.md)
 - [UpdateRequestPermissionSetRequestModel](docs/UpdateRequestPermissionSetRequestModel.md)
 - [UpdateRequestRoleRequestModel](docs/UpdateRequestRoleRequestModel.md)
 - [UpdateRequestSamlProviderRequestModel](docs/UpdateRequestSamlProviderRequestModel.md)
 - [UpdateRequestSamlProviderRuleRequestModel](docs/UpdateRequestSamlProviderRuleRequestModel.md)
 - [UpdateRequestUserRequestModel](docs/UpdateRequestUserRequestModel.md)
 - [UserRequestModel](docs/UserRequestModel.md)
 - [UserResponseModel](docs/UserResponseModel.md)
 - [UserSamlProviderRequestModel](docs/UserSamlProviderRequestModel.md)
 - [UserSamlProviderResponseModel](docs/UserSamlProviderResponseModel.md)


## Documentation For Authorization


## oauth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: https://auth-eu.cloudcheckr.com/auth/connect/authorize
- **Scopes**: 
 - **api**: CloudCheckr API


## Author

support@cloudcheckr.com

