scDenorm
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install scDenorm

#or

conda install -c changebio scdenorm
```

## How to use

### Using pbmc3k as an example dataset

``` python
import scanpy as sc
from scipy.io import mmwrite
from scDenorm.denorm import *
```

``` python
ad=sc.datasets.pbmc3k()
```

``` python
ad.layers['count']=ad.X.copy()
```

``` python
ad
```

    AnnData object with n_obs × n_vars = 2700 × 32738
        var: 'gene_ids'
        layers: 'count'

``` python
sc.pp.normalize_total(ad, target_sum=1e4)
sc.pp.log1p(ad)
smtx = ad.X.tocsr().asfptype()
```

``` python
smtx.data
```

    array([1.6352079, 1.6352079, 2.2258174, ..., 1.7980369, 1.7980369,
           2.779648 ], dtype=float32)

``` python
ad.write_h5ad('data/pbmc3k_norm.h5ad')
```

write out as sparse matrix

``` python
mmwrite('data/scaled.mtx', smtx[1:10,])
```

### In jupyter

#### Input Anndata

``` python
scdenorm('data/pbmc3k_norm.h5ad',fout='data/pbmc3k_denorm.h5ad',verbose=1)
```

    INFO:root:Reading input file: data/pbmc3k_norm.h5ad
    INFO:root:The dimensions of this data are (2700, 32738).
    INFO:root:select base
    INFO:root:denormlizing ...
    100%|██████████| 2700/2700 [00:00<00:00, 2900.90it/s]
    INFO:root:Writing output file: data/pbmc3k_denorm.h5ad

return a new anndata if there is no output path.

``` python
new_ad=scdenorm('data/pbmc3k_norm.h5ad')
```

    100%|██████████| 2700/2700 [00:00<00:00, 2969.22it/s]

``` python
new_ad
```

    View of AnnData object with n_obs × n_vars = 2700 × 32738
        var: 'gene_ids'
        uns: 'log1p'

``` python
ad.layers['count'].data
```

    array([1., 1., 2., ..., 1., 1., 3.], dtype=float32)

``` python
new_ad.X.data
```

    array([1.       , 1.       , 2.0000002, ..., 1.       , 1.       ,
           3.       ], dtype=float32)

#### Input sparse matrix with cell by gene

If it is gene by cell, set `gxc=True`.

``` python
scdenorm('data/scaled.mtx',fout='data/scd_scaled.h5ad')
```

    100%|██████████| 9/9 [00:00<00:00, 2883.12it/s]

### In command line

#### Input Anndata

``` python
!scdenorm data/pbmc3k_norm.h5ad --fout data/pbmc3k_denorm.h5ad
```

    100%|█████████████████████████████████████| 2700/2700 [00:00<00:00, 2719.59it/s]

#### Input sparse matrix with cell by gene

``` python
!scdenorm data/scaled.mtx --fout data/scd_scaled_c.h5ad
```

    100%|███████████████████████████████████████████| 9/9 [00:00<00:00, 1333.31it/s]

or output `mtx` format.

``` python
!scdenorm data/scaled.mtx --fout data/scd_scaled_c.mtx
```

    100%|███████████████████████████████████████████| 9/9 [00:00<00:00, 1290.78it/s]
