"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const logger_1 = require("@aws-lambda-powertools/logger");
const client_eventbridge_1 = require("@aws-sdk/client-eventbridge");
const REPOSITORY_TYPE = process.env.REPOSITORY_TYPE || '';
const EVENT_SOURCE_NAME = process.env.EVENT_SOURCE_NAME || '';
const logger = new logger_1.Logger();
const eventBridge = new client_eventbridge_1.EventBridgeClient({});
exports.handler = async (event) => {
    logger.info('Event', { event });
    const { 'project-name': projectName, 'build-id': buildArn } = event.detail;
    const buildId = buildArn.split('/')[1];
    const commitSha = event.detail['additional-information']['source-version'];
    const state = transformStateName(REPOSITORY_TYPE, event.detail['build-status']);
    if (!state) {
        logger.warn('Ignoring unsupported state change');
        return;
    }
    await eventBridge.send(new client_eventbridge_1.PutEventsCommand({
        Entries: [{
                Source: EVENT_SOURCE_NAME,
                DetailType: event['detail-type'],
                Detail: JSON.stringify({
                    'project-name': projectName,
                    'build-id': buildId,
                    'state': state,
                    'commit-sha': commitSha,
                }),
            }],
    }));
};
const transformStateName = (repositoryType, state) => {
    switch (repositoryType.toLowerCase()) {
        case 'github':
            return transformStateNameForGitHub(state);
        case 'bitbucket':
            return transformStateNameForBitbucket(state);
        default:
            return null;
    }
};
const transformStateNameForGitHub = (state) => {
    switch (state) {
        case 'IN_PROGRESS':
            return 'pending';
        case 'SUCCEEDED':
            return 'success';
        case 'FAILED':
            return 'failure';
        case 'STOPPED':
            return 'error';
        default:
            return null;
    }
};
const transformStateNameForBitbucket = (state) => {
    switch (state) {
        case 'IN_PROGRESS':
            return 'INPROGRESS';
        case 'SUCCEEDED':
            return 'SUCCESSFUL';
        case 'FAILED':
            return state;
        case 'STOPPED':
            return state;
        default:
            return null;
    }
};
//# sourceMappingURL=data:application/json;base64,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