import { Repository } from 'aws-cdk-lib/aws-codecommit';
import { ApiDestination } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
import { ResolvedApplicationProps } from '../applicationProps';
import { Topic } from 'aws-cdk-lib/aws-sns';
export interface MainPipelineProps extends Pick<ResolvedApplicationProps, 'stacks' | 'repository' | 'commands' | 'pipeline' | 'cdkOutputDirectory' | 'codeBuild' | 'codePipeline'> {
    codeCommitRepository: Repository;
    repositoryApiDestination: ApiDestination;
}
export declare class MainPipeline extends Construct {
    readonly failuresTopic: Topic;
    constructor(scope: Construct, id: string, props: MainPipelineProps);
    private isWave;
    private addWaveDeployment;
    private addEnvironmentDeployment;
    private createPipelineFailuresTopic;
    /**
     * To send CodePipeline build status back to repository:
     * - trigger Lambda function on CodePipeline state change events,
     * - in Lambda:
     *   - get CodePipeline execution details to get commit SHA,
     *   - send custom event to EventBridge including the commit SHA,
     * - use EventBridge to send build status to repository.
     */
    private createPipelineBuildNotifications;
    private createStatusEvent;
}
