# Generated by Django 3.0.11 on 2021-01-26 08:49

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='QRCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, default='', max_length=100, unique=True)),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('short_uuid', models.SlugField(blank=True, null=True, unique=True)),
                ('basic_info', models.TextField(blank=True, default='')),
                ('mode', models.CharField(choices=[('kiosk', 'Kiosk Mode'), ('redirect', 'Redirect Mode'), ('info_page', 'Information Page Mode')], default='redirect', help_text='\nSets the mode this code is in.<br/>\nKiosk Mode: Show buttons to choose a link from<br/>\nRedirect Mode: Instantly redirects to the url with the highest priority.<br/>\nInformation Page Mode: Show basic info with links to different urls\n', max_length=16)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='qrcodes', to='qrtoolkit_core.Department')),
            ],
        ),
        migrations.CreateModel(
            name='LinkUrl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', help_text='Name of the url. Used in buttons and links when a code is scanned.', max_length=64)),
                ('url', models.URLField(blank=True, default='', help_text='redirect to external page')),
                ('priority', models.FloatField(default=1)),
                ('code', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='urls', to='qrtoolkit_core.QRCode')),
            ],
            options={
                'ordering': ['-priority'],
            },
        ),
        migrations.CreateModel(
            name='ApiHit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hit_date', models.DateTimeField(auto_now_add=True)),
                ('action', models.CharField(choices=[('basic_info', 'Basic Info'), ('kiosk', 'Kiosk'), ('json', 'Json Response'), ('redirect', 'Redirect'), ('error', 'Error')], default='basic_info', max_length=16)),
                ('message', models.CharField(blank=True, help_text='Extra information about errors or other extra info', max_length=255, null=True)),
                ('code', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='hits', to='qrtoolkit_core.QRCode')),
            ],
            options={
                'ordering': ['-hit_date'],
            },
        ),
    ]
