/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import log.ArtifactManager;
import log.ArtifactManagerFactory;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.CommandLineExecutorKt;
import utils.Killer;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u001a\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a]\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0018\u001a<\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001a\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"logger", "Llog/Logger;", "catchInterrupt", "", "f", "Lkotlin/Function0;", "cleanUpProcess", "p", "Ljava/lang/Process;", "noInterrupt", "safeCommandArrayExecLines", "Lkotlin/Pair;", "", "", "", "cmd", "", "outputName", "readStandardOutput", "", "checkExitCode", "timeoutSecs", "", "input", "([Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/Long;Ljava/lang/String;)Lkotlin/Pair;", "safeCommandExec", "outName", "Shared"})
public final class CommandLineExecutorKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.COMMON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Pair<Integer, List<String>> safeCommandArrayExecLines(@NotNull String[] cmd, @NotNull String outputName, boolean readStandardOutput, boolean checkExitCode, @Nullable Long timeoutSecs, @Nullable String input) {
        List<Object> list;
        Object object;
        Object $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222;
        File e2;
        File file2;
        Intrinsics.checkNotNullParameter(cmd, "cmd");
        Intrinsics.checkNotNullParameter(outputName, "outputName");
        boolean redirectStdoutStderr = readStandardOutput && ArtifactManagerFactory.INSTANCE.isEnabled();
        try {
            file2 = redirectStdoutStderr ? new File(ArtifactManager.Companion.getCmdErrorFilepath(outputName)) : null;
        }
        catch (IllegalStateException e2) {
            file2 = null;
        }
        File fileError = file2;
        try {
            e2 = redirectStdoutStderr ? new File(ArtifactManager.Companion.getCmdOutputFilepath(outputName)) : null;
        }
        catch (IllegalStateException e3) {
            e2 = null;
        }
        File fileOutput = e2;
        boolean hasRedirects = fileError != null && fileOutput != null;
        String stringCommand = ArraysKt.joinToString$default(cmd, (CharSequence)" ", null, null, 0, null, null, 62, null);
        if (!(!redirectStdoutStderr || hasRedirects)) {
            boolean $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = false;
            String $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = "If asked to redirect from stdout/stderr, must have path for output file";
            throw new IllegalStateException($i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222.toString());
        }
        if (hasRedirects && redirectStdoutStderr) {
            Object writer2;
            File file3 = fileError;
            Intrinsics.checkNotNull(file3);
            Closeable closeable = new PrintWriter(file3);
            $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = null;
            try {
                writer2 = (PrintWriter)closeable;
                boolean bl = false;
                ((PrintWriter)writer2).println("stderr: " + stringCommand);
                writer2 = Unit.INSTANCE;
            }
            catch (Throwable writer2) {
                $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = writer2;
                throw writer2;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)$i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222);
            }
            File file4 = fileOutput;
            Intrinsics.checkNotNull(file4);
            closeable = new PrintWriter(file4);
            $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = null;
            try {
                writer2 = (PrintWriter)closeable;
                boolean bl = false;
                ((PrintWriter)writer2).println("stdout: " + stringCommand);
                writer2 = Unit.INSTANCE;
            }
            catch (Throwable writer3) {
                $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = writer3;
                throw writer3;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)$i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222);
            }
        }
        logger.info((Function0<? extends Object>)new Function0<Object>(stringCommand){
            final /* synthetic */ String $stringCommand;
            {
                this.$stringCommand = $stringCommand;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Thread " + Thread.currentThread().getId() + ": Going to start " + this.$stringCommand;
            }
        });
        Object it = new ProcessBuilder(new String[0]).command(Arrays.copyOf(cmd, cmd.length));
        boolean bl = false;
        Process p = ((ProcessBuilder)(redirectStdoutStderr ? ((ProcessBuilder)it).redirectError(ProcessBuilder.Redirect.appendTo(fileError)).redirectOutput(ProcessBuilder.Redirect.appendTo(fileOutput)) : it)).start();
        if (input != null) {
            $i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222 = p.getOutputStream();
            it = null;
            try {
                Object out22 = (OutputStream)$i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222;
                boolean bl2 = false;
                object = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue(object, "defaultCharset()");
                byte[] byArray = input.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                ((OutputStream)out22).write(byArray);
                out22 = Unit.INSTANCE;
            }
            catch (Throwable out22) {
                it = out22;
                throw out22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-check-CommandLineExecutorKt$safeCommandArrayExecLines$222, (Throwable)it);
            }
        }
        Thread.sleep(100L);
        it = p.getInputStream();
        Intrinsics.checkNotNullExpressionValue(it, "p.inputStream");
        Charset out22 = Charsets.UTF_8;
        it = new InputStreamReader((InputStream)it, out22);
        int out22 = 8192;
        BufferedReader bufferedOutputReader = it instanceof BufferedReader ? (BufferedReader)it : new BufferedReader((Reader)it, out22);
        int exitValue = 0;
        try {
            if (timeoutSecs != null) {
                p.waitFor(timeoutSecs, TimeUnit.SECONDS);
            } else {
                p.waitFor();
            }
        }
        catch (InterruptedException e4) {
            p.destroyForcibly();
        }
        finally {
            Intrinsics.checkNotNullExpressionValue(p, "p");
            CommandLineExecutorKt.cleanUpProcess(p);
            exitValue = p.exitValue();
        }
        if (checkExitCode && exitValue != 0) {
            String string2;
            String string3;
            String string4;
            File file5 = fileError;
            if (file5 == null) {
                string4 = "?";
            } else {
                String string5 = file5.getPath();
                if (string5 == null) {
                    string4 = "?";
                } else {
                    String path2 = string5;
                    boolean bl3 = false;
                    String string6 = TextStreamsKt.readText(new FileReader(path2));
                    string4 = string6;
                    if (string6 == null) {
                        string4 = "?";
                    }
                }
            }
            String errors2 = string4;
            File file6 = fileError;
            if (file6 == null) {
                string3 = "N/A";
            } else {
                string3 = file6.getPath();
                if (string3 == null) {
                    string3 = "N/A";
                }
            }
            File file7 = fileOutput;
            if (file7 == null) {
                string2 = "N/A";
            } else {
                string2 = file7.getPath();
                if (string2 == null) {
                    string2 = "N/A";
                }
            }
            throw new Exception("Failed to run command (" + stringCommand + "), exited with code " + exitValue + ", see errors: " + string3 + ", output: " + string2 + ". Details: " + errors2);
        }
        if (redirectStdoutStderr) {
            File file8 = fileOutput;
            Intrinsics.checkNotNull(file8);
            Closeable closeable = new FileReader(file8);
            object = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl4 = false;
                List<String> list2 = TextStreamsKt.readLines(reader);
                list = list2;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object);
            }
        } else {
            list = readStandardOutput ? TextStreamsKt.readLines(bufferedOutputReader) : CollectionsKt.emptyList();
        }
        List lineList = list;
        return new Pair<Integer, List<String>>(exitValue, lineList);
    }

    public static /* synthetic */ Pair safeCommandArrayExecLines$default(String[] stringArray, String string2, boolean bl, boolean bl2, Long l, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return CommandLineExecutorKt.safeCommandArrayExecLines(stringArray, string2, bl, bl2, l, string3);
    }

    private static final void noInterrupt(Function0<Unit> f) {
        boolean again = false;
        do {
            try {
                f.invoke();
                again = false;
            }
            catch (InterruptedException e) {
                again = true;
                StackTraceElement loc = e.getStackTrace()[1];
                logger.warn((Function0<? extends Object>)new Function0<Object>(loc){
                    final /* synthetic */ StackTraceElement $loc;
                    {
                        this.$loc = $loc;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Thread " + Thread.currentThread().getId() + ": Got Interrupted exception during noInterrupt at " + this.$loc.getMethodName() + " in " + this.$loc.getFileName() + ":" + this.$loc.getLineNumber();
                    }
                });
            }
        } while (again);
    }

    private static final void catchInterrupt(Function0<Unit> f) {
        try {
            f.invoke();
        }
        catch (InterruptedException e) {
            StackTraceElement loc = e.getStackTrace()[1];
            logger.warn((Function0<? extends Object>)new Function0<Object>(loc){
                final /* synthetic */ StackTraceElement $loc;
                {
                    this.$loc = $loc;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Thread " + Thread.currentThread().getId() + ": Got Interrupted exception during catchInterrupt at " + this.$loc.getMethodName() + " in " + this.$loc.getFileName() + ":" + this.$loc.getLineNumber();
                }
            });
        }
    }

    private static final void cleanUpProcess(Process p) {
        try {
            if (!p.isAlive()) {
                logger.info((Function0<? extends Object>)new Function0<Object>(p){
                    final /* synthetic */ Process $p;
                    {
                        this.$p = $p;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Thread " + Thread.currentThread().getId() + ": Process " + this.$p.pid() + " was dead before cleanup";
                    }
                });
                CommandLineExecutorKt.noInterrupt(new Function0<Unit>(p){
                    final /* synthetic */ Process $p;
                    {
                        this.$p = $p;
                        super(0);
                    }

                    public final void invoke() {
                        this.$p.waitFor();
                    }
                });
                return;
            }
            ProcessHandle processHandle = p.toHandle();
            Intrinsics.checkNotNullExpressionValue(processHandle, "p.toHandle()");
            Killer killer = new Killer(processHandle);
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(killer){
                final /* synthetic */ Killer $killer;
                {
                    this.$killer = $killer;
                    super(0);
                }

                public final void invoke() {
                    this.$killer.destroyChilds();
                }
            });
            CommandLineExecutorKt.catchInterrupt(cleanUpProcess.4.INSTANCE);
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(killer){
                final /* synthetic */ Killer $killer;
                {
                    this.$killer = $killer;
                    super(0);
                }

                public final void invoke() {
                    this.$killer.destroyChildsForcibly();
                }
            });
            CommandLineExecutorKt.catchInterrupt(cleanUpProcess.6.INSTANCE);
            if (p.isAlive()) {
                logger.info((Function0<? extends Object>)new Function0<Object>(p){
                    final /* synthetic */ Process $p;
                    {
                        this.$p = $p;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Why does " + this.$p.pid() + " does not want to die?";
                    }
                });
            }
            CommandLineExecutorKt.noInterrupt(new Function0<Unit>(p){
                final /* synthetic */ Process $p;
                {
                    this.$p = $p;
                    super(0);
                }

                public final void invoke() {
                    this.$p.waitFor();
                }
            });
        }
        catch (Exception e) {
            logger.warn(e, cleanUpProcess.9.INSTANCE);
        }
    }

    @NotNull
    public static final Pair<Integer, String> safeCommandExec(@NotNull List<String> cmd, @NotNull String outName, boolean readStandardOutput, boolean checkExitCode) {
        Intrinsics.checkNotNullParameter(cmd, "cmd");
        Intrinsics.checkNotNullParameter(outName, "outName");
        Collection $this$toTypedArray$iv = cmd;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull(stringArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Pair res2 = CommandLineExecutorKt.safeCommandArrayExecLines$default(stringArray, outName, readStandardOutput, checkExitCode, null, null, 32, null);
        List lineList = (List)res2.getSecond();
        StringBuffer sb = new StringBuffer();
        Iterable $this$forEach$iv = lineList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String l = (String)element$iv;
            boolean bl = false;
            Appendable appendable = ((Appendable)sb).append(l);
            Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
            Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
        }
        Object a = res2.getFirst();
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return new Pair<Integer, String>((Integer)a, string2);
    }

    public static /* synthetic */ Pair safeCommandExec$default(List list, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return CommandLineExecutorKt.safeCommandExec(list, string2, bl, bl2);
    }
}

