/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import algorithms.TopologicalOrderException;
import algorithms.TopologicalSortKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.StandardCVLErrorLogger;
import spec.cvlast.CVLAstTransformer;
import spec.cvlast.CVLCmdTransformer;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpModifiesReads;
import spec.cvlast.CVLExpTransformer;
import spec.cvlast.CVLGhostFunction;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSymbolTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lspec/cvlast/DefinitionDependencyChecker;", "Lspec/cvlast/CVLAstTransformer;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "(Lspec/cvlast/CVLSymbolTable;)V", "getSymbolTable", "()Lspec/cvlast/CVLSymbolTable;", "defs", "", "Lspec/cvlast/CVLDefinition;", "Shared"})
public final class DefinitionDependencyChecker
extends CVLAstTransformer {
    @NotNull
    private final CVLSymbolTable symbolTable;

    public DefinitionDependencyChecker(@NotNull CVLSymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        super(new CVLCmdTransformer(new CVLExpTransformer()));
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final CVLSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CVLDefinition> defs(@NotNull List<CVLDefinition> defs2) {
        List list;
        Intrinsics.checkNotNullParameter(defs2, "defs");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Object element$iv2;
            Map definitionDependencies = new LinkedHashMap();
            Map astDefinitionVersion = new LinkedHashMap();
            Iterable $this$forEach$iv = defs2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                CVLDefinition definition2 = (CVLDefinition)element$iv2;
                boolean bl = false;
                CVLSymbolTable cVLSymbolTable = this.getSymbolTable();
                String string2 = definition2.getId();
                CVLScope cVLScope = definition2.getScope();
                Intrinsics.checkNotNull(cVLScope);
                CVLSymbolTable.SymbolInfo symbolInfo = cVLSymbolTable.lookUpFunctionLikeSymbol(string2, cVLScope);
                Object object2 = symbolInfo == null ? null : symbolInfo.getHook();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type spec.cvlast.CVLDefinition");
                }
                CVLDefinition defInSymbolTable = (CVLDefinition)object2;
                Set deps = new LinkedHashSet();
                CVLExpTransformer transformer2 = new CVLExpTransformer(this, definition2, deps){
                    final /* synthetic */ DefinitionDependencyChecker this$0;
                    final /* synthetic */ CVLDefinition $definition;
                    final /* synthetic */ Set<CVLDefinition> $deps;
                    {
                        this.this$0 = $receiver;
                        this.$definition = $definition;
                        this.$deps = $deps;
                    }

                    @NotNull
                    public CVLExp definition(@NotNull CVLExp.ApplyExp.Definition exp) {
                        CVLSymbolTable.SymbolInfo definitionInfo;
                        Intrinsics.checkNotNullParameter(exp, "exp");
                        CVLSymbolTable.SymbolInfo symbolInfo = definitionInfo = this.this$0.getSymbolTable().lookUpWithMethodIdWithCallContext(exp.getMethodIdWithCallContext(), this.$definition.getScope());
                        Object dep = symbolInfo == null ? null : symbolInfo.getHook();
                        if (!(dep != null && dep instanceof CVLDefinition)) {
                            String string2 = "Check failed.";
                            throw new IllegalStateException(string2.toString());
                        }
                        this.$deps.add((CVLDefinition)dep);
                        return exp;
                    }
                };
                transformer2.expr(definition2.getBody());
                Map map2 = definitionDependencies;
                object = CollectionsKt.toSet(deps);
                map2.put(defInSymbolTable, object);
                astDefinitionVersion.put(defInSymbolTable, definition2);
            }
            List definitionTopoSort = CollectionsKt.reversed(TopologicalSortKt.topologicalOrder$default(definitionDependencies, false, 2, null));
            Map modifiesMap = new LinkedHashMap();
            Map readsMap = new LinkedHashMap();
            element$iv2 = CollectionsKt.reversed(definitionTopoSort);
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$fold$iv;
                void defInSymbolTable;
                object = (CVLDefinition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object v = astDefinitionVersion.get(defInSymbolTable);
                Intrinsics.checkNotNull(v);
                CVLDefinition definition3 = (CVLDefinition)v;
                CVLSymbolTable cVLSymbolTable = this.getSymbolTable();
                CVLLocation cVLLocation = definition3.getLoc();
                CVLScope cVLScope = definition3.getScope();
                Intrinsics.checkNotNull(cVLScope);
                Pair<Set<CVLGhostFunction>, Set<CVLGhostFunction>> pair2 = CVLExpModifiesReads.Companion.getModifiedAndRead(cVLSymbolTable, cVLLocation, cVLScope, definition3.getBody());
                Set<CVLGhostFunction> modified = pair2.component1();
                Set<CVLGhostFunction> read = pair2.component2();
                Object v2 = definitionDependencies.get(defInSymbolTable);
                Intrinsics.checkNotNull(v2);
                Iterable iterable = (Iterable)v2;
                Pair initial$iv = TuplesKt.to(SetsKt.emptySet(), SetsKt.emptySet());
                boolean $i$f$fold = false;
                Pair accumulator$iv = initial$iv;
                for (Object element$iv3 : $this$fold$iv) {
                    void el;
                    CVLDefinition cVLDefinition = (CVLDefinition)element$iv3;
                    Pair $dstr$modifiedAcc$readAcc = accumulator$iv;
                    boolean bl3 = false;
                    Set modifiedAcc = $dstr$modifiedAcc$readAcc.component1();
                    Set readAcc = $dstr$modifiedAcc$readAcc.component2();
                    CVLSymbolTable cVLSymbolTable2 = this.getSymbolTable();
                    String string3 = el.getId();
                    CVLScope cVLScope2 = el.getScope();
                    Intrinsics.checkNotNull(cVLScope2);
                    CVLSymbolTable.SymbolInfo symbolInfo = cVLSymbolTable2.lookUpFunctionLikeSymbol(string3, cVLScope2);
                    Object object3 = symbolInfo == null ? null : symbolInfo.getHook();
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type spec.cvlast.CVLDefinition");
                    }
                    CVLDefinition dep = (CVLDefinition)object3;
                    Object v3 = modifiesMap.get(dep);
                    Intrinsics.checkNotNull(v3);
                    Set set = SetsKt.plus(modifiedAcc, (Iterable)v3);
                    Object v4 = readsMap.get(dep);
                    Intrinsics.checkNotNull(v4);
                    accumulator$iv = TuplesKt.to(set, SetsKt.plus(readAcc, (Iterable)v4));
                }
                Pair pair3 = accumulator$iv;
                Set depsModified = pair3.component1();
                Set depsRead = pair3.component2();
                definition3.setModifies(SetsKt.plus(modified, depsModified));
                definition3.setReads(SetsKt.plus(read, depsRead));
                Map map3 = modifiesMap;
                Set<CVLGhostFunction> set = definition3.getModifies();
                map3.put(defInSymbolTable, set);
                map3 = readsMap;
                set = definition3.getReads();
                map3.put(defInSymbolTable, set);
                collection.add(definition3);
            }
            list = (List)destination$iv$iv;
        }
        catch (TopologicalOrderException e) {
            StandardCVLErrorLogger.INSTANCE.error("A circular dependency was found in a definition: this is not allowed. Topo sort error: " + e.getMsg(), new CVLLocation.Empty(null, 1, null));
            list = defs2;
        }
        List definitions2 = list;
        return definitions2;
    }
}

