/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args = new LinkedList<String>();
    private final List<Option> options = new ArrayList<Option>();

    protected CommandLine() {
    }

    protected void addArg(String arg) {
        this.args.add(arg);
    }

    protected void addOption(Option opt) {
        this.options.add(opt);
    }

    public List<String> getArgList() {
        return this.args;
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    @Deprecated
    public Object getOptionObject(char opt) {
        return this.getOptionObject(String.valueOf(opt));
    }

    @Deprecated
    public Object getOptionObject(String opt) {
        try {
            return this.getParsedOptionValue(opt);
        }
        catch (ParseException pe) {
            System.err.println("Exception found converting " + opt + " to desired type: " + pe.getMessage());
            return null;
        }
    }

    public Properties getOptionProperties(Option option2) {
        Properties props2 = new Properties();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option2)) continue;
            List<String> values2 = processedOption.getValuesList();
            if (values2.size() >= 2) {
                props2.put(values2.get(0), values2.get(1));
                continue;
            }
            if (values2.size() != 1) continue;
            props2.put(values2.get(0), "true");
        }
        return props2;
    }

    public Properties getOptionProperties(String opt) {
        Properties props2 = new Properties();
        for (Option option2 : this.options) {
            if (!opt.equals(option2.getOpt()) && !opt.equals(option2.getLongOpt())) continue;
            List<String> values2 = option2.getValuesList();
            if (values2.size() >= 2) {
                props2.put(values2.get(0), values2.get(1));
                continue;
            }
            if (values2.size() != 1) continue;
            props2.put(values2.get(0), "true");
        }
        return props2;
    }

    public Option[] getOptions() {
        List<Option> processed = this.options;
        Option[] optionsArray = new Option[processed.size()];
        return processed.toArray(optionsArray);
    }

    public String getOptionValue(char opt) {
        return this.getOptionValue(String.valueOf(opt));
    }

    public String getOptionValue(char opt, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt), defaultValue);
    }

    public String getOptionValue(Option option2) {
        if (option2 == null) {
            return null;
        }
        String[] values2 = this.getOptionValues(option2);
        return values2 == null ? null : values2[0];
    }

    public String getOptionValue(Option option2, String defaultValue) {
        String answer = this.getOptionValue(option2);
        return answer != null ? answer : defaultValue;
    }

    public String getOptionValue(String opt) {
        return this.getOptionValue(this.resolveOption(opt));
    }

    public String getOptionValue(String opt, String defaultValue) {
        return this.getOptionValue(this.resolveOption(opt), defaultValue);
    }

    public String[] getOptionValues(char opt) {
        return this.getOptionValues(String.valueOf(opt));
    }

    public String[] getOptionValues(Option option2) {
        ArrayList<String> values2 = new ArrayList<String>();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option2)) continue;
            values2.addAll(processedOption.getValuesList());
        }
        return values2.isEmpty() ? null : values2.toArray(new String[values2.size()]);
    }

    public String[] getOptionValues(String opt) {
        return this.getOptionValues(this.resolveOption(opt));
    }

    public Object getParsedOptionValue(char opt) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(opt));
    }

    public Object getParsedOptionValue(Option option2) throws ParseException {
        if (option2 == null) {
            return null;
        }
        String res2 = this.getOptionValue(option2);
        if (res2 == null) {
            return null;
        }
        return TypeHandler.createValue(res2, option2.getType());
    }

    public Object getParsedOptionValue(String opt) throws ParseException {
        return this.getParsedOptionValue(this.resolveOption(opt));
    }

    public boolean hasOption(char opt) {
        return this.hasOption(String.valueOf(opt));
    }

    public boolean hasOption(Option opt) {
        return this.options.contains(opt);
    }

    public boolean hasOption(String opt) {
        return this.hasOption(this.resolveOption(opt));
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    private Option resolveOption(String opt) {
        opt = Util.stripLeadingHyphens(opt);
        for (Option option2 : this.options) {
            if (!opt.equals(option2.getOpt()) && !opt.equals(option2.getLongOpt())) continue;
            return option2;
        }
        return null;
    }

    public static final class Builder {
        private final CommandLine commandLine = new CommandLine();

        public Builder addArg(String arg) {
            this.commandLine.addArg(arg);
            return this;
        }

        public Builder addOption(Option opt) {
            this.commandLine.addOption(opt);
            return this;
        }

        public CommandLine build() {
            return this.commandLine;
        }
    }
}

