/*
 * Decompiled with CFR 0.152.
 */
package com.github.kittinunf.fuel.core.requests;

import com.github.kittinunf.fuel.core.Body;
import com.github.kittinunf.fuel.core.Deserializable;
import com.github.kittinunf.fuel.core.DeserializableKt;
import com.github.kittinunf.fuel.core.FuelError;
import com.github.kittinunf.fuel.core.Handler;
import com.github.kittinunf.fuel.core.Headers;
import com.github.kittinunf.fuel.core.Method;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.RequestExecutionOptions;
import com.github.kittinunf.fuel.core.Response;
import com.github.kittinunf.fuel.core.ResponseDeserializable;
import com.github.kittinunf.fuel.core.ResponseHandler;
import com.github.kittinunf.fuel.core.deserializers.ByteArrayDeserializer;
import com.github.kittinunf.fuel.core.deserializers.StringDeserializer;
import com.github.kittinunf.fuel.core.requests.CancellableRequest;
import com.github.kittinunf.fuel.core.requests.DefaultBody;
import com.github.kittinunf.result.Result;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012 \b\u0002\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u0012\u0012\u001c\b\u0002\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u00104\u001a\u00020\u00012\u0006\u00104\u001a\u000205H\u0016J9\u00106\u001a\u00020\u00012*\u00107\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n08\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a2\u0006\u0002\u00109J\u0018\u00106\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\fH\u0016J)\u00106\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f08\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010=J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J@\u0010\u001b\u001a\u00020\u00012\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020@0?j\u0002`A2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020C\u0018\u00010?j\u0004\u0018\u0001`D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000205H\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010H\u001a\u00020I2\u0006\u0010E\u001a\u00020FH\u0016J6\u0010\u001b\u001a\u00020\u00012\u0006\u0010J\u001a\u00020@2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020C\u0018\u00010?j\u0004\u0018\u0001`D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000205H\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020FH\u0016J\t\u0010M\u001a\u00020\u0003H\u00c6\u0003J\t\u0010N\u001a\u00020\u0005H\u00c6\u0003J\t\u0010O\u001a\u00020\u0007H\u00c6\u0003J!\u0010P\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\rH\u00c6\u0003J\u000e\u0010Q\u001a\u00020\u000fH\u00c0\u0003\u00a2\u0006\u0002\bRJ\u0019\u0010S\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u0012H\u00c6\u0003J\u001d\u0010T\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015H\u00c2\u0003J\u008b\u0001\u0010U\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072 \b\u0002\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u00122\u001c\b\u0002\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015H\u00c6\u0001J\u0013\u0010V\u001a\u0002052\b\u0010W\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u001b\u0010X\u001a\f\u0012\u0004\u0012\u00020\u000b0Yj\u0002`Z2\u0006\u0010:\u001a\u00020\u000bH\u0096\u0002J'\u0010[\u001a\u0004\u0018\u0001H\\\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010]\u001a\b\u0012\u0004\u0012\u0002H\\0\u0014H\u0016\u00a2\u0006\u0002\u0010^J\t\u0010_\u001a\u00020`H\u00d6\u0001J9\u0010:\u001a\u00020\u00012*\u00107\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n08\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016\u00a2\u0006\u0002\u00109J\u001a\u0010:\u001a\f\u0012\u0004\u0012\u00020\u000b0Yj\u0002`Z2\u0006\u0010:\u001a\u00020\u000bH\u0016J\u0018\u0010:\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\fH\u0016J)\u0010:\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f08\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010=J\u001c\u0010:\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030YH\u0016J\u001c\u0010:\u001a\u00020\u00012\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0bH\u0016J \u0010c\u001a\u00020\u00012\u0016\u0010c\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020e0dj\u0002`fH\u0016JD\u0010g\u001a\u00020\u00012:\u0010h\u001a6\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(l\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(m\u0012\u0004\u0012\u00020e0ij\u0002`nH\u0016J0\u0010o\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u00020L`tH\u0016J\u0016\u0010o\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020L0vH\u0016J\u0016\u0010o\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020L0wH\u0016J>\u0010o\u001a\u00020u24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u00020L`yH\u0016J2\u0010o\u001a\u00020u2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u00020L`zH\u0016JH\u0010{\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u0002H\\`t\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}H\u0016J.\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}2\f\u0010h\u001a\b\u0012\u0004\u0012\u0002H\\0vH\u0016J.\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}2\f\u0010h\u001a\b\u0012\u0004\u0012\u0002H\\0wH\u0016JV\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u0002H\\`yH\u0016JJ\u0010{\u001a\u00020u\"\b\b\u0000\u0010\\*\u00020\f2\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H\\0}2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\\\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u0002H\\`zH\u0016JD\u0010~\u001a\u00020\u00012:\u0010h\u001a6\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(l\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bj\u0012\b\bk\u0012\u0004\b\b(m\u0012\u0004\u0012\u00020e0ij\u0002`nH\u0016J0\u0010\u007f\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u00020\u000b`tH\u0016J\u0016\u0010\u007f\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0vH\u0016J\u0016\u0010\u007f\u001a\u00020u2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0wH\u0016J>\u0010\u007f\u001a\u00020u24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u00020\u000b`yH\u0016J2\u0010\u007f\u001a\u00020u2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u00020\u000b`zH\u0016J8\u0010\u007f\u001a*\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r0pj\b\u0012\u0004\u0012\u00020\u000b`t2\u0006\u0010E\u001a\u00020FH\u0016J\u001e\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0vH\u0016J\u001e\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u000b0wH\u0016JF\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F24\u0010h\u001a0\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020q\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0xj\b\u0012\u0004\u0012\u00020\u000b`yH\u0016J:\u0010\u007f\u001a\u00020u2\u0006\u0010E\u001a\u00020F2(\u0010h\u001a$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020s0r\u0012\u0004\u0012\u00020e0dj\b\u0012\u0004\u0012\u00020\u000b`zH\u0016J\u001a\u0010\u0080\u0001\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\fH\u0096\u0002J\u001e\u0010\u0080\u0001\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u000b2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030YH\u0096\u0002J\u0012\u0010\u0081\u0001\u001a\u00020\u00012\u0007\u0010\u0082\u0001\u001a\u00020\fH\u0016J\u0012\u0010\u0083\u0001\u001a\u00020\u00012\u0007\u0010\u0083\u0001\u001a\u00020`H\u0016J\u0012\u0010\u0084\u0001\u001a\u00020\u00012\u0007\u0010\u0083\u0001\u001a\u00020`H\u0016J\t\u0010\u0085\u0001\u001a\u00020\u000bH\u0016J\u0012\u0010\u0086\u0001\u001a\u00020\u00012\u0007\u0010\u0086\u0001\u001a\u000205H\u0016J#\u0010\u0087\u0001\u001a\u00020\u00012\u0018\u0010\u0088\u0001\u001a\u0013\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u0002050dj\u0003`\u0089\u0001H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R$\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0011j\u0002`\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R2\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\tj\u0002`\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\"\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006\u008a\u0001"}, d2={"Lcom/github/kittinunf/fuel/core/requests/DefaultRequest;", "Lcom/github/kittinunf/fuel/core/Request;", "method", "Lcom/github/kittinunf/fuel/core/Method;", "url", "Ljava/net/URL;", "headers", "Lcom/github/kittinunf/fuel/core/Headers;", "parameters", "", "Lkotlin/Pair;", "", "", "Lcom/github/kittinunf/fuel/core/Parameters;", "_body", "Lcom/github/kittinunf/fuel/core/Body;", "enabledFeatures", "", "Lcom/github/kittinunf/fuel/core/RequestFeatures;", "tags", "Lkotlin/reflect/KClass;", "Lcom/github/kittinunf/fuel/core/Tags;", "(Lcom/github/kittinunf/fuel/core/Method;Ljava/net/URL;Lcom/github/kittinunf/fuel/core/Headers;Ljava/util/List;Lcom/github/kittinunf/fuel/core/Body;Ljava/util/Map;Ljava/util/Map;)V", "get_body$fuel", "()Lcom/github/kittinunf/fuel/core/Body;", "set_body$fuel", "(Lcom/github/kittinunf/fuel/core/Body;)V", "body", "getBody", "getEnabledFeatures", "()Ljava/util/Map;", "executionOptions", "Lcom/github/kittinunf/fuel/core/RequestExecutionOptions;", "getExecutionOptions", "()Lcom/github/kittinunf/fuel/core/RequestExecutionOptions;", "setExecutionOptions", "(Lcom/github/kittinunf/fuel/core/RequestExecutionOptions;)V", "getHeaders", "()Lcom/github/kittinunf/fuel/core/Headers;", "getMethod", "()Lcom/github/kittinunf/fuel/core/Method;", "getParameters", "()Ljava/util/List;", "setParameters", "(Ljava/util/List;)V", "request", "getRequest", "()Lcom/github/kittinunf/fuel/core/Request;", "getUrl", "()Ljava/net/URL;", "setUrl", "(Ljava/net/URL;)V", "allowRedirects", "", "appendHeader", "pairs", "", "([Lkotlin/Pair;)Lcom/github/kittinunf/fuel/core/Request;", "header", "value", "values", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/github/kittinunf/fuel/core/Request;", "openStream", "Lkotlin/Function0;", "Ljava/io/InputStream;", "Lcom/github/kittinunf/fuel/core/BodySource;", "calculateLength", "", "Lcom/github/kittinunf/fuel/core/BodyLength;", "charset", "Ljava/nio/charset/Charset;", "repeatable", "file", "Ljava/io/File;", "stream", "bytes", "", "component1", "component2", "component3", "component4", "component5", "component5$fuel", "component6", "component7", "copy", "equals", "other", "get", "", "Lcom/github/kittinunf/fuel/core/HeaderValues;", "getTag", "T", "clazz", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "hashCode", "", "map", "", "interrupt", "Lkotlin/Function1;", "", "Lcom/github/kittinunf/fuel/core/InterruptCallback;", "requestProgress", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "readBytes", "totalBytes", "Lcom/github/kittinunf/fuel/core/ProgressCallback;", "response", "Lkotlin/Triple;", "Lcom/github/kittinunf/fuel/core/Response;", "Lcom/github/kittinunf/result/Result;", "Lcom/github/kittinunf/fuel/core/FuelError;", "Lcom/github/kittinunf/fuel/core/ResponseResultOf;", "Lcom/github/kittinunf/fuel/core/requests/CancellableRequest;", "Lcom/github/kittinunf/fuel/core/Handler;", "Lcom/github/kittinunf/fuel/core/ResponseHandler;", "Lkotlin/Function3;", "Lcom/github/kittinunf/fuel/core/ResponseResultHandler;", "Lcom/github/kittinunf/fuel/core/ResultHandler;", "responseObject", "deserializer", "Lcom/github/kittinunf/fuel/core/ResponseDeserializable;", "responseProgress", "responseString", "set", "tag", "t", "timeout", "timeoutRead", "toString", "useHttpCache", "validate", "validator", "Lcom/github/kittinunf/fuel/core/ResponseValidator;", "fuel"})
public final class DefaultRequest
implements Request {
    @NotNull
    public RequestExecutionOptions executionOptions;
    @NotNull
    private final Method method;
    @NotNull
    private URL url;
    @NotNull
    private final Headers headers;
    @NotNull
    private List<? extends Pair<String, ? extends Object>> parameters;
    @NotNull
    private Body _body;
    @NotNull
    private final Map<String, Request> enabledFeatures;
    private final Map<KClass<?>, Object> tags;

    @Override
    @NotNull
    public RequestExecutionOptions getExecutionOptions() {
        RequestExecutionOptions requestExecutionOptions = this.executionOptions;
        if (requestExecutionOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException("executionOptions");
        }
        return requestExecutionOptions;
    }

    @Override
    public void setExecutionOptions(@NotNull RequestExecutionOptions requestExecutionOptions) {
        Intrinsics.checkNotNullParameter(requestExecutionOptions, "<set-?>");
        this.executionOptions = requestExecutionOptions;
    }

    @Override
    @NotNull
    public Body getBody() {
        return this._body;
    }

    @Override
    @NotNull
    public Collection<String> get(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        return (Collection)this.getHeaders().get((Object)header);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Request set(@NotNull String header, @NotNull Collection<?> values2) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(values2, "values");
        Iterable iterable = values2;
        String string2 = header;
        Headers headers = this.getHeaders();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = String.valueOf(it);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        headers.set(string2, collection);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request set(@NotNull String header, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(value2, "value");
        Object object = value2;
        if (object instanceof Collection) {
            this.set(header, (Collection)value2);
        } else {
            this.getHeaders().set(header, value2.toString());
        }
        return this.getRequest();
    }

    @Override
    @NotNull
    public Collection<String> header(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        return this.get(header);
    }

    @Override
    @NotNull
    public Request header(@NotNull Map<String, ? extends Object> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        this.getHeaders().putAll(Headers.Companion.from(map2));
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request header(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        this.getHeaders().putAll(Headers.Companion.from(Arrays.copyOf(pairs, pairs.length)));
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request header(@NotNull String header, @NotNull Collection<?> values2) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(values2, "values");
        return this.set(header, values2);
    }

    @Override
    @NotNull
    public Request header(@NotNull String header, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(value2, "value");
        return this.set(header, value2);
    }

    @Override
    @NotNull
    public Request header(@NotNull String header, Object ... values2) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(values2, "values");
        return this.set(header, (Collection)ArraysKt.toList(values2));
    }

    @Override
    @NotNull
    public Request appendHeader(@NotNull String header, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.getHeaders().append(header, value2);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request appendHeader(@NotNull String header, Object ... values2) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(values2, "values");
        this.getHeaders().append(header, (Collection)ArraysKt.toList(values2));
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request appendHeader(Pair<String, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        Pair<String, ? extends Object>[] $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        Pair<String, ? extends Object>[] pairArray = $this$forEach$iv;
        int n = pairArray.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, ? extends Object> element$iv;
            Pair<String, ? extends Object> pair2 = element$iv = pairArray[i];
            boolean bl = false;
            this.appendHeader(pair2.getFirst(), pair2.getSecond());
        }
        return this.getRequest();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Request body(@NotNull Function0<? extends InputStream> openStream, @Nullable Function0<Long> calculateLength, @NotNull Charset charset, boolean repeatable) {
        void body2;
        Body body3;
        Intrinsics.checkNotNullParameter(openStream, "openStream");
        Intrinsics.checkNotNullParameter(charset, "charset");
        DefaultBody defaultBody = DefaultBody.Companion.from(openStream, calculateLength, charset);
        boolean bl = false;
        boolean bl2 = false;
        DefaultBody defaultBody2 = defaultBody;
        DefaultRequest defaultRequest = this;
        boolean bl3 = false;
        defaultRequest._body = body3 = repeatable ? (Body)body2.asRepeatable() : (Body)body2;
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request body(@NotNull InputStream stream, @Nullable Function0<Long> calculateLength, @NotNull Charset charset, boolean repeatable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return this.body((Function0<? extends InputStream>)new Function0<InputStream>(stream){
            final /* synthetic */ InputStream $stream;

            @NotNull
            public final InputStream invoke() {
                return this.$stream;
            }
            {
                this.$stream = inputStream2;
                super(0);
            }
        }, calculateLength, charset, repeatable);
    }

    @Override
    @NotNull
    public Request body(@NotNull byte[] bytes2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(bytes2, "bytes");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return this.body(new ByteArrayInputStream(bytes2), new Function0<Long>(bytes2){
            final /* synthetic */ byte[] $bytes;

            public final long invoke() {
                return this.$bytes.length;
            }
            {
                this.$bytes = byArray;
                super(0);
            }
        }, charset, true);
    }

    @Override
    @NotNull
    public Request body(@NotNull String body2, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Object object = body2;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        object = this.body(byArray, charset);
        bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)CollectionsKt.lastOrNull((Iterable)this.header("Content-Type"));
        boolean bl4 = false;
        boolean bl5 = false;
        return charSequence == null || StringsKt.isBlank(charSequence) ? this.header("Content-Type", (Object)("text/plain; charset=" + charset.name())) : it;
    }

    @Override
    @NotNull
    public Request body(@NotNull File file2, @NotNull Charset charset) {
        Object object;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Object object2 = charset;
        object2 = Intrinsics.areEqual(object2, Charsets.UTF_8) ? Request.DefaultImpls.body$default((Request)this, new Function0<InputStream>(file2){
            final /* synthetic */ File $file;

            @NotNull
            public final InputStream invoke() {
                return new FileInputStream(this.$file);
            }
            {
                this.$file = file2;
                super(0);
            }
        }, (Function0)new Function0<Long>(file2){
            final /* synthetic */ File $file;

            public final long invoke() {
                return this.$file.length();
            }
            {
                this.$file = file2;
                super(0);
            }
        }, charset, false, 8, null) : Request.DefaultImpls.body$default((Request)this, new Function0<InputStream>(file2){
            final /* synthetic */ File $file;

            @NotNull
            public final InputStream invoke() {
                return new FileInputStream(this.$file);
            }
            {
                this.$file = file2;
                super(0);
            }
        }, null, charset, false, 8, null);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)CollectionsKt.lastOrNull((Iterable)this.header("Content-Type"));
        boolean bl4 = false;
        boolean bl5 = false;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            String contentType = URLConnection.guessContentTypeFromName(file2.getName());
            object = this.header("Content-Type", (Object)(contentType + "; charset=" + charset.name()));
        } else {
            object = it;
        }
        return object;
    }

    @Override
    @NotNull
    public Request body(@NotNull Body body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this._body = body2;
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request requestProgress(@NotNull Function2<? super Long, ? super Long, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.getExecutionOptions().getRequestProgress().plusAssign(handler);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request responseProgress(@NotNull Function2<? super Long, ? super Long, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.getExecutionOptions().getResponseProgress().plusAssign(handler);
        return this.getRequest();
    }

    @Override
    @NotNull
    public Request interrupt(@NotNull Function1<? super Request, Unit> interrupt) {
        Intrinsics.checkNotNullParameter(interrupt, "interrupt");
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        Collection<Function1<Request, Unit>> collection = it.getExecutionOptions().getInterruptCallbacks();
        Function1<? super Request, Unit> function1 = interrupt;
        boolean bl4 = false;
        collection.add(function1);
        return request2;
    }

    @Override
    @NotNull
    public Request timeout(int timeout) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setTimeoutInMillisecond(timeout);
        return request2;
    }

    @Override
    @NotNull
    public Request timeoutRead(int timeout) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setTimeoutReadInMillisecond(timeout);
        return request2;
    }

    @Override
    @NotNull
    public Request allowRedirects(boolean allowRedirects) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setAllowRedirects(allowRedirects);
        return request2;
    }

    @Override
    @NotNull
    public Request useHttpCache(boolean useHttpCache) {
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setUseHttpCache(useHttpCache);
        return request2;
    }

    @Override
    @NotNull
    public Request validate(@NotNull Function1<? super Response, Boolean> validator) {
        Intrinsics.checkNotNullParameter(validator, "validator");
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        it.getExecutionOptions().setResponseValidator(validator);
        return request2;
    }

    @Override
    @NotNull
    public Request tag(@NotNull Object t2) {
        Intrinsics.checkNotNullParameter(t2, "t");
        Request request2 = this.getRequest();
        boolean bl = false;
        boolean bl2 = false;
        Request it = request2;
        boolean bl3 = false;
        this.tags.put(Reflection.getOrCreateKotlinClass(t2.getClass()), t2);
        return request2;
    }

    @Override
    @Nullable
    public <T> T getTag(@NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Object object = this.tags.get(clazz);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    @Override
    @NotNull
    public Request getRequest() {
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$buildString;
        String string2 = "--> " + (Object)((Object)this.getMethod()) + ' ' + this.getUrl();
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
        StringsKt.appendln(stringBuilder3);
        stringBuilder2 = $this$buildString;
        string2 = "Body : " + this.getBody().asString((String)CollectionsKt.lastOrNull((Iterable)this.header("Content-Type")));
        bl6 = false;
        StringBuilder stringBuilder4 = stringBuilder2.append(string2);
        Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
        StringsKt.appendln(stringBuilder4);
        stringBuilder2 = $this$buildString;
        string2 = "Headers : (" + this.getHeaders().size() + ')';
        bl6 = false;
        StringBuilder stringBuilder5 = stringBuilder2.append(string2);
        Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
        StringsKt.appendln(stringBuilder5);
        Function2 appendHeaderWithValue2 = new Function2<String, String, StringBuilder>($this$buildString){
            final /* synthetic */ StringBuilder $this_buildString;

            @NotNull
            public final StringBuilder invoke(@NotNull String key, @NotNull String value2) {
                Intrinsics.checkNotNullParameter(key, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                StringBuilder stringBuilder = this.$this_buildString;
                String string2 = key + " : " + value2;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
                return StringsKt.appendln(stringBuilder2);
            }
            {
                this.$this_buildString = stringBuilder;
                super(2);
            }
        };
        Headers.transformIterate$default(this.getHeaders(), appendHeaderWithValue2, null, 2, null);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull Function3<? super Request, ? super Response, ? super Result<byte[], ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull Function1<? super Result<byte[], ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull ResponseHandler<? super byte[]> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public CancellableRequest response(@NotNull Handler<? super byte[]> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new ByteArrayDeserializer(), handler);
    }

    @Override
    @NotNull
    public Triple<Request, Response, Result<byte[], FuelError>> response() {
        return DeserializableKt.response(this, (Deserializable)new ByteArrayDeserializer());
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull Function3<? super Request, ? super Response, ? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Function3<? super Request, ? super Response, ? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return this.responseString(Charsets.UTF_8, handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull Function1<? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Function1<? super Result<String, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return this.responseString(Charsets.UTF_8, handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull ResponseHandler<? super String> handler) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull ResponseHandler<? super String> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(null, 1, null), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Charset charset, @NotNull Handler<? super String> handler) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(charset), handler);
    }

    @Override
    @NotNull
    public CancellableRequest responseString(@NotNull Handler<? super String> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)new StringDeserializer(null, 1, null), handler);
    }

    @Override
    @NotNull
    public Triple<Request, Response, Result<String, FuelError>> responseString(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return DeserializableKt.response(this, (Deserializable)new StringDeserializer(charset));
    }

    @Override
    @NotNull
    public Triple<Request, Response, Result<String, FuelError>> responseString() {
        return DeserializableKt.response(this, (Deserializable)new StringDeserializer(Charsets.UTF_8));
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull Function3<? super Request, ? super Response, ? super Result<? extends T, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull Function1<? super Result<? extends T, ? extends FuelError>, Unit> handler) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull ResponseHandler<? super T> handler) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> CancellableRequest responseObject(@NotNull ResponseDeserializable<? extends T> deserializer, @NotNull Handler<? super T> handler) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        return DeserializableKt.response((Request)this, (Deserializable)deserializer, handler);
    }

    @Override
    @NotNull
    public <T> Triple<Request, Response, Result<T, FuelError>> responseObject(@NotNull ResponseDeserializable<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return DeserializableKt.response(this, (Deserializable)deserializer);
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter(uRL, "<set-?>");
        this.url = uRL;
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public List<Pair<String, Object>> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(@NotNull List<? extends Pair<String, ? extends Object>> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.parameters = list;
    }

    @NotNull
    public final Body get_body$fuel() {
        return this._body;
    }

    public final void set_body$fuel(@NotNull Body body2) {
        Intrinsics.checkNotNullParameter(body2, "<set-?>");
        this._body = body2;
    }

    @Override
    @NotNull
    public Map<String, Request> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public DefaultRequest(@NotNull Method method, @NotNull URL url, @NotNull Headers headers, @NotNull List<? extends Pair<String, ? extends Object>> parameters, @NotNull Body _body, @NotNull Map<String, Request> enabledFeatures, @NotNull Map<KClass<?>, Object> tags) {
        Intrinsics.checkNotNullParameter((Object)method, "method");
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Intrinsics.checkNotNullParameter(_body, "_body");
        Intrinsics.checkNotNullParameter(enabledFeatures, "enabledFeatures");
        Intrinsics.checkNotNullParameter(tags, "tags");
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.parameters = parameters;
        this._body = _body;
        this.enabledFeatures = enabledFeatures;
        this.tags = tags;
    }

    public /* synthetic */ DefaultRequest(Method method, URL uRL, Headers headers, List list, Body body2, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 4) != 0) {
            headers = new Headers();
        }
        if ((n & 8) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            body2 = new DefaultBody(null, null, null, 7, null);
        }
        if ((n & 0x20) != 0) {
            bl = false;
            map2 = new LinkedHashMap();
        }
        if ((n & 0x40) != 0) {
            bl = false;
            map3 = new LinkedHashMap();
        }
        this(method, uRL, headers, list, body2, map2, map3);
    }

    @NotNull
    public final Method component1() {
        return this.getMethod();
    }

    @NotNull
    public final URL component2() {
        return this.getUrl();
    }

    @NotNull
    public final Headers component3() {
        return this.getHeaders();
    }

    @NotNull
    public final List<Pair<String, Object>> component4() {
        return this.getParameters();
    }

    @NotNull
    public final Body component5$fuel() {
        return this._body;
    }

    @NotNull
    public final Map<String, Request> component6() {
        return this.getEnabledFeatures();
    }

    private final Map<KClass<?>, Object> component7() {
        return this.tags;
    }

    @NotNull
    public final DefaultRequest copy(@NotNull Method method, @NotNull URL url, @NotNull Headers headers, @NotNull List<? extends Pair<String, ? extends Object>> parameters, @NotNull Body _body, @NotNull Map<String, Request> enabledFeatures, @NotNull Map<KClass<?>, Object> tags) {
        Intrinsics.checkNotNullParameter((Object)method, "method");
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Intrinsics.checkNotNullParameter(_body, "_body");
        Intrinsics.checkNotNullParameter(enabledFeatures, "enabledFeatures");
        Intrinsics.checkNotNullParameter(tags, "tags");
        return new DefaultRequest(method, url, headers, parameters, _body, enabledFeatures, tags);
    }

    public static /* synthetic */ DefaultRequest copy$default(DefaultRequest defaultRequest, Method method, URL uRL, Headers headers, List list, Body body2, Map map2, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            method = defaultRequest.getMethod();
        }
        if ((n & 2) != 0) {
            uRL = defaultRequest.getUrl();
        }
        if ((n & 4) != 0) {
            headers = defaultRequest.getHeaders();
        }
        if ((n & 8) != 0) {
            list = defaultRequest.getParameters();
        }
        if ((n & 0x10) != 0) {
            body2 = defaultRequest._body;
        }
        if ((n & 0x20) != 0) {
            map2 = defaultRequest.getEnabledFeatures();
        }
        if ((n & 0x40) != 0) {
            map3 = defaultRequest.tags;
        }
        return defaultRequest.copy(method, uRL, headers, list, body2, map2, map3);
    }

    public int hashCode() {
        Method method = this.getMethod();
        URL uRL = this.getUrl();
        Headers headers = this.getHeaders();
        List<Pair<String, Object>> list = this.getParameters();
        Body body2 = this._body;
        Map<String, Request> map2 = this.getEnabledFeatures();
        Map<KClass<?>, Object> map3 = this.tags;
        return ((((((method != null ? ((Object)((Object)method)).hashCode() : 0) * 31 + (uRL != null ? ((Object)uRL).hashCode() : 0)) * 31 + (headers != null ? headers.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (body2 != null ? body2.hashCode() : 0)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (map3 != null ? ((Object)map3).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DefaultRequest)) break block3;
                DefaultRequest defaultRequest = (DefaultRequest)object;
                if (!Intrinsics.areEqual((Object)this.getMethod(), (Object)defaultRequest.getMethod()) || !Intrinsics.areEqual(this.getUrl(), defaultRequest.getUrl()) || !Intrinsics.areEqual(this.getHeaders(), defaultRequest.getHeaders()) || !Intrinsics.areEqual(this.getParameters(), defaultRequest.getParameters()) || !Intrinsics.areEqual(this._body, defaultRequest._body) || !Intrinsics.areEqual(this.getEnabledFeatures(), defaultRequest.getEnabledFeatures()) || !Intrinsics.areEqual(this.tags, defaultRequest.tags)) break block3;
            }
            return true;
        }
        return false;
    }
}

