/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.LabelledGraph;
import datastructures.MutableLabelledGraph;
import datastructures.Word;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\n\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002\u001b\u001cB/\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011J)\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ldatastructures/NFA;", "S", "L", "", "graph", "Ldatastructures/LabelledGraph;", "Ldatastructures/NFA$LetterOrEpsilon;", "initial", "accepting", "(Ldatastructures/LabelledGraph;Ljava/lang/Object;Ljava/lang/Object;)V", "getAccepting", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getInitial", "accepts", "", "word", "Ldatastructures/Word;", "getDirectSuccessors", "", "state", "letter", "(Ljava/lang/Object;Ldatastructures/NFA$LetterOrEpsilon;)Ljava/util/Set;", "getEpsilonSuccessors", "(Ljava/lang/Object;)Ljava/util/Set;", "getSuccessors", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "Companion", "LetterOrEpsilon", "GeneralUtils"})
public final class NFA<S, L> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LabelledGraph<S, LetterOrEpsilon<L>> graph;
    private final S initial;
    private final S accepting;

    public NFA(@NotNull LabelledGraph<S, LetterOrEpsilon<L>> graph, S initial, S accepting) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        this.graph = graph;
        this.initial = initial;
        this.accepting = accepting;
    }

    public final S getInitial() {
        return this.initial;
    }

    public final S getAccepting() {
        return this.accepting;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean accepts(@NotNull Word<L> word) {
        Intrinsics.checkNotNullParameter(word, "word");
        Set<Object> currentStates = SetsKt.setOf(this.initial);
        Set<S> acceptingStates = SetsKt.setOf(this.accepting);
        int currentLetterIndex = 0;
        while (currentLetterIndex <= word.size() && !currentStates.isEmpty()) {
            void $this$flatMapTo$iv$iv;
            if (currentLetterIndex == word.size()) {
                return !((Collection)CollectionsKt.intersect((Iterable)currentStates, (Iterable)acceptingStates)).isEmpty();
            }
            Iterable $this$flatMap$iv = currentStates;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                Iterable list$iv$iv = this.getSuccessors(it, word.get(currentLetterIndex));
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            currentStates = CollectionsKt.toSet((List)destination$iv$iv);
            int n = currentLetterIndex;
            currentLetterIndex = n + 1;
        }
        return false;
    }

    private final Set<S> getSuccessors(S state, L letter) {
        Iterable list$iv$iv;
        Object it;
        Object element$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getEpsilonSuccessors(state);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            list$iv$iv = this.getDirectSuccessors(it, new LetterOrEpsilon.Letter<L>(letter));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = CollectionsKt.toSet((List)destination$iv$iv);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            list$iv$iv = this.getEpsilonSuccessors(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<S> getDirectSuccessors(S state, LetterOrEpsilon<L> letter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.graph.succs(state);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object succ = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(this.graph.getEdgeLabel(state, succ), letter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<S> getEpsilonSuccessors(S state) {
        Object[] objectArray = new Object[]{state};
        Set<Object> res2 = SetsKt.mutableSetOf(objectArray);
        while (true) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = res2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                Iterable list$iv$iv = this.getDirectSuccessors(it, LetterOrEpsilon.Epsilon.Companion.invoke());
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Set set = CollectionsKt.toSet((List)destination$iv$iv);
            if (res2.containsAll(set)) {
                return res2;
            }
            res2.addAll(set);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002:\u0002\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldatastructures/NFA$LetterOrEpsilon;", "L", "", "()V", "Epsilon", "Letter", "Ldatastructures/NFA$LetterOrEpsilon$Epsilon;", "Ldatastructures/NFA$LetterOrEpsilon$Letter;", "GeneralUtils"})
    public static abstract class LetterOrEpsilon<L> {
        private LetterOrEpsilon() {
        }

        public /* synthetic */ LetterOrEpsilon(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u0006*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Ldatastructures/NFA$LetterOrEpsilon$Epsilon;", "L", "Ldatastructures/NFA$LetterOrEpsilon;", "()V", "toString", "", "Companion", "GeneralUtils"})
        public static final class Epsilon<L>
        extends LetterOrEpsilon<L> {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final Epsilon<Object> instance = new Epsilon();

            private Epsilon() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "eps";
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0004\u0010\u0006H\u0086\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldatastructures/NFA$LetterOrEpsilon$Epsilon$Companion;", "", "()V", "instance", "Ldatastructures/NFA$LetterOrEpsilon$Epsilon;", "invoke", "L", "GeneralUtils"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final <L> Epsilon<L> invoke() {
                    return instance;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Ldatastructures/NFA$LetterOrEpsilon$Letter;", "L", "Ldatastructures/NFA$LetterOrEpsilon;", "letter", "(Ljava/lang/Object;)V", "getLetter", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Ldatastructures/NFA$LetterOrEpsilon$Letter;", "equals", "", "other", "", "hashCode", "", "toString", "", "GeneralUtils"})
        public static final class Letter<L>
        extends LetterOrEpsilon<L> {
            private final L letter;

            public Letter(L letter) {
                super(null);
                this.letter = letter;
            }

            public final L getLetter() {
                return this.letter;
            }

            public final L component1() {
                return this.letter;
            }

            @NotNull
            public final Letter<L> copy(L letter) {
                return new Letter<L>(letter);
            }

            public static /* synthetic */ Letter copy$default(Letter letter, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = letter.letter;
                }
                return letter.copy(object);
            }

            @NotNull
            public String toString() {
                return "Letter(letter=" + this.letter + ")";
            }

            public int hashCode() {
                return this.letter == null ? 0 : this.letter.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Letter)) {
                    return false;
                }
                Letter letter = (Letter)other;
                return Intrinsics.areEqual(this.letter, letter.letter);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJM\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00040\f2\u0006\u0010\r\u001a\u0002H\u00052\u0006\u0010\u000e\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u000fJ;\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\u0011\u001a\u0002H\u00062\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0012JF\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\u00a8\u0006\u0016"}, d2={"Ldatastructures/NFA$Companion;", "", "()V", "epsilon", "Ldatastructures/NFA;", "S", "L", "source", "sink", "(Ljava/lang/Object;Ljava/lang/Object;)Ldatastructures/NFA;", "plus", "ops", "", "newInit", "newAccepting", "(Ljava/util/List;Ljava/lang/Object;Ljava/lang/Object;)Ldatastructures/NFA;", "singleLetter", "letter", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ldatastructures/NFA;", "times", "op1", "op2", "GeneralUtils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <S, L> NFA<S, L> singleLetter(S source, L letter, S sink) {
            return new NFA<S, L>(LabelledGraph.Companion.singleEdge(source, new LetterOrEpsilon.Letter<L>(letter), sink), source, sink);
        }

        @NotNull
        public final <S, L> NFA<S, L> epsilon(S source, S sink) {
            return new NFA(LabelledGraph.Companion.singleEdge(source, LetterOrEpsilon.Epsilon.Companion.invoke(), sink), source, sink);
        }

        @NotNull
        public final <S, L> NFA<S, L> plus(@NotNull List<NFA<S, L>> ops, S newInit, S newAccepting) {
            NFA it;
            Intrinsics.checkNotNullParameter(ops, "ops");
            MutableLabelledGraph newLg = new MutableLabelledGraph();
            Iterable $this$forEach$iv = ops;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (NFA)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = it.graph.getAllEdges();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair $dstr$n1$n2 = (Pair)element$iv2;
                    boolean bl2 = false;
                    Object n1 = $dstr$n1$n2.component1();
                    Object n2 = $dstr$n1$n2.component2();
                    newLg.put(n1, it.graph.getEdgeLabel(n1, n2), n2);
                }
            }
            $this$forEach$iv = ops;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (NFA)element$iv;
                boolean bl = false;
                newLg.put(newInit, LetterOrEpsilon.Epsilon.Companion.invoke(), it.getInitial());
                newLg.put(it.getAccepting(), LetterOrEpsilon.Epsilon.Companion.invoke(), newAccepting);
            }
            return new NFA(newLg.freeze(), newInit, newAccepting);
        }

        @NotNull
        public final <S, L> NFA<S, L> times(@NotNull NFA<S, L> op1, @NotNull NFA<S, L> op2) {
            Object n2;
            Object n1;
            Pair $dstr$n1$n2;
            Intrinsics.checkNotNullParameter(op1, "op1");
            Intrinsics.checkNotNullParameter(op2, "op2");
            if (!Intrinsics.areEqual(op1.getAccepting(), op2.getInitial())) {
                boolean $i$a$-check-NFA$Companion$times$22 = false;
                String $i$a$-check-NFA$Companion$times$22 = "should not happen";
                throw new IllegalStateException($i$a$-check-NFA$Companion$times$22.toString());
            }
            MutableLabelledGraph newLg = new MutableLabelledGraph();
            Iterable $this$forEach$iv = ((NFA)op1).graph.getAllEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                $dstr$n1$n2 = (Pair)element$iv;
                boolean bl = false;
                n1 = $dstr$n1$n2.component1();
                n2 = $dstr$n1$n2.component2();
                newLg.put(n1, ((NFA)op1).graph.getEdgeLabel(n1, n2), n2);
            }
            $this$forEach$iv = ((NFA)op2).graph.getAllEdges();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                $dstr$n1$n2 = (Pair)element$iv;
                boolean bl = false;
                n1 = $dstr$n1$n2.component1();
                n2 = $dstr$n1$n2.component2();
                newLg.put(n1, ((NFA)op2).graph.getEdgeLabel(n1, n2), n2);
            }
            return new NFA(newLg.freeze(), op1.getInitial(), op2.getAccepting());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

