# MIT License
#
# Copyright (c) 2020 Jonathan Zernik
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
"""Initialize all

Revision ID: d7538b753a8a
Revises:
Create Date: 2021-09-09 23:15:50.078578

"""
import sqlalchemy as sa
from alembic import op

import squeaknode.db.models


# revision identifiers, used by Alembic.
revision = 'd7538b753a8a'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('peer',
                    sa.Column('peer_id', sa.Integer(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('peer_name', sa.String(), nullable=False),
                    sa.Column('host', sa.String(), nullable=False),
                    sa.Column('port', sa.Integer(), nullable=False),
                    sa.Column('autoconnect', sa.Boolean(), nullable=False),
                    sa.PrimaryKeyConstraint('peer_id'),
                    sa.UniqueConstraint(
                        'host', 'port', name='uq_peer_host_port'),
                    sqlite_autoincrement=True
                    )
    op.create_table('profile',
                    sa.Column('profile_id', sa.Integer(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('profile_name', sa.String(), nullable=False),
                    sa.Column('private_key', sa.LargeBinary(), nullable=True),
                    sa.Column('address', sa.String(length=35), nullable=False),
                    sa.Column('following', sa.Boolean(), nullable=False),
                    sa.Column('use_custom_price',
                              sa.Boolean(), nullable=False),
                    sa.Column('custom_price_msat',
                              sa.Integer(), nullable=False),
                    sa.Column('profile_image',
                              sa.LargeBinary(), nullable=True),
                    sa.PrimaryKeyConstraint('profile_id'),
                    sa.UniqueConstraint('address'),
                    sa.UniqueConstraint('profile_name'),
                    sqlite_autoincrement=True
                    )
    op.create_table('received_offer',
                    sa.Column(
                        'received_offer_id', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('squeak_hash', sa.LargeBinary(), nullable=False),
                    sa.Column('payment_hash', sa.LargeBinary(),
                              nullable=False),
                    sa.Column('nonce', sa.LargeBinary(), nullable=False),
                    sa.Column('payment_point',
                              sa.LargeBinary(), nullable=False),
                    sa.Column('invoice_timestamp',
                              sa.Integer(), nullable=False),
                    sa.Column('invoice_expiry', sa.Integer(), nullable=False),
                    sa.Column('price_msat', sa.Integer(), nullable=False),
                    sa.Column('payment_request', sa.String(), nullable=False),
                    sa.Column('destination', sa.String(
                        length=66), nullable=False),
                    sa.Column('lightning_host', sa.String(), nullable=False),
                    sa.Column('lightning_port', sa.Integer(), nullable=False),
                    sa.Column('peer_host', sa.String(), nullable=False),
                    sa.Column('peer_port', sa.Integer(), nullable=False),
                    sa.Column('paid', sa.Boolean(), nullable=False),
                    sa.PrimaryKeyConstraint('received_offer_id'),
                    sa.UniqueConstraint('payment_hash'),
                    sqlite_autoincrement=True
                    )
    op.create_table('received_payment',
                    sa.Column('received_payment_id',
                              squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('squeak_hash', sa.LargeBinary(), nullable=False),
                    sa.Column('payment_hash', sa.LargeBinary(),
                              nullable=False),
                    sa.Column('price_msat', sa.Integer(), nullable=False),
                    sa.Column('settle_index',
                              squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('peer_host', sa.String(), nullable=False),
                    sa.Column('peer_port', sa.Integer(), nullable=False),
                    sa.PrimaryKeyConstraint('received_payment_id'),
                    sa.UniqueConstraint('payment_hash'),
                    sqlite_autoincrement=True
                    )
    op.create_table('sent_offer',
                    sa.Column(
                        'sent_offer_id', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('squeak_hash', sa.LargeBinary(), nullable=False),
                    sa.Column('payment_hash', sa.LargeBinary(),
                              nullable=False),
                    sa.Column('secret_key', sa.LargeBinary(), nullable=False),
                    sa.Column('nonce', sa.LargeBinary(), nullable=False),
                    sa.Column('price_msat', sa.Integer(), nullable=False),
                    sa.Column('payment_request', sa.String(), nullable=False),
                    sa.Column('invoice_timestamp',
                              sa.Integer(), nullable=False),
                    sa.Column('invoice_expiry', sa.Integer(), nullable=False),
                    sa.Column('peer_host', sa.String(), nullable=False),
                    sa.Column('peer_port', sa.Integer(), nullable=False),
                    sa.Column('paid', sa.Boolean(), nullable=False),
                    sa.PrimaryKeyConstraint('sent_offer_id'),
                    sa.UniqueConstraint('payment_hash'),
                    sqlite_autoincrement=True
                    )
    op.create_table('sent_payment',
                    sa.Column(
                        'sent_payment_id', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('peer_host', sa.String(), nullable=False),
                    sa.Column('peer_port', sa.Integer(), nullable=False),
                    sa.Column('squeak_hash', sa.LargeBinary(), nullable=False),
                    sa.Column('payment_hash', sa.LargeBinary(),
                              nullable=False),
                    sa.Column('secret_key', sa.LargeBinary(), nullable=False),
                    sa.Column('price_msat', sa.Integer(), nullable=False),
                    sa.Column('node_pubkey', sa.String(
                        length=66), nullable=False),
                    sa.Column('valid', sa.Boolean(), nullable=False),
                    sa.PrimaryKeyConstraint('sent_payment_id'),
                    sa.UniqueConstraint('payment_hash'),
                    sqlite_autoincrement=True
                    )
    op.create_table('squeak',
                    sa.Column('hash', sa.LargeBinary(), nullable=False),
                    sa.Column(
                        'created_time_ms', squeaknode.db.models.SLBigInteger(), nullable=False),
                    sa.Column('squeak', sa.LargeBinary(), nullable=False),
                    sa.Column('hash_reply_sqk',
                              sa.LargeBinary(), nullable=True),
                    sa.Column('hash_block', sa.LargeBinary(), nullable=False),
                    sa.Column('n_block_height', sa.Integer(), nullable=False),
                    sa.Column('n_time', sa.Integer(), nullable=False),
                    sa.Column('author_address', sa.String(
                        length=35), nullable=False),
                    sa.Column('secret_key', sa.LargeBinary(), nullable=True),
                    sa.Column('block_time', sa.Integer(), nullable=False),
                    sa.Column('liked_time_ms',
                              squeaknode.db.models.SLBigInteger(), nullable=True),
                    sa.Column('content', sa.String(length=280), nullable=True),
                    sa.PrimaryKeyConstraint('hash')
                    )
    with op.batch_alter_table('squeak', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_squeak_author_address'), [
                              'author_address'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('squeak', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_squeak_author_address'))

    op.drop_table('squeak')
    op.drop_table('sent_payment')
    op.drop_table('sent_offer')
    op.drop_table('received_payment')
    op.drop_table('received_offer')
    op.drop_table('profile')
    op.drop_table('peer')
    # ### end Alembic commands ###
