"""Constances for testing purposes."""

DOMAIN = "inels"

FRAGMENT_TOPIC_SET = "set"
FRAGMENT_TOPIC_STATUS = "status"
FRAGMENT_TOPIC_CONNECTED = "connected"
FRAGMENT_TOPIC_CU_ID = "2C4A4F103290"

TEST_HOST = "127.0.0.1"
TEST_PORT = 9883
TEST_USER_NAME = "test"
TEST_PASSWORD = "test_password"
TEST_DEBUG_TRUE = True
TEST_DEBUG_FALSE = False

TEST_INELS_MQTT_NAMESPACE = "inelsmqtt"
TEST_INELS_MQTT_CLASS_NAMESPACE = "inelsmqtt.InelsMqtt"

TEST_SWITCH_TOPIC_STATE = "inels/status/4254524524/02/452454"
TEST_SWITCH_TOPIC_SET = "inels/set/4254524524/02/452454"
TEST_SWITICH_TOPIC_CONNECTED = "inels/connected/4254524524/02/452454"

TEST_SWITCH_WITH_TEMP_TOPIC_STATE = "inels/status/4254524524/07/452454"
TEST_SWITCH_WITH_TEMP_TOPIC_SET = "inels/set/4254524524/07/452454"
TEST_SWITCH_WITH_TEMP_TOPIC_CONNECTED = "inels/connected/4254524524/07/452454"
TEST_SWITCH_WITH_TEMP_STATE_ON_VALUE = b"07\n01\n92\n09\n"
TEST_SWITCH_WITH_TEMP_STATE_OFF_VALUE = b"07\n00\n34\n08\n"

TEST_AVAILABILITY_ON = "on\n"
TEST_AVAILABILITY_OFF = "off\n"

TEST_SENSOR_TOPIC_STATE = "inels/status/4254524524/10/454354"
TEST_SENSOR_TOPIC_CONNECTED = "inels/connected/4254524524/10/454354"
TEST_TEMPERATURE_DATA = b"00\nB4\n0A\n6E\n0A\n"

TEST_LIGHT_DIMMABLE_TOPIC_STATE = "inels/status/4254524524/05/88556633"
TEST_LIGHT_DIMMABLE_CONNECTED = "inels/connected/4254524524/05/88556633"
TEST_LIGH_STATE_HA_VALUE = 20
TEST_LIGH_STATE_INELS_VALUE = b"C9\n4F\n"
TEST_LIGHT_SET_INELS_VALUE = "01 C9 4F"

TEST_COVER_RFJA_12_TOPIC_STATE = "inels/status/4254524524/03/444555225"
TEST_COVER_RFJA_12_TOPIC_CONNECTED = "inels/connected/4254524524/03/444555225"
TEST_COVER_RFJA_12_INELS_STATE_OPEN = b"03\n01\n"
TEST_COVER_RFJA_12_INELS_STATE_CLOSED = b"03\n00\n"
TEST_COVER_RFJA_12_HA_STATE_OPEN = "open"
TEST_COVER_RFJA_12_HA_STATE_CLOSED = "closed"
TEST_COVER_RFJA_12_SET_OPEN = "02 00 00"
TEST_COVER_RFJA_12_SET_CLOSE = "01 00 00"
TEST_COVER_RFJA_12_SET_STOP_UP = "05 00 00"
TEST_COVER_RFJA_12_SET_STOP_DOWN = "03 00 00"

TEST_CLIMATE_RFATV_2_TOPIC_STATE = "inels/status/4254524524/09/4249589"
TEST_CLIMATE_RFATV_2_TOPIC_CONNECTED = "inels/connected/4254524524/09/4249589"
TEST_CLIMATE_RFATV_2_OPEN_TO_40_STATE_VALUE = b"50\n34\n00\n40\n00\n"
TEST_CLIMATE_RFATV_2_SET_VALUE = "00 3C 00"

TEST_BUTTON_RFGB_40_TOPIC_STATE = "inels/status/4254524524/19/10904"
TEST_BUTTON_RFGB_40_TOPIC_CONNECTED = "inels/connected/4254524524/19/10904"
TEST_BUTTON_RFGB_40_STATE_VALUE = b"20\n01\nDA\n23\n54\n"

TEST_SENSOR_RFTC_10_G_TOPIC_STATE = "inels/status/2C4A4F103290/12/05010E"
TEST_SENSOR_RFTC_10_G_TOPIC_CONNECTED = "inels/connected/2C4A4F103290/12/05010E"
TEST_SENSOR_RFTC_10_G_STATE_VALUE = b"2A\n00\n80\n00\n00\n"

# RFSTI-11B
TEST_TOPIC_STATE_RFSTI_11B = (
    f"{DOMAIN}/{FRAGMENT_TOPIC_STATUS}/{FRAGMENT_TOPIC_CU_ID}/07/058C63"
)
TEST_TOPIC_CONNECTED_RFSTI_11B = (
    f"{DOMAIN}/{FRAGMENT_TOPIC_CONNECTED}/{FRAGMENT_TOPIC_CU_ID}/07/058C63"
)
TEST_TOPIC_SET_RFSTI_11B = (
    f"{DOMAIN}/{FRAGMENT_TOPIC_SET}/{FRAGMENT_TOPIC_CU_ID}/07/058C63"
)

TEST_TOPIC_STATUS_VALUE_ON_RFSTI_11B = b"07\n01\n42\n09\n"
TEST_TOPIC_STATUS_VALUE_OFF_RFSTI_11B = b"07\n00\n10\n09\n"
TEST_TOPIC_SET_VALUE_ON_RFSTI_11B = b"01\n00\n"
TEST_TOPIC_SET_VALUE_OFF_RFSTI_11B = b"02\n00\n"

# RFDAC-71B
TEST_TOPIC_STATE_RFDAC_71B = (
    f"{DOMAIN}/{FRAGMENT_TOPIC_STATUS}/{FRAGMENT_TOPIC_CU_ID}/05/03252"
)
TEST_TOPIC_CONNECTED_RFDAC_71B = (
    f"{DOMAIN}/{FRAGMENT_TOPIC_CONNECTED}/{FRAGMENT_TOPIC_CU_ID}/05/03252"
)
TEST_TOPIC_SET_RFDAC_71B = (
    f"{DOMAIN}/{FRAGMENT_TOPIC_SET}/{FRAGMENT_TOPIC_CU_ID}/05/03252"
)

TEST_TOPIC_SET_LIGHT_10_RFDAC_71B = "01 D1 1F"
TEST_TOPIC_SET_LIGHT_80_RFDAC_71B = "01 9A 6F"

TEST_TOPIC_STATE_LIGHT_10_RFDAC_71B = b"D1\n1F\n"
TEST_TOPIC_STATE_LIGHT_80_RFDAC_71B = b"9A\n6F\n"
