# [GreenLabs] - Face Recognition 

This library written in MXNET framework. 

**Author:** 			HungLV

**Last Update:**    July 13, 2020

**It features:**

* Face Detection 
* Extract Face Embedding
* Search Face in database

**Code:** 

**Documentation:** 

**User-Guide:** 

**Model zoo:** 

**Tech report:**

## What's new

* `[Jul 9]` Initial version
* `[Jul 13]` Make the models can run on GPU/CPU. Integrated `rcnn` library. 

## Installation 

Make sure `conda` is installed

```
pip install green-face-recognition
```

## Getting started
Prepare the config file as `yaml` type. Take a look [this example](https://github.com/leviethung2103/face-recognition-baseline/blob/master/configs/server_api.yaml).

**Show the list of models**

```python
from face_recognition import models
models.show_avai_models()
```

**Load the models**

```python
retina_model = models.build_model('retina-r50',config_path)
arcface = models.build_model('arc-face',config_path)
```

**Make the prediction**
```python
# get faces and landmarks
retina_model.detect_fast(img,img.shape,0.8,[1],do_flip=False)
```


## Appendix

Generate the distributions for uploading to server

```
python3 setup.py sdist bdist_wheel 
```

Upload to server

```
python3 -m twine upload --repository pypi dist/*
```

## Reference

[1. RetinaFaceModel](https://github.com/deepinsight/insightface/tree/master/RetinaFace)