# Contributing

If you are interested in becoming a part of the UniteLabs community, a great way to get involved is to contribute to a
UniteLabs related project. If you have found a bug or would like to see a new feature, feel free to report a new issue
in the corresponding project on GitLab.

## Contribute Code

You are welcome to contribute code to UniteLabs related projects in order to fix bugs or to implement new features.

There are three important things to know:

1. You must be aware of the MIT License (which describes contributions) and agree to the Contributors License Agreement.
   This is common practice in all major Open Source projects. For company contributors special rules apply. See the
   respective section below for details.
2. There are several requirements regarding code style, quality, and product standards which need to be met (we also
   have to follow them).
3. Not all proposed contributions can be accepted. Some features may e.g. just fit a third-party add-on better. The code
   must fit the overall direction of the UniteLabs related project and really improve it. The more effort you invest,
   the better you should clarify in advance whether the contribution fits: the best way would be to just open an issue
   to discuss the feature you plan to implement (make it clear you intend to contribute).

### Contributor Agreement

When you contribute (code, documentation, or anything else), you have to be aware that your contribution is covered by
the same MIT License that is applied to the UniteLabs related project itself. Additionally, the following terms apply to
your contribution and must be accepted.

This is a binding legal agreement on you and any organization you represent. If you agree to this agreement on behalf of
your employer or other organization, you represent and warrant that you have the authority to agree to this Agreement on
behalf of the organization.

#### 1. Definitions.

**"Contribution"** means any original work, including any modification of or addition to an existing work, that you
submit to UniteLabs related projects in any manner for inclusion in any Work.

**"UniteLabs"**, **"we"** and **"us"** means UniteLabs.

**"Work"** means any project, work or materials owned or managed by UniteLabs.

**"You"** and **"your"** means you and any organization on whose behalf you are entering this Agreement.

#### 2. Copyright Assignment, License and Waiver.

**(a) Assignment.** By submitting a Contribution, you assign to UniteLabs all right, title and interest in any copyright
you have in the Contribution, and you waive any rights, including any moral rights, database rights, etc., that may
affect our ownership of the copyright in the Contribution.

**(b) License to UniteLabs.** If your assignment in Section 2(a) is ineffective for any reason, you grant to us and to
any recipient of any Work distributed by us, a perpetual, worldwide, transferable, non-exclusive, no-charge,
royalty-free, irrevocable, and sublicensable license to use, reproduce, prepare derivative works of, publicly display,
publicly perform, sublicense, and distribute Contributions and any derivative work created based on a Contribution. If
your license grant is ineffective for any reason, you irrevocably waive and covenant to not assert any claim you may
have against us, our successors in interest, and any of our direct or indirect licensees and customers, arising out of
our, our successors in interest's, or any of our direct or indirect licensees' or customers' use, reproduction, 
preparation of derivative works, public display, public performance, sublicense, and distribution of a Contribution. You 
also agree that we may publicly use your name and the name of any organization on whose behalf you're entering into this
Agreement in connection with publicizing the Work.

**(c) License to You.** We grant to you a perpetual, worldwide, transferable, non-exclusive, no-charge, royalty-free,
irrevocable, and sublicensable license to use, reproduce, prepare derivative works of, publicly display, publicly
perform, sublicense, and distribute a Contribution and any derivative works you create based on a Contribution.

#### 3. Patent License.

You grant to us and to any recipient of any Work distributed by us, a perpetual, worldwide, transferable, non-exclusive,
no-charge, royalty-free, irrevocable, and sublicensable patent license to make, have made, use, sell, offer to sell,
import, and otherwise transfer the Contribution in whole or in part, alone or included in any Work under any patent you
own, or license from a third party, that is necessarily infringed by the Contribution or by combination of the
Contribution with any Work.

#### 4. Your Representations and Warranties.

By submitting a Contribution, you represent and warrant that: (a) each Contribution you submit is an original work and
you can legally grant the rights set out in this Agreement; (b) the Contribution does not, and any exercise of the
rights granted by you will not, infringe any third party's intellectual property or other right; and (c) you are not
aware of any claims, suits, or actions pertaining to the Contribution. You will notify us immediately if you become
aware or have reason to believe that any of your representations and warranties is or becomes inaccurate.

#### 5. Intellectual Property.

Except for the assignment and licenses set forth in this Agreement, this Agreement does not transfer any right, title or
interest in any intellectual property right of either party to the other. If you choose to provide us with suggestions,
ideas for improvement, recommendations or other feedback, on any Work we may use your feedback without any restriction
or payment.

#### 6. Miscellaneous.

Swiss law governs this Agreement, excluding any applicable conflict of laws rules or principles, and the parties agree
to the exclusive jurisdiction of the courts in Basel, Switzerland. This Agreement does not create a partnership, agency
relationship, or joint venture between the parties. We may assign this Agreement without notice or restriction. If any
provision of this Agreement is unenforceable, that provision will be modified to render it enforceable to the extent
possible to effect the parties' intention and the remaining provisions will not be affected. The parties may amend this
Agreement only in a written amendment signed by both parties. This Agreement comprises the parties' entire agreement
relating to the subject matter of this Agreement.
