# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

from pythie_serving.tensorflow_proto.tensorflow.core.protobuf import eager_service_pb2 as tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2


class EagerServiceStub(object):
  """//////////////////////////////////////////////////////////////////////////////

  Eager Service defines a TensorFlow service that executes operations eagerly
  on a set of local devices, on behalf of a remote Eager executor.

  The service impl will keep track of the various clients and devices it has
  access to and allows the client to enqueue ops on any devices that it is able
  to access and schedule data transfers from/to any of the peers.

  A client can generate multiple contexts to be able to independently execute
  operations, but cannot share data between the two contexts.

  NOTE: Even though contexts generated by clients should be independent, the
  lower level tensorflow execution engine is not, so they might share some data
  (e.g. a Device's ResourceMgr).

  //////////////////////////////////////////////////////////////////////////////
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.CreateContext = channel.unary_unary(
        '/tensorflow.eager.EagerService/CreateContext',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CreateContextRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CreateContextResponse.FromString,
        )
    self.Enqueue = channel.unary_unary(
        '/tensorflow.eager.EagerService/Enqueue',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueResponse.FromString,
        )
    self.StreamingEnqueue = channel.stream_stream(
        '/tensorflow.eager.EagerService/StreamingEnqueue',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueResponse.FromString,
        )
    self.WaitQueueDone = channel.unary_unary(
        '/tensorflow.eager.EagerService/WaitQueueDone',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.WaitQueueDoneRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.WaitQueueDoneResponse.FromString,
        )
    self.KeepAlive = channel.unary_unary(
        '/tensorflow.eager.EagerService/KeepAlive',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.KeepAliveRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.KeepAliveResponse.FromString,
        )
    self.CloseContext = channel.unary_unary(
        '/tensorflow.eager.EagerService/CloseContext',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CloseContextRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CloseContextResponse.FromString,
        )
    self.RegisterFunction = channel.unary_unary(
        '/tensorflow.eager.EagerService/RegisterFunction',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.RegisterFunctionRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.RegisterFunctionResponse.FromString,
        )
    self.SendTensor = channel.unary_unary(
        '/tensorflow.eager.EagerService/SendTensor',
        request_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.SendTensorRequest.SerializeToString,
        response_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.SendTensorResponse.FromString,
        )


class EagerServiceServicer(object):
  """//////////////////////////////////////////////////////////////////////////////

  Eager Service defines a TensorFlow service that executes operations eagerly
  on a set of local devices, on behalf of a remote Eager executor.

  The service impl will keep track of the various clients and devices it has
  access to and allows the client to enqueue ops on any devices that it is able
  to access and schedule data transfers from/to any of the peers.

  A client can generate multiple contexts to be able to independently execute
  operations, but cannot share data between the two contexts.

  NOTE: Even though contexts generated by clients should be independent, the
  lower level tensorflow execution engine is not, so they might share some data
  (e.g. a Device's ResourceMgr).

  //////////////////////////////////////////////////////////////////////////////
  """

  def CreateContext(self, request, context):
    """This initializes the worker, informing it about the other workers in the
    cluster and exchanging authentication tokens which will be used in all
    other RPCs to detect whether the worker has restarted.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Enqueue(self, request, context):
    """This takes a list of Execute and DeleteTensorHandle operations and enqueues
    (in async mode) or executes (in sync mode) them on the remote server.
    All outputs of ops which were not explicitly deleted with
    DeleteTensorHandle entries will be assumed to be alive and are usable by
    future calls to Enqueue.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def StreamingEnqueue(self, request_iterator, context):
    """A streaming version of Enqueue.
    Current server implementation sends one response per received request.
    The benefit for using a streaming version is that subsequent requests
    can be sent without waiting for a response to the previous request. This
    synchronization is required in the regular Enqueue call because gRPC does
    not guarantee to preserve request order.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def WaitQueueDone(self, request, context):
    """Takes a set of op IDs and waits until those ops are done. Returns any error
    in the stream so far.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def KeepAlive(self, request, context):
    """Contexts are always created with a deadline and no RPCs within a deadline
    will trigger a context garbage collection. KeepAlive calls can be used to
    delay this.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def CloseContext(self, request, context):
    """Closes the context. No calls to other methods using the existing context ID
    are valid after this.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def RegisterFunction(self, request, context):
    """Takes a FunctionDef and makes it enqueable on the remote worker.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SendTensor(self, request, context):
    """An RPC to push tensors to the server. At times, certain environments don't
    allow the server to connect back to the client.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_EagerServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'CreateContext': grpc.unary_unary_rpc_method_handler(
          servicer.CreateContext,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CreateContextRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CreateContextResponse.SerializeToString,
      ),
      'Enqueue': grpc.unary_unary_rpc_method_handler(
          servicer.Enqueue,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueResponse.SerializeToString,
      ),
      'StreamingEnqueue': grpc.stream_stream_rpc_method_handler(
          servicer.StreamingEnqueue,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.EnqueueResponse.SerializeToString,
      ),
      'WaitQueueDone': grpc.unary_unary_rpc_method_handler(
          servicer.WaitQueueDone,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.WaitQueueDoneRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.WaitQueueDoneResponse.SerializeToString,
      ),
      'KeepAlive': grpc.unary_unary_rpc_method_handler(
          servicer.KeepAlive,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.KeepAliveRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.KeepAliveResponse.SerializeToString,
      ),
      'CloseContext': grpc.unary_unary_rpc_method_handler(
          servicer.CloseContext,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CloseContextRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.CloseContextResponse.SerializeToString,
      ),
      'RegisterFunction': grpc.unary_unary_rpc_method_handler(
          servicer.RegisterFunction,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.RegisterFunctionRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.RegisterFunctionResponse.SerializeToString,
      ),
      'SendTensor': grpc.unary_unary_rpc_method_handler(
          servicer.SendTensor,
          request_deserializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.SendTensorRequest.FromString,
          response_serializer=tensorflow_dot_core_dot_protobuf_dot_eager__service__pb2.SendTensorResponse.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'tensorflow.eager.EagerService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
