/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/// <reference types="node" />
import { DistinguishedName } from './distinguished-name';
export interface ICertificate {
    readonly cert: string;
    readonly key: string;
    readonly passphrase: string;
    readonly certChain: string;
}
export declare class Certificate implements ICertificate {
    static fromGenerated(subject: DistinguishedName, passphrase: string, certValidFor?: number, signingCertificate?: Certificate): Promise<Certificate>;
    static decryptKey(key: string, passphrase: string): Promise<string>;
    private static generateSelfSigned;
    private static generateSigned;
    readonly cert: string;
    readonly key: string;
    readonly passphrase: string;
    readonly certChain: string;
    constructor(cert: string, key: string, passphrase: string, certChain: string);
    toPkcs12(passphrase: string): Promise<Buffer>;
}
