"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedEdgeKubernetesCluster = exports.ManagedEdgeKubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "ManagedEdgeKubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosManagedEdgeKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::ManagedEdgeKubernetesCluster`
 */
class ManagedEdgeKubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::ManagedEdgeKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosManagedEdgeKubernetesCluster = new cs_generated_1.RosManagedEdgeKubernetesCluster(this, id, {
            endpointPublicAccess: props.endpointPublicAccess ? props.endpointPublicAccess : true,
            containerCidr: props.containerCidr ? props.containerCidr : '172.16.0.0/16',
            keyPair: props.keyPair,
            vSwitchIds: props.vSwitchIds,
            timeoutMins: props.timeoutMins ? props.timeoutMins : 60,
            workerSystemDiskSize: props.workerSystemDiskSize ? props.workerSystemDiskSize : 120,
            workerSystemDiskCategory: props.workerSystemDiskCategory ? props.workerSystemDiskCategory : 'cloud_efficiency',
            profile: props.profile ? props.profile : 'Edge',
            name: props.name,
            workerDataDisk: props.workerDataDisk ? props.workerDataDisk : false,
            vpcId: props.vpcId,
            workerDataDiskSize: props.workerDataDiskSize,
            numOfNodes: props.numOfNodes,
            cloudMonitorFlags: props.cloudMonitorFlags ? props.cloudMonitorFlags : false,
            serviceCidr: props.serviceCidr ? props.serviceCidr : '172.19.0.0/20',
            workerDataDiskCategory: props.workerDataDiskCategory,
            snatEntry: props.snatEntry ? props.snatEntry : true,
            tags: ros.tagFactory(props.tags),
            proxyMode: props.proxyMode ? props.proxyMode : 'iptables',
            disableRollback: props.disableRollback ? props.disableRollback : true,
            loginPassword: props.loginPassword,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosManagedEdgeKubernetesCluster;
        this.attrClusterId = rosManagedEdgeKubernetesCluster.attrClusterId;
        this.attrTaskId = rosManagedEdgeKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosManagedEdgeKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.ManagedEdgeKubernetesCluster = ManagedEdgeKubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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