"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesCluster = exports.KubernetesClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "KubernetesClusterProperty", { enumerable: true, get: function () { return cs_generated_1.RosKubernetesCluster; } });
/**
 * A ROS resource type:  `ALIYUN::CS::KubernetesCluster`
 */
class KubernetesCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::KubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKubernetesCluster = new cs_generated_1.RosKubernetesCluster(this, id, {
            endpointPublicAccess: props.endpointPublicAccess ? props.endpointPublicAccess : false,
            workerPeriod: props.workerPeriod ? props.workerPeriod : 1,
            workerPeriodUnit: props.workerPeriodUnit ? props.workerPeriodUnit : 'Month',
            masterSystemDiskCategory: props.masterSystemDiskCategory ? props.masterSystemDiskCategory : 'cloud_ssd',
            addons: props.addons,
            masterSystemDiskSize: props.masterSystemDiskSize ? props.masterSystemDiskSize : 120,
            workerSystemDiskCategory: props.workerSystemDiskCategory ? props.workerSystemDiskCategory : 'cloud_efficiency',
            nodePortRange: props.nodePortRange ? props.nodePortRange : '30000-65535',
            masterCount: props.masterCount ? props.masterCount : 3,
            workerSystemDiskSize: props.workerSystemDiskSize ? props.workerSystemDiskSize : 120,
            sshFlags: props.sshFlags,
            masterVSwitchIds: props.masterVSwitchIds,
            name: props.name,
            taint: props.taint,
            masterDataDisks: props.masterDataDisks,
            cloudMonitorFlags: props.cloudMonitorFlags ? props.cloudMonitorFlags : false,
            serviceCidr: props.serviceCidr ? props.serviceCidr : '172.19.0.0/20',
            workerAutoRenew: props.workerAutoRenew ? props.workerAutoRenew : true,
            proxyMode: props.proxyMode ? props.proxyMode : 'iptables',
            tags: ros.tagFactory(props.tags),
            disableRollback: props.disableRollback ? props.disableRollback : true,
            workerInstanceTypes: props.workerInstanceTypes,
            loginPassword: props.loginPassword,
            masterPeriod: props.masterPeriod ? props.masterPeriod : 1,
            kubernetesVersion: props.kubernetesVersion ? props.kubernetesVersion : '1.14.8-aliyun.1',
            masterInstanceChargeType: props.masterInstanceChargeType ? props.masterInstanceChargeType : 'PostPaid',
            containerCidr: props.containerCidr ? props.containerCidr : '172.16.0.0/16',
            cpuPolicy: props.cpuPolicy ? props.cpuPolicy : 'none',
            workerInstanceChargeType: props.workerInstanceChargeType ? props.workerInstanceChargeType : 'PostPaid',
            keyPair: props.keyPair,
            masterInstanceTypes: props.masterInstanceTypes,
            workerDataDisks: props.workerDataDisks,
            securityGroupId: props.securityGroupId,
            timeoutMins: props.timeoutMins ? props.timeoutMins : 60,
            masterPeriodUnit: props.masterPeriodUnit ? props.masterPeriodUnit : 'Month',
            masterAutoRenewPeriod: props.masterAutoRenewPeriod ? props.masterAutoRenewPeriod : 1,
            workerDataDisk: props.workerDataDisk ? props.workerDataDisk : false,
            vpcId: props.vpcId,
            numOfNodes: props.numOfNodes ? props.numOfNodes : 3,
            masterAutoRenew: props.masterAutoRenew ? props.masterAutoRenew : true,
            workerAutoRenewPeriod: props.workerAutoRenewPeriod ? props.workerAutoRenewPeriod : 1,
            workerVSwitchIds: props.workerVSwitchIds,
            snatEntry: props.snatEntry ? props.snatEntry : true,
            masterDataDisk: props.masterDataDisk ? props.masterDataDisk : false,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKubernetesCluster;
        this.attrClusterId = rosKubernetesCluster.attrClusterId;
        this.attrTaskId = rosKubernetesCluster.attrTaskId;
        this.attrWorkerRamRoleName = rosKubernetesCluster.attrWorkerRamRoleName;
    }
}
exports.KubernetesCluster = KubernetesCluster;
//# sourceMappingURL=data:application/json;base64,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