"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosServerlessKubernetesCluster = exports.RosManagedKubernetesCluster = exports.RosManagedEdgeKubernetesCluster = exports.RosKubernetesCluster = exports.RosAnyCluster = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAnyClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosAnyClusterProps`
 *
 * @returns the result of the validation.
 */
function RosAnyClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('clusterConfig', ros.requiredValidator)(properties.clusterConfig));
    errors.collect(ros.propertyValidator('clusterConfig', ros.hashValidator(ros.validateAny))(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "RosAnyClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::AnyCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosAnyClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::AnyCluster` resource.
 */
// @ts-ignore TS6133
function rosAnyClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAnyClusterPropsValidator(properties).assertSuccess();
    }
    return {
        ClusterConfig: ros.hashMapper(ros.objectToRosTemplate)(properties.clusterConfig),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::AnyCluster`
 */
class RosAnyCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::AnyCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAnyCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = ros.Token.asString(this.getAtt('ClusterId'));
        this.attrTaskId = ros.Token.asString(this.getAtt('TaskId'));
        this.attrWorkerRamRoleName = ros.Token.asString(this.getAtt('WorkerRamRoleName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.clusterConfig = props.clusterConfig;
    }
    get rosProperties() {
        return {
            clusterConfig: this.clusterConfig,
        };
    }
    renderProperties(props) {
        return rosAnyClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAnyCluster = RosAnyCluster;
/**
 * The resource type name for this resource class.
 */
RosAnyCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::AnyCluster";
/**
 * Determine whether the given properties match those of a `RosKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    if (properties.workerPeriod && (typeof properties.workerPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('workerPeriod', ros.validateAllowedValues)({
            data: properties.workerPeriod,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60],
        }));
    }
    errors.collect(ros.propertyValidator('workerPeriod', ros.validateNumber)(properties.workerPeriod));
    if (properties.workerPeriodUnit && (typeof properties.workerPeriodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('workerPeriodUnit', ros.validateAllowedValues)({
            data: properties.workerPeriodUnit,
            allowedValues: ["Week", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('workerPeriodUnit', ros.validateString)(properties.workerPeriodUnit));
    if (properties.masterSystemDiskCategory && (typeof properties.masterSystemDiskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('masterSystemDiskCategory', ros.validateAllowedValues)({
            data: properties.masterSystemDiskCategory,
            allowedValues: ["cloud_efficiency", "cloud_ssd"],
        }));
    }
    errors.collect(ros.propertyValidator('masterSystemDiskCategory', ros.validateString)(properties.masterSystemDiskCategory));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    if (properties.masterSystemDiskSize && (typeof properties.masterSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('masterSystemDiskSize', ros.validateRange)({
            data: properties.masterSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('masterSystemDiskSize', ros.validateNumber)(properties.masterSystemDiskSize));
    errors.collect(ros.propertyValidator('workerSystemDiskCategory', ros.validateString)(properties.workerSystemDiskCategory));
    errors.collect(ros.propertyValidator('nodePortRange', ros.validateString)(properties.nodePortRange));
    if (properties.masterCount && (typeof properties.masterCount) !== 'object') {
        errors.collect(ros.propertyValidator('masterCount', ros.validateAllowedValues)({
            data: properties.masterCount,
            allowedValues: [3, 5],
        }));
    }
    errors.collect(ros.propertyValidator('masterCount', ros.validateNumber)(properties.masterCount));
    if (properties.workerSystemDiskSize && (typeof properties.workerSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateRange)({
            data: properties.workerSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateNumber)(properties.workerSystemDiskSize));
    errors.collect(ros.propertyValidator('sshFlags', ros.validateBoolean)(properties.sshFlags));
    errors.collect(ros.propertyValidator('masterVSwitchIds', ros.requiredValidator)(properties.masterVSwitchIds));
    if (properties.masterVSwitchIds && (Array.isArray(properties.masterVSwitchIds) || (typeof properties.masterVSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('masterVSwitchIds', ros.validateLength)({
            data: properties.masterVSwitchIds.length,
            min: 1,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('masterVSwitchIds', ros.listValidator(ros.validateAny))(properties.masterVSwitchIds));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('taint', ros.listValidator(ros.validateAny))(properties.taint));
    errors.collect(ros.propertyValidator('masterDataDisks', ros.listValidator(RosKubernetesCluster_MasterDataDisksPropertyValidator))(properties.masterDataDisks));
    errors.collect(ros.propertyValidator('cloudMonitorFlags', ros.validateBoolean)(properties.cloudMonitorFlags));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('workerAutoRenew', ros.validateBoolean)(properties.workerAutoRenew));
    errors.collect(ros.propertyValidator('proxyMode', ros.validateString)(properties.proxyMode));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(ros.validateRosTag))(properties.tags));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.requiredValidator)(properties.workerInstanceTypes));
    if (properties.workerInstanceTypes && (Array.isArray(properties.workerInstanceTypes) || (typeof properties.workerInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('workerInstanceTypes', ros.validateLength)({
            data: properties.workerInstanceTypes.length,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.listValidator(ros.validateAny))(properties.workerInstanceTypes));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    if (properties.masterPeriod && (typeof properties.masterPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('masterPeriod', ros.validateAllowedValues)({
            data: properties.masterPeriod,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60],
        }));
    }
    errors.collect(ros.propertyValidator('masterPeriod', ros.validateNumber)(properties.masterPeriod));
    errors.collect(ros.propertyValidator('kubernetesVersion', ros.validateString)(properties.kubernetesVersion));
    if (properties.masterInstanceChargeType && (typeof properties.masterInstanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('masterInstanceChargeType', ros.validateAllowedValues)({
            data: properties.masterInstanceChargeType,
            allowedValues: ["PrePaid", "PostPaid"],
        }));
    }
    errors.collect(ros.propertyValidator('masterInstanceChargeType', ros.validateString)(properties.masterInstanceChargeType));
    errors.collect(ros.propertyValidator('containerCidr', ros.validateString)(properties.containerCidr));
    errors.collect(ros.propertyValidator('cpuPolicy', ros.validateString)(properties.cpuPolicy));
    if (properties.workerInstanceChargeType && (typeof properties.workerInstanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('workerInstanceChargeType', ros.validateAllowedValues)({
            data: properties.workerInstanceChargeType,
            allowedValues: ["PrePaid", "PostPaid"],
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceChargeType', ros.validateString)(properties.workerInstanceChargeType));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    errors.collect(ros.propertyValidator('masterInstanceTypes', ros.requiredValidator)(properties.masterInstanceTypes));
    if (properties.masterInstanceTypes && (Array.isArray(properties.masterInstanceTypes) || (typeof properties.masterInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('masterInstanceTypes', ros.validateLength)({
            data: properties.masterInstanceTypes.length,
            min: 3,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('masterInstanceTypes', ros.listValidator(ros.validateAny))(properties.masterInstanceTypes));
    errors.collect(ros.propertyValidator('workerDataDisks', ros.listValidator(RosKubernetesCluster_WorkerDataDisksPropertyValidator))(properties.workerDataDisks));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    if (properties.masterPeriodUnit && (typeof properties.masterPeriodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('masterPeriodUnit', ros.validateAllowedValues)({
            data: properties.masterPeriodUnit,
            allowedValues: ["Week", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('masterPeriodUnit', ros.validateString)(properties.masterPeriodUnit));
    if (properties.masterAutoRenewPeriod && (typeof properties.masterAutoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('masterAutoRenewPeriod', ros.validateAllowedValues)({
            data: properties.masterAutoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12],
        }));
    }
    errors.collect(ros.propertyValidator('masterAutoRenewPeriod', ros.validateNumber)(properties.masterAutoRenewPeriod));
    errors.collect(ros.propertyValidator('workerDataDisk', ros.validateBoolean)(properties.workerDataDisk));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.numOfNodes && (typeof properties.numOfNodes) !== 'object') {
        errors.collect(ros.propertyValidator('numOfNodes', ros.validateRange)({
            data: properties.numOfNodes,
            min: 0,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('numOfNodes', ros.validateNumber)(properties.numOfNodes));
    errors.collect(ros.propertyValidator('masterAutoRenew', ros.validateBoolean)(properties.masterAutoRenew));
    if (properties.workerAutoRenewPeriod && (typeof properties.workerAutoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('workerAutoRenewPeriod', ros.validateAllowedValues)({
            data: properties.workerAutoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12],
        }));
    }
    errors.collect(ros.propertyValidator('workerAutoRenewPeriod', ros.validateNumber)(properties.workerAutoRenewPeriod));
    errors.collect(ros.propertyValidator('workerVSwitchIds', ros.requiredValidator)(properties.workerVSwitchIds));
    if (properties.workerVSwitchIds && (Array.isArray(properties.workerVSwitchIds) || (typeof properties.workerVSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('workerVSwitchIds', ros.validateLength)({
            data: properties.workerVSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerVSwitchIds', ros.listValidator(ros.validateAny))(properties.workerVSwitchIds));
    errors.collect(ros.propertyValidator('snatEntry', ros.validateBoolean)(properties.snatEntry));
    errors.collect(ros.propertyValidator('masterDataDisk', ros.validateBoolean)(properties.masterDataDisk));
    return errors.wrap('supplied properties not correct for "RosKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        MasterInstanceTypes: ros.listMapper(ros.objectToRosTemplate)(properties.masterInstanceTypes),
        MasterVSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.masterVSwitchIds),
        Name: ros.stringToRosTemplate(properties.name),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        WorkerInstanceTypes: ros.listMapper(ros.objectToRosTemplate)(properties.workerInstanceTypes),
        WorkerVSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.workerVSwitchIds),
        Addons: ros.listMapper(rosKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        CloudMonitorFlags: ros.booleanToRosTemplate(properties.cloudMonitorFlags),
        ContainerCidr: ros.stringToRosTemplate(properties.containerCidr),
        CpuPolicy: ros.stringToRosTemplate(properties.cpuPolicy),
        DisableRollback: ros.booleanToRosTemplate(properties.disableRollback),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        KubernetesVersion: ros.stringToRosTemplate(properties.kubernetesVersion),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        MasterAutoRenew: ros.booleanToRosTemplate(properties.masterAutoRenew),
        MasterAutoRenewPeriod: ros.numberToRosTemplate(properties.masterAutoRenewPeriod),
        MasterCount: ros.numberToRosTemplate(properties.masterCount),
        MasterDataDisk: ros.booleanToRosTemplate(properties.masterDataDisk),
        MasterDataDisks: ros.listMapper(rosKubernetesClusterMasterDataDisksPropertyToRosTemplate)(properties.masterDataDisks),
        MasterInstanceChargeType: ros.stringToRosTemplate(properties.masterInstanceChargeType),
        MasterPeriod: ros.numberToRosTemplate(properties.masterPeriod),
        MasterPeriodUnit: ros.stringToRosTemplate(properties.masterPeriodUnit),
        MasterSystemDiskCategory: ros.stringToRosTemplate(properties.masterSystemDiskCategory),
        MasterSystemDiskSize: ros.numberToRosTemplate(properties.masterSystemDiskSize),
        NodePortRange: ros.stringToRosTemplate(properties.nodePortRange),
        NumOfNodes: ros.numberToRosTemplate(properties.numOfNodes),
        ProxyMode: ros.stringToRosTemplate(properties.proxyMode),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        SnatEntry: ros.booleanToRosTemplate(properties.snatEntry),
        SshFlags: ros.booleanToRosTemplate(properties.sshFlags),
        Tags: ros.listMapper(ros.rosTagToRosTemplate)(properties.tags),
        Taint: ros.listMapper(ros.objectToRosTemplate)(properties.taint),
        TimeoutMins: ros.numberToRosTemplate(properties.timeoutMins),
        WorkerAutoRenew: ros.booleanToRosTemplate(properties.workerAutoRenew),
        WorkerAutoRenewPeriod: ros.numberToRosTemplate(properties.workerAutoRenewPeriod),
        WorkerDataDisk: ros.booleanToRosTemplate(properties.workerDataDisk),
        WorkerDataDisks: ros.listMapper(rosKubernetesClusterWorkerDataDisksPropertyToRosTemplate)(properties.workerDataDisks),
        WorkerInstanceChargeType: ros.stringToRosTemplate(properties.workerInstanceChargeType),
        WorkerPeriod: ros.numberToRosTemplate(properties.workerPeriod),
        WorkerPeriodUnit: ros.stringToRosTemplate(properties.workerPeriodUnit),
        WorkerSystemDiskCategory: ros.stringToRosTemplate(properties.workerSystemDiskCategory),
        WorkerSystemDiskSize: ros.numberToRosTemplate(properties.workerSystemDiskSize),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::KubernetesCluster`
 */
class RosKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::KubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = ros.Token.asString(this.getAtt('ClusterId'));
        this.attrTaskId = ros.Token.asString(this.getAtt('TaskId'));
        this.attrWorkerRamRoleName = ros.Token.asString(this.getAtt('WorkerRamRoleName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.masterInstanceTypes = props.masterInstanceTypes;
        this.masterVSwitchIds = props.masterVSwitchIds;
        this.name = props.name;
        this.vpcId = props.vpcId;
        this.workerInstanceTypes = props.workerInstanceTypes;
        this.workerVSwitchIds = props.workerVSwitchIds;
        this.addons = props.addons;
        this.cloudMonitorFlags = props.cloudMonitorFlags;
        this.containerCidr = props.containerCidr;
        this.cpuPolicy = props.cpuPolicy;
        this.disableRollback = props.disableRollback;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.keyPair = props.keyPair;
        this.kubernetesVersion = props.kubernetesVersion;
        this.loginPassword = props.loginPassword;
        this.masterAutoRenew = props.masterAutoRenew;
        this.masterAutoRenewPeriod = props.masterAutoRenewPeriod;
        this.masterCount = props.masterCount;
        this.masterDataDisk = props.masterDataDisk;
        this.masterDataDisks = props.masterDataDisks;
        this.masterInstanceChargeType = props.masterInstanceChargeType;
        this.masterPeriod = props.masterPeriod;
        this.masterPeriodUnit = props.masterPeriodUnit;
        this.masterSystemDiskCategory = props.masterSystemDiskCategory;
        this.masterSystemDiskSize = props.masterSystemDiskSize;
        this.nodePortRange = props.nodePortRange;
        this.numOfNodes = props.numOfNodes;
        this.proxyMode = props.proxyMode;
        this.securityGroupId = props.securityGroupId;
        this.serviceCidr = props.serviceCidr;
        this.snatEntry = props.snatEntry;
        this.sshFlags = props.sshFlags;
        this.tags = new ros.TagManager(ros.TagType.STANDARD, "ALIYUN::CS::KubernetesCluster", props.tags, { tagPropertyName: 'tags' });
        this.taint = props.taint;
        this.timeoutMins = props.timeoutMins;
        this.workerAutoRenew = props.workerAutoRenew;
        this.workerAutoRenewPeriod = props.workerAutoRenewPeriod;
        this.workerDataDisk = props.workerDataDisk;
        this.workerDataDisks = props.workerDataDisks;
        this.workerInstanceChargeType = props.workerInstanceChargeType;
        this.workerPeriod = props.workerPeriod;
        this.workerPeriodUnit = props.workerPeriodUnit;
        this.workerSystemDiskCategory = props.workerSystemDiskCategory;
        this.workerSystemDiskSize = props.workerSystemDiskSize;
    }
    get rosProperties() {
        return {
            masterInstanceTypes: this.masterInstanceTypes,
            masterVSwitchIds: this.masterVSwitchIds,
            name: this.name,
            vpcId: this.vpcId,
            workerInstanceTypes: this.workerInstanceTypes,
            workerVSwitchIds: this.workerVSwitchIds,
            addons: this.addons,
            cloudMonitorFlags: this.cloudMonitorFlags,
            containerCidr: this.containerCidr,
            cpuPolicy: this.cpuPolicy,
            disableRollback: this.disableRollback,
            endpointPublicAccess: this.endpointPublicAccess,
            keyPair: this.keyPair,
            kubernetesVersion: this.kubernetesVersion,
            loginPassword: this.loginPassword,
            masterAutoRenew: this.masterAutoRenew,
            masterAutoRenewPeriod: this.masterAutoRenewPeriod,
            masterCount: this.masterCount,
            masterDataDisk: this.masterDataDisk,
            masterDataDisks: this.masterDataDisks,
            masterInstanceChargeType: this.masterInstanceChargeType,
            masterPeriod: this.masterPeriod,
            masterPeriodUnit: this.masterPeriodUnit,
            masterSystemDiskCategory: this.masterSystemDiskCategory,
            masterSystemDiskSize: this.masterSystemDiskSize,
            nodePortRange: this.nodePortRange,
            numOfNodes: this.numOfNodes,
            proxyMode: this.proxyMode,
            securityGroupId: this.securityGroupId,
            serviceCidr: this.serviceCidr,
            snatEntry: this.snatEntry,
            sshFlags: this.sshFlags,
            tags: this.tags.renderTags(),
            taint: this.taint,
            timeoutMins: this.timeoutMins,
            workerAutoRenew: this.workerAutoRenew,
            workerAutoRenewPeriod: this.workerAutoRenewPeriod,
            workerDataDisk: this.workerDataDisk,
            workerDataDisks: this.workerDataDisks,
            workerInstanceChargeType: this.workerInstanceChargeType,
            workerPeriod: this.workerPeriod,
            workerPeriodUnit: this.workerPeriodUnit,
            workerSystemDiskCategory: this.workerSystemDiskCategory,
            workerSystemDiskSize: this.workerSystemDiskSize,
        };
    }
    renderProperties(props) {
        return rosKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosKubernetesCluster = RosKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::KubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('version', ros.validateString)(properties.version));
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Version: ros.stringToRosTemplate(properties.version),
        Config: ros.stringToRosTemplate(properties.config),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `MasterDataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `MasterDataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_MasterDataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.requiredValidator)(properties.category));
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('size', ros.requiredValidator)(properties.size));
    if (properties.size && (typeof properties.size) !== 'object') {
        errors.collect(ros.propertyValidator('size', ros.validateRange)({
            data: properties.size,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "MasterDataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.MasterDataDisks` resource
 *
 * @param properties - the TypeScript properties of a `MasterDataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.MasterDataDisks` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterMasterDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_MasterDataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Size: ros.numberToRosTemplate(properties.size),
    };
}
/**
 * Determine whether the given properties match those of a `WorkerDataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosKubernetesCluster_WorkerDataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.requiredValidator)(properties.category));
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('size', ros.requiredValidator)(properties.size));
    if (properties.size && (typeof properties.size) !== 'object') {
        errors.collect(ros.propertyValidator('size', ros.validateRange)({
            data: properties.size,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "WorkerDataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.WorkerDataDisks` resource
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::KubernetesCluster.WorkerDataDisks` resource.
 */
// @ts-ignore TS6133
function rosKubernetesClusterWorkerDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosKubernetesCluster_WorkerDataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Size: ros.numberToRosTemplate(properties.size),
    };
}
/**
 * Determine whether the given properties match those of a `RosManagedEdgeKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosManagedEdgeKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosManagedEdgeKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    errors.collect(ros.propertyValidator('containerCidr', ros.validateString)(properties.containerCidr));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: 5,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateAny))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    if (properties.workerSystemDiskSize && (typeof properties.workerSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateRange)({
            data: properties.workerSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateNumber)(properties.workerSystemDiskSize));
    errors.collect(ros.propertyValidator('workerSystemDiskCategory', ros.validateString)(properties.workerSystemDiskCategory));
    errors.collect(ros.propertyValidator('profile', ros.validateString)(properties.profile));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('workerDataDisk', ros.validateBoolean)(properties.workerDataDisk));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.workerDataDiskSize && (typeof properties.workerDataDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerDataDiskSize', ros.validateRange)({
            data: properties.workerDataDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerDataDiskSize', ros.validateNumber)(properties.workerDataDiskSize));
    errors.collect(ros.propertyValidator('numOfNodes', ros.requiredValidator)(properties.numOfNodes));
    if (properties.numOfNodes && (typeof properties.numOfNodes) !== 'object') {
        errors.collect(ros.propertyValidator('numOfNodes', ros.validateRange)({
            data: properties.numOfNodes,
            min: 0,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('numOfNodes', ros.validateNumber)(properties.numOfNodes));
    errors.collect(ros.propertyValidator('cloudMonitorFlags', ros.validateBoolean)(properties.cloudMonitorFlags));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('workerDataDiskCategory', ros.validateString)(properties.workerDataDiskCategory));
    errors.collect(ros.propertyValidator('snatEntry', ros.validateBoolean)(properties.snatEntry));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(ros.validateRosTag))(properties.tags));
    errors.collect(ros.propertyValidator('proxyMode', ros.validateString)(properties.proxyMode));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    return errors.wrap('supplied properties not correct for "RosManagedEdgeKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosManagedEdgeKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedEdgeKubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosManagedEdgeKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosManagedEdgeKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        NumOfNodes: ros.numberToRosTemplate(properties.numOfNodes),
        CloudMonitorFlags: ros.booleanToRosTemplate(properties.cloudMonitorFlags),
        ContainerCidr: ros.stringToRosTemplate(properties.containerCidr),
        DisableRollback: ros.booleanToRosTemplate(properties.disableRollback),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        Profile: ros.stringToRosTemplate(properties.profile),
        ProxyMode: ros.stringToRosTemplate(properties.proxyMode),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        SnatEntry: ros.booleanToRosTemplate(properties.snatEntry),
        Tags: ros.listMapper(ros.rosTagToRosTemplate)(properties.tags),
        TimeoutMins: ros.numberToRosTemplate(properties.timeoutMins),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitchIds),
        WorkerDataDisk: ros.booleanToRosTemplate(properties.workerDataDisk),
        WorkerDataDiskCategory: ros.stringToRosTemplate(properties.workerDataDiskCategory),
        WorkerDataDiskSize: ros.numberToRosTemplate(properties.workerDataDiskSize),
        WorkerSystemDiskCategory: ros.stringToRosTemplate(properties.workerSystemDiskCategory),
        WorkerSystemDiskSize: ros.numberToRosTemplate(properties.workerSystemDiskSize),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ManagedEdgeKubernetesCluster`
 */
class RosManagedEdgeKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ManagedEdgeKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosManagedEdgeKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = ros.Token.asString(this.getAtt('ClusterId'));
        this.attrTaskId = ros.Token.asString(this.getAtt('TaskId'));
        this.attrWorkerRamRoleName = ros.Token.asString(this.getAtt('WorkerRamRoleName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.numOfNodes = props.numOfNodes;
        this.cloudMonitorFlags = props.cloudMonitorFlags;
        this.containerCidr = props.containerCidr;
        this.disableRollback = props.disableRollback;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.keyPair = props.keyPair;
        this.loginPassword = props.loginPassword;
        this.profile = props.profile;
        this.proxyMode = props.proxyMode;
        this.serviceCidr = props.serviceCidr;
        this.snatEntry = props.snatEntry;
        this.tags = new ros.TagManager(ros.TagType.STANDARD, "ALIYUN::CS::ManagedEdgeKubernetesCluster", props.tags, { tagPropertyName: 'tags' });
        this.timeoutMins = props.timeoutMins;
        this.vpcId = props.vpcId;
        this.vSwitchIds = props.vSwitchIds;
        this.workerDataDisk = props.workerDataDisk;
        this.workerDataDiskCategory = props.workerDataDiskCategory;
        this.workerDataDiskSize = props.workerDataDiskSize;
        this.workerSystemDiskCategory = props.workerSystemDiskCategory;
        this.workerSystemDiskSize = props.workerSystemDiskSize;
    }
    get rosProperties() {
        return {
            name: this.name,
            numOfNodes: this.numOfNodes,
            cloudMonitorFlags: this.cloudMonitorFlags,
            containerCidr: this.containerCidr,
            disableRollback: this.disableRollback,
            endpointPublicAccess: this.endpointPublicAccess,
            keyPair: this.keyPair,
            loginPassword: this.loginPassword,
            profile: this.profile,
            proxyMode: this.proxyMode,
            serviceCidr: this.serviceCidr,
            snatEntry: this.snatEntry,
            tags: this.tags.renderTags(),
            timeoutMins: this.timeoutMins,
            vpcId: this.vpcId,
            vSwitchIds: this.vSwitchIds,
            workerDataDisk: this.workerDataDisk,
            workerDataDiskCategory: this.workerDataDiskCategory,
            workerDataDiskSize: this.workerDataDiskSize,
            workerSystemDiskCategory: this.workerSystemDiskCategory,
            workerSystemDiskSize: this.workerSystemDiskSize,
        };
    }
    renderProperties(props) {
        return rosManagedEdgeKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosManagedEdgeKubernetesCluster = RosManagedEdgeKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosManagedEdgeKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ManagedEdgeKubernetesCluster";
/**
 * Determine whether the given properties match those of a `RosManagedKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosManagedKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    if (properties.workerPeriod && (typeof properties.workerPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('workerPeriod', ros.validateAllowedValues)({
            data: properties.workerPeriod,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60],
        }));
    }
    errors.collect(ros.propertyValidator('workerPeriod', ros.validateNumber)(properties.workerPeriod));
    if (properties.workerPeriodUnit && (typeof properties.workerPeriodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('workerPeriodUnit', ros.validateAllowedValues)({
            data: properties.workerPeriodUnit,
            allowedValues: ["Week", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('workerPeriodUnit', ros.validateString)(properties.workerPeriodUnit));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosManagedKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    errors.collect(ros.propertyValidator('workerSystemDiskCategory', ros.validateString)(properties.workerSystemDiskCategory));
    if (properties.workerSystemDiskSize && (typeof properties.workerSystemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateRange)({
            data: properties.workerSystemDiskSize,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('workerSystemDiskSize', ros.validateNumber)(properties.workerSystemDiskSize));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('taint', ros.listValidator(ros.validateAny))(properties.taint));
    errors.collect(ros.propertyValidator('cloudMonitorFlags', ros.validateBoolean)(properties.cloudMonitorFlags));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('workerAutoRenew', ros.validateBoolean)(properties.workerAutoRenew));
    errors.collect(ros.propertyValidator('proxyMode', ros.validateString)(properties.proxyMode));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(ros.validateRosTag))(properties.tags));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.requiredValidator)(properties.workerInstanceTypes));
    if (properties.workerInstanceTypes && (Array.isArray(properties.workerInstanceTypes) || (typeof properties.workerInstanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('workerInstanceTypes', ros.validateLength)({
            data: properties.workerInstanceTypes.length,
            min: 1,
            max: 5,
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceTypes', ros.listValidator(ros.validateAny))(properties.workerInstanceTypes));
    errors.collect(ros.propertyValidator('loginPassword', ros.validateString)(properties.loginPassword));
    errors.collect(ros.propertyValidator('kubernetesVersion', ros.validateString)(properties.kubernetesVersion));
    errors.collect(ros.propertyValidator('containerCidr', ros.validateString)(properties.containerCidr));
    errors.collect(ros.propertyValidator('keyPair', ros.validateString)(properties.keyPair));
    if (properties.workerInstanceChargeType && (typeof properties.workerInstanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('workerInstanceChargeType', ros.validateAllowedValues)({
            data: properties.workerInstanceChargeType,
            allowedValues: ["PrePaid", "PostPaid"],
        }));
    }
    errors.collect(ros.propertyValidator('workerInstanceChargeType', ros.validateString)(properties.workerInstanceChargeType));
    errors.collect(ros.propertyValidator('vSwitchIds', ros.requiredValidator)(properties.vSwitchIds));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateAny))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('workerDataDisks', ros.listValidator(RosManagedKubernetesCluster_WorkerDataDisksPropertyValidator))(properties.workerDataDisks));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    errors.collect(ros.propertyValidator('workerDataDisk', ros.validateBoolean)(properties.workerDataDisk));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.numOfNodes && (typeof properties.numOfNodes) !== 'object') {
        errors.collect(ros.propertyValidator('numOfNodes', ros.validateRange)({
            data: properties.numOfNodes,
            min: 2,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('numOfNodes', ros.validateNumber)(properties.numOfNodes));
    if (properties.workerAutoRenewPeriod && (typeof properties.workerAutoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('workerAutoRenewPeriod', ros.validateAllowedValues)({
            data: properties.workerAutoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12],
        }));
    }
    errors.collect(ros.propertyValidator('workerAutoRenewPeriod', ros.validateNumber)(properties.workerAutoRenewPeriod));
    errors.collect(ros.propertyValidator('snatEntry', ros.validateBoolean)(properties.snatEntry));
    return errors.wrap('supplied properties not correct for "RosManagedKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosManagedKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosManagedKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitchIds),
        WorkerInstanceTypes: ros.listMapper(ros.objectToRosTemplate)(properties.workerInstanceTypes),
        Addons: ros.listMapper(rosManagedKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        CloudMonitorFlags: ros.booleanToRosTemplate(properties.cloudMonitorFlags),
        ContainerCidr: ros.stringToRosTemplate(properties.containerCidr),
        DisableRollback: ros.booleanToRosTemplate(properties.disableRollback),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        KeyPair: ros.stringToRosTemplate(properties.keyPair),
        KubernetesVersion: ros.stringToRosTemplate(properties.kubernetesVersion),
        LoginPassword: ros.stringToRosTemplate(properties.loginPassword),
        NumOfNodes: ros.numberToRosTemplate(properties.numOfNodes),
        ProxyMode: ros.stringToRosTemplate(properties.proxyMode),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        SnatEntry: ros.booleanToRosTemplate(properties.snatEntry),
        Tags: ros.listMapper(ros.rosTagToRosTemplate)(properties.tags),
        Taint: ros.listMapper(ros.objectToRosTemplate)(properties.taint),
        TimeoutMins: ros.numberToRosTemplate(properties.timeoutMins),
        WorkerAutoRenew: ros.booleanToRosTemplate(properties.workerAutoRenew),
        WorkerAutoRenewPeriod: ros.numberToRosTemplate(properties.workerAutoRenewPeriod),
        WorkerDataDisk: ros.booleanToRosTemplate(properties.workerDataDisk),
        WorkerDataDisks: ros.listMapper(rosManagedKubernetesClusterWorkerDataDisksPropertyToRosTemplate)(properties.workerDataDisks),
        WorkerInstanceChargeType: ros.stringToRosTemplate(properties.workerInstanceChargeType),
        WorkerPeriod: ros.numberToRosTemplate(properties.workerPeriod),
        WorkerPeriodUnit: ros.stringToRosTemplate(properties.workerPeriodUnit),
        WorkerSystemDiskCategory: ros.stringToRosTemplate(properties.workerSystemDiskCategory),
        WorkerSystemDiskSize: ros.numberToRosTemplate(properties.workerSystemDiskSize),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ManagedKubernetesCluster`
 */
class RosManagedKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ManagedKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosManagedKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = ros.Token.asString(this.getAtt('ClusterId'));
        this.attrTaskId = ros.Token.asString(this.getAtt('TaskId'));
        this.attrWorkerRamRoleName = ros.Token.asString(this.getAtt('WorkerRamRoleName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.vpcId = props.vpcId;
        this.vSwitchIds = props.vSwitchIds;
        this.workerInstanceTypes = props.workerInstanceTypes;
        this.addons = props.addons;
        this.cloudMonitorFlags = props.cloudMonitorFlags;
        this.containerCidr = props.containerCidr;
        this.disableRollback = props.disableRollback;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.keyPair = props.keyPair;
        this.kubernetesVersion = props.kubernetesVersion;
        this.loginPassword = props.loginPassword;
        this.numOfNodes = props.numOfNodes;
        this.proxyMode = props.proxyMode;
        this.securityGroupId = props.securityGroupId;
        this.serviceCidr = props.serviceCidr;
        this.snatEntry = props.snatEntry;
        this.tags = new ros.TagManager(ros.TagType.STANDARD, "ALIYUN::CS::ManagedKubernetesCluster", props.tags, { tagPropertyName: 'tags' });
        this.taint = props.taint;
        this.timeoutMins = props.timeoutMins;
        this.workerAutoRenew = props.workerAutoRenew;
        this.workerAutoRenewPeriod = props.workerAutoRenewPeriod;
        this.workerDataDisk = props.workerDataDisk;
        this.workerDataDisks = props.workerDataDisks;
        this.workerInstanceChargeType = props.workerInstanceChargeType;
        this.workerPeriod = props.workerPeriod;
        this.workerPeriodUnit = props.workerPeriodUnit;
        this.workerSystemDiskCategory = props.workerSystemDiskCategory;
        this.workerSystemDiskSize = props.workerSystemDiskSize;
    }
    get rosProperties() {
        return {
            name: this.name,
            vpcId: this.vpcId,
            vSwitchIds: this.vSwitchIds,
            workerInstanceTypes: this.workerInstanceTypes,
            addons: this.addons,
            cloudMonitorFlags: this.cloudMonitorFlags,
            containerCidr: this.containerCidr,
            disableRollback: this.disableRollback,
            endpointPublicAccess: this.endpointPublicAccess,
            keyPair: this.keyPair,
            kubernetesVersion: this.kubernetesVersion,
            loginPassword: this.loginPassword,
            numOfNodes: this.numOfNodes,
            proxyMode: this.proxyMode,
            securityGroupId: this.securityGroupId,
            serviceCidr: this.serviceCidr,
            snatEntry: this.snatEntry,
            tags: this.tags.renderTags(),
            taint: this.taint,
            timeoutMins: this.timeoutMins,
            workerAutoRenew: this.workerAutoRenew,
            workerAutoRenewPeriod: this.workerAutoRenewPeriod,
            workerDataDisk: this.workerDataDisk,
            workerDataDisks: this.workerDataDisks,
            workerInstanceChargeType: this.workerInstanceChargeType,
            workerPeriod: this.workerPeriod,
            workerPeriodUnit: this.workerPeriodUnit,
            workerSystemDiskCategory: this.workerSystemDiskCategory,
            workerSystemDiskSize: this.workerSystemDiskSize,
        };
    }
    renderProperties(props) {
        return rosManagedKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosManagedKubernetesCluster = RosManagedKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosManagedKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ManagedKubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('version', ros.validateString)(properties.version));
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Version: ros.stringToRosTemplate(properties.version),
        Config: ros.stringToRosTemplate(properties.config),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `WorkerDataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosManagedKubernetesCluster_WorkerDataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('category', ros.requiredValidator)(properties.category));
    errors.collect(ros.propertyValidator('category', ros.validateString)(properties.category));
    errors.collect(ros.propertyValidator('size', ros.requiredValidator)(properties.size));
    if (properties.size && (typeof properties.size) !== 'object') {
        errors.collect(ros.propertyValidator('size', ros.validateRange)({
            data: properties.size,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('size', ros.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "WorkerDataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.WorkerDataDisks` resource
 *
 * @param properties - the TypeScript properties of a `WorkerDataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ManagedKubernetesCluster.WorkerDataDisks` resource.
 */
// @ts-ignore TS6133
function rosManagedKubernetesClusterWorkerDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosManagedKubernetesCluster_WorkerDataDisksPropertyValidator(properties).assertSuccess();
    return {
        Category: ros.stringToRosTemplate(properties.category),
        Size: ros.numberToRosTemplate(properties.size),
    };
}
/**
 * Determine whether the given properties match those of a `RosServerlessKubernetesClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosServerlessKubernetesClusterProps`
 *
 * @returns the result of the validation.
 */
function RosServerlessKubernetesClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('kubernetesVersion', ros.validateString)(properties.kubernetesVersion));
    errors.collect(ros.propertyValidator('endpointPublicAccess', ros.validateBoolean)(properties.endpointPublicAccess));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    if (properties.vSwitchIds && (Array.isArray(properties.vSwitchIds) || (typeof properties.vSwitchIds) === 'string')) {
        errors.collect(ros.propertyValidator('vSwitchIds', ros.validateLength)({
            data: properties.vSwitchIds.length,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('vSwitchIds', ros.listValidator(ros.validateAny))(properties.vSwitchIds));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('addons', ros.listValidator(RosServerlessKubernetesCluster_AddonsPropertyValidator))(properties.addons));
    errors.collect(ros.propertyValidator('natGateway', ros.validateBoolean)(properties.natGateway));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('serviceCidr', ros.validateString)(properties.serviceCidr));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(ros.validateRosTag))(properties.tags));
    errors.collect(ros.propertyValidator('privateZone', ros.validateBoolean)(properties.privateZone));
    return errors.wrap('supplied properties not correct for "RosServerlessKubernetesClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosServerlessKubernetesClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster` resource.
 */
// @ts-ignore TS6133
function rosServerlessKubernetesClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosServerlessKubernetesClusterPropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        Addons: ros.listMapper(rosServerlessKubernetesClusterAddonsPropertyToRosTemplate)(properties.addons),
        EndpointPublicAccess: ros.booleanToRosTemplate(properties.endpointPublicAccess),
        KubernetesVersion: ros.stringToRosTemplate(properties.kubernetesVersion),
        NatGateway: ros.booleanToRosTemplate(properties.natGateway),
        PrivateZone: ros.booleanToRosTemplate(properties.privateZone),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        ServiceCidr: ros.stringToRosTemplate(properties.serviceCidr),
        Tags: ros.listMapper(ros.rosTagToRosTemplate)(properties.tags),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        VSwitchIds: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitchIds),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CS::ServerlessKubernetesCluster`
 */
class RosServerlessKubernetesCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CS::ServerlessKubernetesCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosServerlessKubernetesCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = ros.Token.asString(this.getAtt('ClusterId'));
        this.attrTaskId = ros.Token.asString(this.getAtt('TaskId'));
        this.attrWorkerRamRoleName = ros.Token.asString(this.getAtt('WorkerRamRoleName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.addons = props.addons;
        this.endpointPublicAccess = props.endpointPublicAccess;
        this.kubernetesVersion = props.kubernetesVersion;
        this.natGateway = props.natGateway;
        this.privateZone = props.privateZone;
        this.securityGroupId = props.securityGroupId;
        this.serviceCidr = props.serviceCidr;
        this.tags = new ros.TagManager(ros.TagType.STANDARD, "ALIYUN::CS::ServerlessKubernetesCluster", props.tags, { tagPropertyName: 'tags' });
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.vSwitchIds = props.vSwitchIds;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            name: this.name,
            addons: this.addons,
            endpointPublicAccess: this.endpointPublicAccess,
            kubernetesVersion: this.kubernetesVersion,
            natGateway: this.natGateway,
            privateZone: this.privateZone,
            securityGroupId: this.securityGroupId,
            serviceCidr: this.serviceCidr,
            tags: this.tags.renderTags(),
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            vSwitchIds: this.vSwitchIds,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosServerlessKubernetesClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosServerlessKubernetesCluster = RosServerlessKubernetesCluster;
/**
 * The resource type name for this resource class.
 */
RosServerlessKubernetesCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CS::ServerlessKubernetesCluster";
/**
 * Determine whether the given properties match those of a `AddonsProperty`
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the result of the validation.
 */
function RosServerlessKubernetesCluster_AddonsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('config', ros.validateString)(properties.config));
    errors.collect(ros.propertyValidator('disabled', ros.validateString)(properties.disabled));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "AddonsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster.Addons` resource
 *
 * @param properties - the TypeScript properties of a `AddonsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CS::ServerlessKubernetesCluster.Addons` resource.
 */
// @ts-ignore TS6133
function rosServerlessKubernetesClusterAddonsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServerlessKubernetesCluster_AddonsPropertyValidator(properties).assertSuccess();
    return {
        Config: ros.stringToRosTemplate(properties.config),
        Disabled: ros.stringToRosTemplate(properties.disabled),
        Name: ros.stringToRosTemplate(properties.name),
    };
}
//# sourceMappingURL=data:application/json;base64,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