"""Top-level package for seaborn_extensions."""

from outdated import warn_if_outdated

try:
    # Even though there is no "../_version" file,
    # it should be generated by
    # setuptools_scm when building the package
    from seaborn_extensions._version import __version__

    version = __version__
except ImportError:
    from setuptools_scm import get_version as _get_version

    version = __version__ = _get_version(root="..", relative_to=__file__)

__author__ = """Andre Rendeiro"""
__email__ = "afrendeiro@gmail.com"


warn_if_outdated("seaborn-extensions", __version__)


DEFAULT_CHANNEL_COLORS = [
    "red",
    "green",
    "blue",
    "orange",
    "purple",
    "brown",
    "pink",
    "olive",
    "cyan",
    "gray",
]

SEQUENCIAL_CMAPS = [
    "Purples",
    "Greens",
    "Oranges",
    "Greys",
    "Reds",
    "Blues",
    "YlOrBr",
    "YlOrRd",
    "OrRd",
    "PuRd",
    "RdPu",
    "BuPu",
    "GnBu",
    "PuBu",
    "YlGnBu",
    "PuBuGn",
    "BuGn",
    "YlGn",
    "binary",
    "gist_yarg",
    "gist_gray",
    "gray",
    "bone",
    "pink",
    "spring",
    "summer",
    "autumn",
    "winter",
    "cool",
    "Wistia",
    "hot",
    "afmhot",
    "gist_heat",
    "copper",
]


from seaborn_extensions.swarmboxenplot import swarmboxenplot
from seaborn_extensions.annotated_clustermap import (
    activate as activate_annotated_clustermap,
    clustermap,
)
from seaborn_extensions.volcano import volcano_plot
from seaborn_extensions.rankplot import rankplot
