"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnS3Bucket = exports.toJson_SseKmsEncryptedObjectsDefinition = exports.toJson_TagsDefinition3 = exports.toJson_AccessControlTranslationDefinition = exports.toJson_SourceSelectionCriteriaDefinition = exports.toJson_FilterDefinition = exports.toJson_DestinationDefinition = exports.toJson_ApplyServerSideEncryptionByDefaultDefinition = exports.toJson_RulesDefinition = exports.toJson_RuleDefinition = exports.toJson_TransitionDefinition = exports.toJson_NoncurrentVersionTransitionDefinition = exports.toJson_NoncurrentVersionExpirationDefinition = exports.toJson_ExpirationDefinition = exports.toJson_TagsDefinition2 = exports.toJson_WebsiteDefinition = exports.toJson_VersioningDefinition = exports.toJson_ServerSideEncryptionConfigurationDefinition = exports.toJson_ReplicationConfigurationDefinition = exports.toJson_ObjectLockConfigurationDefinition = exports.toJson_LoggingDefinition = exports.toJson_LifecycleRuleDefinition = exports.toJson_GrantDefinition = exports.toJson_CorsRuleDefinition = exports.toJson_TagsAllDefinition = exports.toJson_TagsDefinition = exports.toJson_CfnS3BucketProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnS3BucketProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnS3BucketProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccelerationStatus': obj.accelerationStatus,
        'Acl': obj.acl,
        'Arn': obj.arn,
        'Bucket': obj.bucket,
        'BucketPrefix': obj.bucketPrefix,
        'ForceDestroy': obj.forceDestroy,
        'HostedZoneId': obj.hostedZoneId,
        'Policy': obj.policy,
        'RequestPayer': obj.requestPayer,
        'Tags': obj.tags?.map(y => toJson_TagsDefinition(y)),
        'TagsAll': obj.tagsAll?.map(y => toJson_TagsAllDefinition(y)),
        'WebsiteDomain': obj.websiteDomain,
        'WebsiteEndpoint': obj.websiteEndpoint,
        'CorsRule': obj.corsRule?.map(y => toJson_CorsRuleDefinition(y)),
        'Grant': obj.grant?.map(y => toJson_GrantDefinition(y)),
        'LifecycleRule': obj.lifecycleRule?.map(y => toJson_LifecycleRuleDefinition(y)),
        'Logging': obj.logging?.map(y => toJson_LoggingDefinition(y)),
        'ObjectLockConfiguration': obj.objectLockConfiguration?.map(y => toJson_ObjectLockConfigurationDefinition(y)),
        'ReplicationConfiguration': obj.replicationConfiguration?.map(y => toJson_ReplicationConfigurationDefinition(y)),
        'ServerSideEncryptionConfiguration': obj.serverSideEncryptionConfiguration?.map(y => toJson_ServerSideEncryptionConfigurationDefinition(y)),
        'Versioning': obj.versioning?.map(y => toJson_VersioningDefinition(y)),
        'Website': obj.website?.map(y => toJson_WebsiteDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnS3BucketProps = toJson_CfnS3BucketProps;
/**
 * Converts an object of type 'TagsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsDefinition = toJson_TagsDefinition;
/**
 * Converts an object of type 'TagsAllDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsAllDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsAllDefinition = toJson_TagsAllDefinition;
/**
 * Converts an object of type 'CorsRuleDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CorsRuleDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AllowedHeaders': obj.allowedHeaders?.map(y => y),
        'AllowedMethods': obj.allowedMethods?.map(y => y),
        'AllowedOrigins': obj.allowedOrigins?.map(y => y),
        'ExposeHeaders': obj.exposeHeaders?.map(y => y),
        'MaxAgeSeconds': obj.maxAgeSeconds,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CorsRuleDefinition = toJson_CorsRuleDefinition;
/**
 * Converts an object of type 'GrantDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_GrantDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
        'Permissions': obj.permissions?.map(y => y),
        'Type': obj.type,
        'Uri': obj.uri,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_GrantDefinition = toJson_GrantDefinition;
/**
 * Converts an object of type 'LifecycleRuleDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_LifecycleRuleDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AbortIncompleteMultipartUploadDays': obj.abortIncompleteMultipartUploadDays,
        'Enabled': obj.enabled,
        'Id': obj.id,
        'Prefix': obj.prefix,
        'Tags': obj.tags?.map(y => toJson_TagsDefinition2(y)),
        'Expiration': obj.expiration?.map(y => toJson_ExpirationDefinition(y)),
        'NoncurrentVersionExpiration': obj.noncurrentVersionExpiration?.map(y => toJson_NoncurrentVersionExpirationDefinition(y)),
        'NoncurrentVersionTransition': obj.noncurrentVersionTransition?.map(y => toJson_NoncurrentVersionTransitionDefinition(y)),
        'Transition': obj.transition?.map(y => toJson_TransitionDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_LifecycleRuleDefinition = toJson_LifecycleRuleDefinition;
/**
 * Converts an object of type 'LoggingDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_LoggingDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'TargetBucket': obj.targetBucket,
        'TargetPrefix': obj.targetPrefix,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_LoggingDefinition = toJson_LoggingDefinition;
/**
 * Converts an object of type 'ObjectLockConfigurationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ObjectLockConfigurationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ObjectLockEnabled': obj.objectLockEnabled,
        'Rule': obj.rule?.map(y => toJson_RuleDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ObjectLockConfigurationDefinition = toJson_ObjectLockConfigurationDefinition;
/**
 * Converts an object of type 'ReplicationConfigurationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ReplicationConfigurationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Role': obj.role,
        'Rules': obj.rules?.map(y => toJson_RulesDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ReplicationConfigurationDefinition = toJson_ReplicationConfigurationDefinition;
/**
 * Converts an object of type 'ServerSideEncryptionConfigurationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ServerSideEncryptionConfigurationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Rule': obj.rule?.map(y => toJson_RuleDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ServerSideEncryptionConfigurationDefinition = toJson_ServerSideEncryptionConfigurationDefinition;
/**
 * Converts an object of type 'VersioningDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_VersioningDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
        'MfaDelete': obj.mfaDelete,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_VersioningDefinition = toJson_VersioningDefinition;
/**
 * Converts an object of type 'WebsiteDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_WebsiteDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ErrorDocument': obj.errorDocument,
        'IndexDocument': obj.indexDocument,
        'RedirectAllRequestsTo': obj.redirectAllRequestsTo,
        'RoutingRules': obj.routingRules,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_WebsiteDefinition = toJson_WebsiteDefinition;
/**
 * Converts an object of type 'TagsDefinition2' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsDefinition2(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsDefinition2 = toJson_TagsDefinition2;
/**
 * Converts an object of type 'ExpirationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ExpirationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Date': obj.date,
        'Days': obj.days,
        'ExpiredObjectDeleteMarker': obj.expiredObjectDeleteMarker,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ExpirationDefinition = toJson_ExpirationDefinition;
/**
 * Converts an object of type 'NoncurrentVersionExpirationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_NoncurrentVersionExpirationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Days': obj.days,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_NoncurrentVersionExpirationDefinition = toJson_NoncurrentVersionExpirationDefinition;
/**
 * Converts an object of type 'NoncurrentVersionTransitionDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_NoncurrentVersionTransitionDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Days': obj.days,
        'StorageClass': obj.storageClass,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_NoncurrentVersionTransitionDefinition = toJson_NoncurrentVersionTransitionDefinition;
/**
 * Converts an object of type 'TransitionDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TransitionDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Date': obj.date,
        'Days': obj.days,
        'StorageClass': obj.storageClass,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TransitionDefinition = toJson_TransitionDefinition;
/**
 * Converts an object of type 'RuleDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RuleDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'BucketKeyEnabled': obj.bucketKeyEnabled,
        'ApplyServerSideEncryptionByDefault': obj.applyServerSideEncryptionByDefault?.map(y => toJson_ApplyServerSideEncryptionByDefaultDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RuleDefinition = toJson_RuleDefinition;
/**
 * Converts an object of type 'RulesDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RulesDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
        'Prefix': obj.prefix,
        'Priority': obj.priority,
        'Status': obj.status,
        'Destination': obj.destination?.map(y => toJson_DestinationDefinition(y)),
        'Filter': obj.filter?.map(y => toJson_FilterDefinition(y)),
        'SourceSelectionCriteria': obj.sourceSelectionCriteria?.map(y => toJson_SourceSelectionCriteriaDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RulesDefinition = toJson_RulesDefinition;
/**
 * Converts an object of type 'ApplyServerSideEncryptionByDefaultDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ApplyServerSideEncryptionByDefaultDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'KmsMasterKeyId': obj.kmsMasterKeyId,
        'SseAlgorithm': obj.sseAlgorithm,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ApplyServerSideEncryptionByDefaultDefinition = toJson_ApplyServerSideEncryptionByDefaultDefinition;
/**
 * Converts an object of type 'DestinationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_DestinationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountId': obj.accountId,
        'Bucket': obj.bucket,
        'ReplicaKmsKeyId': obj.replicaKmsKeyId,
        'StorageClass': obj.storageClass,
        'AccessControlTranslation': obj.accessControlTranslation?.map(y => toJson_AccessControlTranslationDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_DestinationDefinition = toJson_DestinationDefinition;
/**
 * Converts an object of type 'FilterDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_FilterDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Prefix': obj.prefix,
        'Tags': obj.tags?.map(y => toJson_TagsDefinition3(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_FilterDefinition = toJson_FilterDefinition;
/**
 * Converts an object of type 'SourceSelectionCriteriaDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SourceSelectionCriteriaDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SseKmsEncryptedObjects': obj.sseKmsEncryptedObjects?.map(y => toJson_SseKmsEncryptedObjectsDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SourceSelectionCriteriaDefinition = toJson_SourceSelectionCriteriaDefinition;
/**
 * Converts an object of type 'AccessControlTranslationDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AccessControlTranslationDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Owner': obj.owner,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AccessControlTranslationDefinition = toJson_AccessControlTranslationDefinition;
/**
 * Converts an object of type 'TagsDefinition3' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsDefinition3(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsDefinition3 = toJson_TagsDefinition3;
/**
 * Converts an object of type 'SseKmsEncryptedObjectsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SseKmsEncryptedObjectsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SseKmsEncryptedObjectsDefinition = toJson_SseKmsEncryptedObjectsDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AWS::S3Bucket`
 *
 * @cloudformationResource TF::AWS::S3Bucket
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnS3Bucket extends cdk.CfnResource {
    /**
     * Create a new `TF::AWS::S3Bucket`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnS3Bucket.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnS3BucketProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrBucketDomainName = cdk.Token.asString(this.getAtt('BucketDomainName'));
        this.attrBucketRegionalDomainName = cdk.Token.asString(this.getAtt('BucketRegionalDomainName'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrRegion = cdk.Token.asString(this.getAtt('Region'));
    }
}
exports.CfnS3Bucket = CfnS3Bucket;
_a = JSII_RTTI_SYMBOL_1;
CfnS3Bucket[_a] = { fqn: "@cdk-cloudformation/tf-aws-s3bucket.CfnS3Bucket", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnS3Bucket.CFN_RESOURCE_TYPE_NAME = "TF::AWS::S3Bucket";
//# sourceMappingURL=data:application/json;base64,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