# Generated by Django 4.1.5 on 2023-02-06 10:39

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    dependencies = [
        ('extras', '0084_staging'),
        ('dcim', '0167_module_status'),
        ('inventory_monitor', '0006_invoice_project'),
    ]

    operations = [
        migrations.CreateModel(
            name='Component',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('serial', models.CharField(max_length=255)),
                ('serial_actual', models.CharField(max_length=255)),
                ('partnumber', models.CharField(blank=True, max_length=64, null=True)),
                ('inventory', models.CharField(blank=True, max_length=255, null=True)),
                ('project', models.CharField(blank=True, max_length=32, null=True)),
                ('vendor', models.CharField(blank=True, max_length=32, null=True)),
                ('items', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1)])),
                ('price', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=19, null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('warranty_start', models.DateField(blank=True, null=True)),
                ('warranty_end', models.DateField(blank=True, null=True)),
                ('comments', models.TextField(blank=True)),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='components', to='dcim.device')),
                ('locality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='components', to='dcim.site')),
            ],
            options={
                'ordering': ('serial', 'serial_actual', 'partnumber', 'device', 'inventory', 'project', 'locality', 'vendor', 'items', 'price', 'order_contract', 'warranty_start', 'warranty_end'),
            },
        ),
        migrations.AlterField(
            model_name='contract',
            name='custom_field_data',
            field=models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
        ),
        migrations.AlterField(
            model_name='contractor',
            name='custom_field_data',
            field=models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
        ),
        migrations.AlterField(
            model_name='invoice',
            name='custom_field_data',
            field=models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
        ),
        migrations.AlterField(
            model_name='probe',
            name='custom_field_data',
            field=models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
        ),
        migrations.CreateModel(
            name='ComponentService',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('service_start', models.DateField(blank=True, null=True)),
                ('service_end', models.DateField(blank=True, null=True)),
                ('service_param', models.CharField(blank=True, max_length=32, null=True)),
                ('service_price', models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=12, null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('service_category', models.CharField(blank=True, max_length=255, null=True)),
                ('service_category_vendor', models.CharField(blank=True, max_length=255, null=True)),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='services', to='inventory_monitor.component')),
                ('contract', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='services', to='inventory_monitor.contract')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('service_start', 'service_end', 'service_param', 'service_price', 'service_category', 'service_category_vendor', 'component', 'contract'),
            },
        ),
        migrations.AddField(
            model_name='component',
            name='order_contract',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='components', to='inventory_monitor.contract'),
        ),
        migrations.AddField(
            model_name='component',
            name='tags',
            field=taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag'),
        ),
    ]
