"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) { return new Cpu(unit); }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.70.0-alpha.0" };
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) { return new Memory(unit); }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.70.0-alpha.0" };
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.70.0-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.70.0-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.70.0-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.70.0-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.70.0-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.70.0-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    constructor(arn) {
        this.connectionArn = arn;
    }
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.70.0-alpha.0" };
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
exports.Secret = Secret;
_k = JSII_RTTI_SYMBOL_1;
Secret[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.70.0-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.instanceRole = this.props.instanceRole;
        const environmentVariables = this.getEnvironmentVariables();
        const environmentSecrets = this.getEnvironmentSecrets();
        for (const [key, value] of Object.entries(environmentVariables)) {
            this.addEnvironmentVariable(key, value);
        }
        for (const [key, value] of Object.entries(environmentSecrets)) {
            this.addSecret(key, value);
        }
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.instanceRole?.roleArn }),
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
            },
        });
        // grant required privileges for the role
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment variable key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment secret key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        if (!this.instanceRole) {
            this.instanceRole = this.createInstanceRole();
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new Error([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '));
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
            runtimeEnvironmentSecrets: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (this.variables.length > 0) {
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (this.secrets.length > 0 && this.instanceRole) {
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
                runtimeEnvironmentSecrets: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            },
        });
    }
}
exports.Service = Service;
_l = JSII_RTTI_SYMBOL_1;
Service[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.70.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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