/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import ch.javasoft.xml.config.XmlConfigException;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlArgException
extends XmlConfigException {
    public static final String ARG = "arg";
    private static final long serialVersionUID = 1L;
    private final String mOption;
    private final int mArgIndex;

    public XmlArgException(int argIndex, String message, Element path) {
        this(ARG, argIndex, message, path);
    }

    public XmlArgException(String option, String message, Element path) {
        this(option, 0, message, path);
    }

    public XmlArgException(String option, int argIndex, String message, Element path) {
        super(message, (Node)path);
        this.mOption = option;
        this.mArgIndex = argIndex;
    }

    public XmlArgException(int argIndex, String message, String path) {
        this(ARG, argIndex, message, path);
    }

    public XmlArgException(String option, String message, String path) {
        this(option, 0, message, path);
    }

    public XmlArgException(String option, int argIndex, String message, String path) {
        super(message, path);
        this.mOption = option;
        this.mArgIndex = argIndex;
    }

    public String getOption() {
        return this.mOption;
    }

    public boolean isOption() {
        return !ARG.equals(this.mOption);
    }

    public String getOptionWithIndex() {
        return this.mArgIndex == 0 ? this.getOption() : String.valueOf(this.getOption()) + "[" + this.getArgIndex() + "]";
    }

    public int getArgIndex() {
        return this.mArgIndex;
    }
}

